/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDiagramEditPart;
import org.eclipse.fordiac.ide.gef.editparts.IChildrenProvider;
import org.eclipse.fordiac.ide.gef.editparts.SpecificLayerEditPart;
import org.eclipse.fordiac.ide.gef.router.MoveableRouter;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public abstract class AbstractFBNetworkEditPart
extends AbstractDiagramEditPart
implements AnnotableGraphicalEditPart {
    private List<IChildrenProvider> childProviders = null;

    protected List<FBNetworkElement> getNetworkElements() {
        return this.getModel().getNetworkElements().stream().filter(el -> !el.isInGroup()).toList();
    }

    public FBNetwork getModel() {
        return (FBNetwork)super.getModel();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.childProviders != null) {
            this.childProviders.clear();
            this.childProviders = null;
        }
    }

    protected List<?> getModelChildren() {
        ArrayList<FBNetworkElement> children = new ArrayList<FBNetworkElement>(this.getNetworkElements());
        children.addAll(this.getFBValues());
        for (IChildrenProvider provider : this.getChildrenProviders()) {
            if (!provider.isEnabled()) continue;
            children.addAll(provider.getChildren(this.getModel()));
        }
        GraphicalAnnotationModel annotationModel = FordiacAnnotationUtil.getAnnotationModel((EditPart)this);
        if (annotationModel != null) {
            annotationModel.getAnnotations(this.getModel()).stream().filter(GraphicalAnnotationStyles::hasAnnotationEditPart).forEachOrdered(children::add);
        }
        return children;
    }

    @Override
    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        if (!event.getAdded().isEmpty() || !event.getRemoved().isEmpty()) {
            this.refreshChildren();
        }
        event.getChanged().stream().map(this.getViewer().getEditPartRegistry()::get).filter(Objects::nonNull).forEachOrdered(EditPart::refresh);
    }

    @Override
    protected ConnectionRouter createConnectionRouter(IFigure figure) {
        return new MoveableRouter();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        SpecificLayerEditPart slEP;
        String layer;
        IFigure layerFig;
        if (childEditPart instanceof SpecificLayerEditPart && (layerFig = this.getLayer(layer = (slEP = (SpecificLayerEditPart)childEditPart).getSpecificLayer())) != null) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            layerFig.add(child);
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        SpecificLayerEditPart slEP;
        String layer;
        IFigure layerFig;
        if (childEditPart instanceof SpecificLayerEditPart && (layerFig = this.getLayer(layer = (slEP = (SpecificLayerEditPart)childEditPart).getSpecificLayer())) != null) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            if (layerFig.equals(child.getParent())) {
                layerFig.remove(child);
            }
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Collection<Value> getFBValues() {
        ArrayList<Value> valueElements = new ArrayList<Value>();
        FBNetworkHelper.getBlockFBNetworkElementsFromList(this.getNetworkElements()).forEach(element -> {
            InterfaceList fbIinterface = element.getInterface();
            fbIinterface.getVisibleInputVars().stream().filter(di -> di.getValue() != null).forEach(di -> {
                boolean bl = valueElements.add(di.getValue());
            });
            fbIinterface.getInOutVars().stream().filter(di -> di.isVisible() && di.getValue() != null).forEach(di -> {
                boolean bl = valueElements.add(di.getValue());
            });
            fbIinterface.getErrorMarker().stream().filter(er -> er.getValue() != null).forEach(er -> {
                boolean bl = valueElements.add(er.getValue());
            });
        });
        return valueElements;
    }

    private List<IChildrenProvider> getChildrenProviders() {
        if (this.childProviders == null) {
            this.getExtensions();
        }
        return this.childProviders;
    }

    private void getExtensions() {
        IConfigurationElement[] elems;
        this.childProviders = new ArrayList<IChildrenProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.gef", "ChildrenProvider");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IChildrenProvider) {
                    IChildrenProvider childrenProvider = (IChildrenProvider)object;
                    this.childProviders.add(childrenProvider);
                }
            }
            catch (CoreException corex) {
                FordiacLogHelper.logError((String)"Error loading ChildrenProvider Extensions in org.eclipse.fordiac.ide.gef", (Throwable)corex);
            }
            ++n2;
        }
    }
}

