/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.nat.VariableColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VariableConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.VariableEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.VariableTableColumn;
import org.eclipse.fordiac.ide.gef.nat.VariableTreeData;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnEditableRule;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.event.DataUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommand;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class VariableWidget {
    private static final String NULL_DEFAULT = "";
    private final List<IVariableModificationListener> modificationListeners = new CopyOnWriteArrayList<IVariableModificationListener>();
    private NatTable table;
    private VariableTreeData data;

    public Composite createWidget(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        Composite buttonPanel = new Composite(composite, 0);
        GridDataFactory.swtDefaults().align(1, 128).applyTo((Control)buttonPanel);
        GridLayoutFactory.swtDefaults().applyTo(buttonPanel);
        this.data = new VariableTreeData((IColumnAccessor<Variable<?>>)new VariableColumnAccessor());
        DataLayer dataLayer = new DataLayer((IDataProvider)this.data);
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new VariableConfigLabelAccumulator());
        dataLayer.addLayerListener(this::handleDataLayerEvent);
        this.table = NatTableWidgetFactory.createTreeNatTable((Composite)composite, (DataLayer)dataLayer, (ITreeData)this.data, (IDataProvider)new NatTableColumnProvider(VariableTableColumn.DEFAULT_COLUMNS), (IEditableRule)new NatTableColumnEditableRule(IEditableRule.ALWAYS_EDITABLE, VariableTableColumn.DEFAULT_COLUMNS, VariableTableColumn.ALL_EDITABLE));
        this.table.addConfiguration((IConfiguration)new VariableEditorConfiguration((IRowDataProvider<? extends Variable<?>>)this.data));
        this.table.configure();
        Button expandAllButton = new Button(buttonPanel, 8);
        expandAllButton.setImage(FordiacImage.ICON_EXPAND_ALL.getImage());
        expandAllButton.setToolTipText(Messages.VariableWidget_ExpandAll);
        expandAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            boolean bl = this.table.doCommand((ILayerCommand)new TreeExpandAllCommand());
        }));
        Button collapseAllButton = new Button(buttonPanel, 8);
        collapseAllButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL"));
        collapseAllButton.setToolTipText(Messages.VariableWidget_CollapseAll);
        collapseAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            boolean bl = this.table.doCommand((ILayerCommand)new TreeCollapseAllCommand());
        }));
        return composite;
    }

    public void setInput(List<Variable<?>> variables) {
        this.data.setInput(variables);
        this.table.refresh();
        this.table.doCommand((ILayerCommand)new TreeCollapseAllCommand());
        if (variables.size() == 1) {
            this.table.doCommand((ILayerCommand)new TreeExpandToLevelCommand(1));
        }
    }

    public void addVariableModificationListener(IVariableModificationListener listener) {
        this.modificationListeners.add(listener);
    }

    public void removeVariableModificationListener(IVariableModificationListener listener) {
        this.modificationListeners.remove(listener);
    }

    private void handleDataLayerEvent(ILayerEvent event) {
        if (event instanceof DataUpdateEvent) {
            DataUpdateEvent dataUpdateEvent = (DataUpdateEvent)event;
            Variable variable = (Variable)this.data.getRowObject(dataUpdateEvent.getRowPosition());
            String oldValue = Objects.toString(dataUpdateEvent.getOldValue(), NULL_DEFAULT);
            String newValue = Objects.toString(dataUpdateEvent.getNewValue(), NULL_DEFAULT);
            this.modificationListeners.forEach(listener -> listener.variableModified(variable, oldValue, newValue));
        }
    }

    @FunctionalInterface
    public static interface IVariableModificationListener {
        public void variableModified(Variable<?> var1, String var2, String var3);
    }
}

