/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.gef.commands.Command;

public class ChangeAuthorCommand
extends Command
implements ScopedCommand {
    private final VersionInfo versionInfo;
    private final String newAuthor;
    private String oldAuthor;

    public ChangeAuthorCommand(VersionInfo versionInfo, String newAuthor) {
        this.versionInfo = Objects.requireNonNull(versionInfo);
        this.newAuthor = newAuthor == null ? "" : newAuthor;
    }

    public void execute() {
        this.oldAuthor = this.versionInfo.getAuthor();
        this.setNewAuthor();
    }

    public void undo() {
        this.versionInfo.setAuthor(this.oldAuthor);
    }

    public void redo() {
        this.setNewAuthor();
    }

    private void setNewAuthor() {
        this.versionInfo.setAuthor(this.newAuthor);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.versionInfo);
    }
}

