/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.ConnectionsHelper;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkElementHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public class HideConnectionCommand
extends Command
implements ScopedCommand {
    private final Connection connection;
    private final boolean isVisible;
    private final Connection resourceConn;

    public HideConnectionCommand(Connection connection, boolean isVisible) {
        this.connection = Objects.requireNonNull(connection);
        this.isVisible = isVisible;
        this.resourceConn = ConnectionsHelper.getOppositeConnection((Connection)connection);
    }

    public boolean canExecute() {
        EObject eObject = this.connection.getFBNetwork().eContainer();
        if (eObject instanceof FBNetworkElement) {
            SubApp subApp;
            FBNetworkElement fbnEl = (FBNetworkElement)eObject;
            if (fbnEl instanceof SubApp && (subApp = (SubApp)fbnEl).isTyped() || fbnEl instanceof CFBInstance) {
                return false;
            }
            return !FBNetworkElementHelper.isContainedInTypedInstance((EObject)fbnEl);
        }
        return true;
    }

    public void execute() {
        this.setVisible(this.isVisible);
    }

    public void undo() {
        this.setVisible(!this.isVisible);
    }

    public void redo() {
        this.setVisible(this.isVisible);
    }

    private void setVisible(boolean visible) {
        this.connection.setVisible(visible);
        if (this.resourceConn != null) {
            this.resourceConn.setVisible(visible);
        }
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.resourceConn != null) {
            return Set.of(this.connection, this.resourceConn);
        }
        return Set.of(this.connection);
    }
}

