/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class UtilityMarkerHelper {
    public static final String PREDECESSOR_MARKER_ID = "org.eclipse.fordiac.ide.model.ui.predecessor";
    public static final String CONNECTION_SRC_MARKER_ID = "org.eclipse.fordiac.ide.model.ui.connectionSource";

    public static EObject getMarkedElement(String markerId, EObject refElement) {
        LibraryElement libEl;
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)refElement);
        if (!(rootContainer instanceof LibraryElement) || (libEl = (LibraryElement)rootContainer).getTypeEntry() == null) {
            return null;
        }
        IFile resource = libEl.getTypeEntry().getFile();
        try {
            return Stream.of(resource.findMarkers(markerId, true, 0)).map(marker -> FordiacErrorMarker.getTargetRelative((IMarker)marker, (LibraryElement)libEl)).findAny().orElse(null);
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)"Error accessing marked element", (Exception)((Object)e));
            return null;
        }
    }

    public static void deleteElementMarker(String markerId, IResource resource) {
        FordiacMarkerHelper.updateMarkers((IResource)resource, (String)markerId, List.of(), (boolean)true);
    }

    public static void setMarkedElement(String markerId, EObject target) {
        LibraryElement libEl;
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)target);
        if (!(rootContainer instanceof LibraryElement) || (libEl = (LibraryElement)rootContainer).getTypeEntry() == null) {
            return;
        }
        IFile resource = libEl.getTypeEntry().getFile();
        ErrorMarkerBuilder markerBuilder = ErrorMarkerBuilder.createErrorMarkerBuilder((String)markerId).setType(markerId).setTarget(target).setSeverity(0);
        FordiacMarkerHelper.updateMarkers((IResource)resource, (String)markerId, List.of(markerBuilder), (boolean)true);
    }

    private UtilityMarkerHelper() {
        throw new UnsupportedOperationException();
    }
}

