/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.Objects;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class GraphicalViewerNavigationLocationData {
    private final double zoom;
    private final Point location;
    private final String selectedElementQN;

    public GraphicalViewerNavigationLocationData(GraphicalViewer viewer) {
        String string;
        EditPart ep;
        Object object;
        StructuredSelection structuredSelection;
        Object object2;
        this.zoom = GraphicalViewerNavigationLocationData.getCurrentZoom(viewer);
        this.location = GraphicalViewerNavigationLocationData.getViewerLocation(viewer);
        ISelection iSelection = viewer.getSelection();
        if (iSelection instanceof StructuredSelection && (object2 = (structuredSelection = (StructuredSelection)iSelection).getFirstElement()) instanceof EditPart && (object = (ep = (EditPart)object2).getModel()) instanceof INamedElement) {
            INamedElement ie = (INamedElement)object;
            string = ie.getQualifiedName();
        } else {
            string = null;
        }
        this.selectedElementQN = string;
    }

    public void restoreGraphicalViewerData(IEditorPart editor, EditPartViewer viewer) {
        FigureCanvas canvas;
        Control control;
        RootEditPart rootEditPart = viewer.getRootEditPart();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart rootEP = (ScalableFreeformRootEditPart)rootEditPart;
            rootEP.getZoomManager().setZoom(this.zoom);
        }
        if ((control = viewer.getControl()) instanceof FigureCanvas && !(canvas = (FigureCanvas)control).isDisposed()) {
            Display.getDefault().syncExec(() -> {
                if (!canvas.isDisposed()) {
                    viewer.flush();
                    canvas.scrollTo(this.location.x, this.location.y);
                    if (this.selectedElementQN != null) {
                        LibraryElement root = (LibraryElement)editor.getAdapter(LibraryElement.class);
                        if (root == null) {
                            return;
                        }
                        root.findByQualifiedName(this.selectedElementQN).map(arg_0 -> ((EditPartViewer)viewer).getEditPartForModel(arg_0)).filter(Objects::nonNull).forEach(arg_0 -> ((EditPartViewer)viewer).select(arg_0));
                    }
                }
            });
        }
    }

    public String getSelectedElementQN() {
        return this.selectedElementQN;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.zoom, this.selectedElementQN);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            GraphicalViewerNavigationLocationData other = (GraphicalViewerNavigationLocationData)obj;
            return this.location.equals((Object)other.location) && Double.compare(this.zoom, other.zoom) == 0 && Objects.equals(this.selectedElementQN, other.selectedElementQN);
        }
        return false;
    }

    private static double getCurrentZoom(GraphicalViewer viewer) {
        RootEditPart rootEditPart = viewer.getRootEditPart();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart rootEP = (ScalableFreeformRootEditPart)rootEditPart;
            return rootEP.getZoomManager().getZoom();
        }
        return 1.0;
    }

    private static Point getViewerLocation(GraphicalViewer viewer) {
        Control control = viewer.getControl();
        if (control instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)control;
            return canvas.getViewport().getViewLocation();
        }
        return new Point(0, 0);
    }
}

