/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.util;

import org.eclipse.fordiac.ide.model.util.ITransformer;

public class StringTransformer
implements ITransformer {
    @Override
    public Object transform(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return StringTransformer.transformString(str);
        }
        return obj;
    }

    private static String transformString(String str) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                i = StringTransformer.skipWhitespace(str, i, result);
                continue;
            }
            switch (c) {
                case '/': {
                    if (i + 1 < str.length() && str.charAt(i + 1) == '*') {
                        i = StringTransformer.skipMultiLineComment(str, i, '/');
                        break;
                    }
                    if (i + 1 < str.length() && str.charAt(i + 1) == '/') {
                        i = StringTransformer.skipSingleLineComment(str, i);
                        break;
                    }
                    result.append(c);
                    break;
                }
                case '(': {
                    if (i + 1 < str.length() && str.charAt(i + 1) == '*') {
                        i = StringTransformer.skipMultiLineComment(str, i, ')');
                        break;
                    }
                    result.append(c);
                    break;
                }
                case '\"': {
                    i = StringTransformer.processStringLiteral(str, i, result, '\"');
                    break;
                }
                case '\'': {
                    i = StringTransformer.processStringLiteral(str, i, result, '\'');
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static int skipWhitespace(String str, int i, StringBuilder result) {
        boolean startsWithIdentifier = i > 0 && StringTransformer.isIdentifierChar(str.charAt(i - 1));
        while (i < str.length() && Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        if (i < str.length() && StringTransformer.isIdentifierChar(str.charAt(i)) && startsWithIdentifier) {
            result.append(' ');
        }
        return i;
    }

    private static int skipMultiLineComment(String str, int i, char delimiter) {
        i += 2;
        while (i < str.length() - 1) {
            if (str.charAt(i) == '*' && str.charAt(i + 1) == delimiter) {
                return i + 1;
            }
            ++i;
        }
        return i;
    }

    private static int skipSingleLineComment(String str, int i) {
        i += 2;
        while (i < str.length() && str.charAt(i) != '\n' && str.charAt(i) != '\r') {
            ++i;
        }
        return i;
    }

    private static int processStringLiteral(String str, int i, StringBuilder result, char delimiter) {
        result.append(delimiter);
        ++i;
        while (i < str.length()) {
            char c = str.charAt(i);
            result.append(c);
            if (c == delimiter && str.charAt(i - 1) != '$') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static boolean isIdentifierChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }
}

