/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarkerInterfaceHelper;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.IVarElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Language;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarConfigInstance;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.model.resource.TypeImportDiagnostic;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SegmentTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public abstract class CommonElementImporter {
    private static final boolean IS_VISIBLE = false;
    private static final boolean IS_VAR_CONFIGED = true;
    private XMLStreamReader reader;
    private IFile file = null;
    private InputStream inputStream = null;
    private final TypeLibrary typeLibrary;
    private LibraryElement element;
    private final List<Resource.Diagnostic> errors;
    private final List<Resource.Diagnostic> warnings;
    private final Set<TypeEntry> dependencies;

    protected IFile getFile() {
        return this.file;
    }

    TypeLibrary getTypeLibrary() {
        return this.typeLibrary;
    }

    protected DataTypeLibrary getDataTypeLibrary() {
        return this.getTypeLibrary().getDataTypeLibrary();
    }

    public LibraryElement getElement() {
        return this.element;
    }

    protected void setElement(LibraryElement element) {
        this.element = element;
    }

    public List<Resource.Diagnostic> getErrors() {
        return this.errors;
    }

    public List<Resource.Diagnostic> getWarnings() {
        return this.warnings;
    }

    public Set<TypeEntry> getDependencies() {
        return this.dependencies;
    }

    protected CommonElementImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        Assert.isNotNull((Object)inputStream);
        this.inputStream = inputStream;
        this.typeLibrary = typeLibrary;
        this.errors = new ArrayList<Resource.Diagnostic>();
        this.warnings = new ArrayList<Resource.Diagnostic>();
        this.dependencies = new HashSet<TypeEntry>();
    }

    protected CommonElementImporter(IFile file) {
        Assert.isNotNull((Object)file);
        this.file = file;
        this.typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject());
        this.errors = new ArrayList<Resource.Diagnostic>();
        this.warnings = new ArrayList<Resource.Diagnostic>();
        this.dependencies = new HashSet<TypeEntry>();
    }

    protected CommonElementImporter(CommonElementImporter importer) {
        Assert.isNotNull((Object)importer);
        this.reader = importer.reader;
        this.file = importer.file;
        this.typeLibrary = importer.typeLibrary;
        this.element = importer.element;
        this.errors = importer.errors;
        this.warnings = importer.warnings;
        this.dependencies = importer.dependencies;
    }

    public void loadElement() throws IOException, XMLStreamException, TypeImportException {
        this.element = this.createRootModelElement();
        Throwable throwable = null;
        Object var2_3 = null;
        try (ImporterStreams streams = this.createInputStreams(this.getInputStream());){
            this.proceedToStartElementNamed(this.getStartElementName());
            this.readNameCommentAttributes(this.element);
            this.processChildren(this.getStartElementName(), this.getBaseChildrenHandler());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        try {
            return this.file.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    protected abstract LibraryElement createRootModelElement();

    protected abstract String getStartElementName();

    protected abstract IChildHandler getBaseChildrenHandler();

    protected ImporterStreams createInputStreams(InputStream fileInputStream) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.reader = factory.createXMLStreamReader(fileInputStream);
        return new ImporterStreams(fileInputStream, this.reader);
    }

    protected XMLStreamReader getReader() {
        return this.reader;
    }

    public int getLineNumber() {
        if (this.reader != null && this.reader.getLocation() != null) {
            return this.reader.getLocation().getLineNumber();
        }
        return -1;
    }

    protected void proceedToStartElementNamed(String elementName) throws XMLStreamException {
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            if (1 != event || !this.reader.getLocalName().equals(elementName)) continue;
            return;
        }
        throw new XMLStreamException("Could not find start element named: " + elementName);
    }

    protected void proceedToEndElementNamed(String elementName) throws XMLStreamException {
        do {
            if (2 != this.reader.getEventType() || !this.reader.getLocalName().equals(elementName)) continue;
            return;
        } while (this.reader.hasNext() && this.reader.next() != 0);
        throw new XMLStreamException("Could not find end element named: " + elementName);
    }

    protected void processChildren(String elementName, IChildHandler childHandler) throws XMLStreamException, TypeImportException {
        while (this.getReader().hasNext()) {
            int event = this.getReader().next();
            if (1 == event) {
                if (childHandler.checkChild(this.getReader().getLocalName())) continue;
                throw new XMLStreamException("Unexpected xml child (" + this.getReader().getLocalName() + ") found in " + elementName + this.getParseLocation());
            }
            if (2 != event) continue;
            if (this.getReader().getLocalName().equals(elementName)) break;
            throw new XMLStreamException("Unexpected xml end tag found in " + elementName + ": " + this.getReader().getLocalName() + this.getParseLocation());
        }
    }

    private String getParseLocation() {
        return " in file: " + String.valueOf(this.getFile()) + " location: " + String.valueOf(this.getReader().getLocation());
    }

    protected void parseIdentification(LibraryElement elem) throws XMLStreamException {
        String description;
        String type;
        String function;
        String applicationDomain;
        String classification;
        Identification ident = LibraryElementFactory.eINSTANCE.createIdentification();
        String standard = this.getAttributeValue("Standard");
        if (standard != null) {
            ident.setStandard(standard);
        }
        if ((classification = this.getAttributeValue("Classification")) != null) {
            ident.setClassification(classification);
        }
        if ((applicationDomain = this.getAttributeValue("ApplicationDomain")) != null) {
            ident.setApplicationDomain(applicationDomain);
        }
        if ((function = this.getAttributeValue("Function")) != null) {
            ident.setFunction(function);
        }
        if ((type = this.getAttributeValue("Type")) != null) {
            ident.setType(type);
        }
        if ((description = this.getAttributeValue("Description")) != null) {
            ident.setDescription(description);
        }
        elem.setIdentification(ident);
        this.proceedToEndElementNamed("Identification");
    }

    protected void parseVersionInfo(LibraryElement elem) throws TypeImportException, XMLStreamException {
        String remarks;
        String version;
        VersionInfo versionInfo = LibraryElementFactory.eINSTANCE.createVersionInfo();
        String organization = this.getReader().getAttributeValue("", "Organization");
        if (organization != null) {
            versionInfo.setOrganization(organization);
        }
        if ((version = this.getReader().getAttributeValue("", "Version")) == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingVersionInfo);
        }
        versionInfo.setVersion(version);
        String author = this.getReader().getAttributeValue("", "Author");
        if (author == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingAuthorInfo);
        }
        versionInfo.setAuthor(author);
        String date = this.getReader().getAttributeValue("", "Date");
        if (date != null) {
            versionInfo.setDate(date);
        }
        versionInfo.setRemarks((remarks = this.getReader().getAttributeValue("", "Remarks")) != null ? remarks : "");
        elem.getVersionInfo().add((Object)versionInfo);
        this.proceedToEndElementNamed("VersionInfo");
    }

    public void getXandY(PositionableElement positionableElement) throws TypeImportException {
        try {
            String y;
            String x = this.getAttributeValue("x");
            Position pos = LibraryElementFactory.eINSTANCE.createPosition();
            if (x != null && !x.isBlank()) {
                pos.setX(Double.parseDouble(x));
            }
            if ((y = this.getAttributeValue("y")) != null && !y.isBlank()) {
                pos.setY(Double.parseDouble(y));
            }
            positionableElement.setPosition(pos);
        }
        catch (NumberFormatException nfe) {
            throw new TypeImportException(Messages.FBTImporter_POSITION_EXCEPTION, nfe);
        }
    }

    protected void readNameCommentAttributes(INamedElement namedElement) throws TypeImportException {
        this.readNameAttribute(namedElement);
        this.readCommentAttribute(namedElement);
    }

    private void readNameAttribute(INamedElement namedElement) throws TypeImportException {
        String name = this.getAttributeValue("Name");
        if (name == null) {
            throw new TypeImportException(Messages.Import_ERROR_NameNotDefined);
        }
        namedElement.setName(name.trim());
    }

    protected void readCommentAttribute(INamedElement namedElement) {
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            namedElement.setComment(CommonElementImporter.fullyUnEscapeValue(comment));
        }
    }

    protected void parseGenericAttributeNode(ConfigurableObject confObject) throws XMLStreamException, TypeImportException {
        String typeName = this.getAttributeValue("Type");
        Attribute attribute = LibraryElementFactory.eINSTANCE.createAttribute();
        this.readNameCommentAttributes(attribute);
        AttributeDeclaration internalAttributeDecl = InternalAttributeDeclarations.getInternalAttributeByName(attribute.getName());
        if (internalAttributeDecl != null) {
            if (typeName != null && !typeName.isBlank()) {
                this.warnings.add(new TypeImportDiagnostic(MessageFormat.format(Messages.CommonElementImporter_ReservedAttributesValidation, attribute.getName(), typeName, FordiacMarkerHelper.getLocation(confObject)), attribute.getName() + " (Type=" + typeName + ")", this.getLineNumber()));
            }
            attribute.setAttributeDeclaration(internalAttributeDecl);
            attribute.setType(internalAttributeDecl.getType());
        } else if (typeName != null) {
            if (typeName.equals(IecTypes.HelperTypes.CDATA.getName())) {
                attribute.setType(IecTypes.HelperTypes.CDATA);
            } else {
                attribute.setType(this.getType(typeName, this.getDataTypeLibrary()::getType));
            }
        } else {
            AttributeTypeEntry attributeTypeEntry = this.getTypeEntry(attribute.getName(), this.getTypeLibrary()::getAttributeTypeEntry);
            if (attributeTypeEntry != null && attributeTypeEntry.getType() != null) {
                attribute.setAttributeDeclaration(attributeTypeEntry.getType());
                attribute.setType(attributeTypeEntry.getType().getType());
            } else {
                FordiacMarkerHelper.createAttributeErrorMarker(attribute, this.typeLibrary);
            }
        }
        String value = this.getAttributeValue("Value");
        if (value == null && attribute.getType() == IecTypes.ElementaryTypes.WSTRING) {
            attribute.setType(IecTypes.HelperTypes.CDATA);
        }
        if (IecTypes.HelperTypes.CDATA == attribute.getType()) {
            value = this.readCDataSection();
        }
        attribute.setValue(value);
        confObject.getAttributes().add((Object)attribute);
    }

    protected VarDeclaration parseParameter() throws TypeImportException, XMLStreamException {
        VarDeclaration variable = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        String name = this.getAttributeValue("Name");
        if (name == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterNotSet);
        }
        variable.setName(name);
        String value = this.getAttributeValue("Value");
        if (value == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterValueNotSet);
        }
        Value val = LibraryElementFactory.eINSTANCE.createValue();
        val.setValue(value);
        variable.setValue(val);
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            variable.setComment(comment);
        }
        this.processChildren("Parameter", tagName -> {
            if ("Attribute".equals(tagName)) {
                this.parseGenericAttributeNode(variable);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
        return variable;
    }

    private boolean isPinVisibilityAttribute() {
        String name = this.getAttributeValue("Name");
        String pinNameAndVisibility = this.getAttributeValue("Value");
        return name.equals("Visible") && pinNameAndVisibility != null && pinNameAndVisibility.contains(":");
    }

    protected void parsePinVisibilityAttribute(BlockFBNetworkElement block) {
        String pinNameAndVisibility = this.getAttributeValue("Value");
        String[] temp = pinNameAndVisibility.split(":");
        IInterfaceElement ie = block.getInterfaceElement(temp[0]);
        if (ie != null) {
            ie.setVisible(false);
        }
    }

    private boolean isPinVarConfigAttribute() {
        String name = this.getAttributeValue("Name");
        String pinNameAndVarConfig = this.getAttributeValue("Value");
        return name.equals("VarConfig") && pinNameAndVarConfig != null && pinNameAndVarConfig.contains(":");
    }

    protected void parsePinVarConfigAttribute(BlockFBNetworkElement block) {
        String pinNameAndVarConfig = this.getAttributeValue("Value");
        String[] temp = pinNameAndVarConfig.split(":");
        VarDeclaration inVar = block.getInterface().getVariable(temp[0]);
        if (inVar != null) {
            inVar.setVarConfig(true);
        }
    }

    protected String getAttributeValue(String attributeName) {
        return this.getReader().getAttributeValue("", attributeName);
    }

    protected CompilerInfo parseCompilerInfo() throws TypeImportException, XMLStreamException {
        String packageName;
        String classdef;
        CompilerInfo compilerInfo = LibraryElementFactory.eINSTANCE.createCompilerInfo();
        String header = this.getAttributeValue("header");
        if (header != null) {
            compilerInfo.setHeader(header);
        }
        if ((classdef = this.getAttributeValue("classdef")) != null) {
            compilerInfo.setClassdef(classdef);
        }
        if ((packageName = this.getAttributeValue("packageName")) != null) {
            compilerInfo.setPackageName(packageName);
        }
        this.processChildren("CompilerInfo", name -> {
            if ("Compiler".equals(name)) {
                this.parseCompiler(compilerInfo);
                return true;
            }
            if ("Import".equals(name)) {
                this.parseImport(compilerInfo);
                return true;
            }
            return false;
        });
        return compilerInfo;
    }

    private void parseCompiler(CompilerInfo compilerInfo) throws TypeImportException, XMLStreamException {
        String vendor;
        Compiler comp;
        block19: {
            comp = LibraryElementFactory.eINSTANCE.createCompiler();
            String language = this.getAttributeValue("Language");
            if (language == null) break block19;
            switch (language.toUpperCase()) {
                case "C": {
                    comp.setLanguage(Language.C);
                    break;
                }
                case "CPP": {
                    comp.setLanguage(Language.CPP);
                    break;
                }
                case "JAVA": {
                    comp.setLanguage(Language.JAVA);
                    break;
                }
                case "OTHER": {
                    comp.setLanguage(Language.OTHER);
                    break;
                }
                default: {
                    throw new TypeImportException(Messages.CompilableElementImporter_ERROR_UnsupportedLanguage);
                }
            }
        }
        if ((vendor = this.getAttributeValue("Vendor")) == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VendorNotSet);
        }
        comp.setVendor(vendor);
        String product = this.getAttributeValue("Product");
        if (product == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_ProductNotSet);
        }
        comp.setProduct(product);
        String version = this.getAttributeValue("Version");
        if (version == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VersionNotSet);
        }
        comp.setVersion(version);
        this.proceedToEndElementNamed("Compiler");
        compilerInfo.getCompiler().add((Object)comp);
    }

    private void parseImport(CompilerInfo compilerInfo) throws TypeImportException, XMLStreamException {
        Import imp = LibraryElementFactory.eINSTANCE.createImport();
        String declaration = this.getAttributeValue("declaration");
        if (declaration == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_DeclarationNotSet);
        }
        imp.setImportedNamespace(declaration);
        this.proceedToEndElementNamed("Import");
        compilerInfo.getImports().add((Object)imp);
    }

    protected void parseFBChildren(BlockFBNetworkElement block, String parentNodeName) throws TypeImportException, XMLStreamException {
        this.processChildren(parentNodeName, name -> switch (name) {
            case "Parameter" -> {
                this.parseParameter(block);
                yield true;
            }
            case "Attribute" -> {
                this.handleFBAttributeChild(block);
                yield true;
            }
            default -> false;
        });
    }

    public void handleFBAttributeChild(BlockFBNetworkElement block) throws XMLStreamException, TypeImportException {
        if (this.isPinCommentAttribute()) {
            this.parsePinComment(block);
        } else if (this.isPinVisibilityAttribute()) {
            this.parsePinVisibilityAttribute(block);
        } else if (this.isPinVarConfigAttribute()) {
            this.parsePinVarConfigAttribute(block);
        } else if (this.isConfigurableFbAttribute(block)) {
            this.parseConfigurableFbAttribute((ConfigurableFB)block);
        } else {
            this.parseGenericAttributeNode(block);
        }
        this.proceedToEndElementNamed("Attribute");
    }

    private boolean isPinCommentAttribute() {
        String name = this.getAttributeValue("Name");
        return "PinComment".equals(name);
    }

    private void parsePinComment(BlockFBNetworkElement block) {
        String name;
        IInterfaceElement ie;
        int splitPos;
        String value = this.getAttributeValue("Value");
        if (value != null && (splitPos = value.indexOf(58)) != -1 && (ie = block.getInterfaceElement(name = value.substring(0, splitPos))) != null) {
            String comment = value.substring(splitPos + 1);
            ie.setComment(comment);
        }
    }

    private boolean isConfigurableFbAttribute(FBNetworkElement block) {
        String name = this.getAttributeValue("Name");
        return block instanceof ConfigurableMoveFB && "DataType".equals(name) || block instanceof StructManipulator && "StructuredType".equals(name) || block instanceof Demultiplexer && "VisibleChildren".equals(name);
    }

    protected void parseConfigurableFbAttribute(ConfigurableFB block) {
        String name = this.getAttributeValue("Name");
        String datatypeName = this.getAttributeValue("Value");
        block.loadConfiguration(name, datatypeName);
        this.addDependency(block.getDataType());
    }

    protected void parseParameter(BlockFBNetworkElement block) throws TypeImportException, XMLStreamException {
        String comment;
        IInterfaceElement ie;
        String name = this.getAttributeValue("Name");
        if (name == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterNotSet);
        }
        String value = this.getAttributeValue("Value");
        if (value == null) {
            value = "";
        }
        Value val = LibraryElementFactory.eINSTANCE.createValue();
        val.setValue(value);
        if (name.contains(".") && block instanceof TypedSubApp) {
            TypedSubApp tsa = (TypedSubApp)block;
            v0 = CommonElementImporter.parsedVarConfig(tsa, name);
        } else {
            v0 = ie = CommonElementImporter.getInterfaceElement(block, name, val);
        }
        if (ie instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)ie;
            varDecl.setValue(val);
        }
        if ((comment = this.getAttributeValue("Comment")) != null) {
            ie.setComment(comment);
        }
        this.processChildren("Parameter", tagName -> {
            if ("Attribute".equals(tagName)) {
                this.parseGenericAttributeNode(ie);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
    }

    private static VarDeclaration parsedVarConfig(TypedSubApp typedSubApp, String name) {
        ArrayList<String> elements = new ArrayList<String>(List.of(name.split("\\.")));
        elements.add(0, typedSubApp.getName());
        List<String> pathSegmenents = elements.subList(0, elements.size() - 1);
        String lastPathSegment = elements.get(elements.size() - 1);
        VarDeclaration vd = CommonElementImporter.getVarConfigVD(typedSubApp, pathSegmenents, lastPathSegment);
        if (vd != null) {
            return CommonElementImporter.copyVarDeclFromType(vd, name, typedSubApp, pathSegmenents);
        }
        return vd;
    }

    private static VarDeclaration copyVarDeclFromType(VarDeclaration vd, String path, FBNetworkElement typedSubApp, List<String> pathSegmenents) {
        VarConfigInstance result = null;
        FBNetwork fbn = typedSubApp.getFbNetwork();
        ArrayList<String> parts = new ArrayList<String>(List.of(path.split("\\.")));
        for (String blockName : pathSegmenents) {
            typedSubApp = fbn.getNetworkElements().stream().filter(elem -> elem.getName().equals(blockName)).findFirst().orElse(null);
            if (typedSubApp == null) {
                return result;
            }
            if (!(typedSubApp instanceof TypedSubApp)) continue;
            TypedSubApp tsa = (TypedSubApp)typedSubApp;
            fbn = tsa.getFbNetwork();
            if (!parts.isEmpty()) {
                parts.remove(0);
            }
            String relativeName = CommonElementImporter.computeRelativeName(path, tsa.getName());
            VarConfigInstance existing = tsa.getVarConfigParams().stream().filter(v -> relativeName.equals(v.getName())).findFirst().orElse(null);
            if (existing != null) {
                result = existing;
                continue;
            }
            VarConfigInstance copy = InterfaceListCopier.copyVarConfigInstance(vd, relativeName);
            tsa.getVarConfigParams().add((Object)copy);
            result = copy;
        }
        return result;
    }

    private static String computeRelativeName(String fullName, String rootName) {
        if (fullName.startsWith(rootName + ".")) {
            return fullName.substring(rootName.length() + 1);
        }
        return fullName;
    }

    private static VarDeclaration getVarConfigVD(FBNetworkElement context, List<String> remainingPath, String lastSegment) {
        if (remainingPath.isEmpty()) {
            return null;
        }
        String currentName = remainingPath.get(0);
        List<String> nextPath = remainingPath.subList(1, remainingPath.size());
        if (context.getName().equals(currentName)) {
            return CommonElementImporter.getVarConfigVD(context, nextPath, lastSegment);
        }
        Iterable<FBNetworkElement> children = CommonElementImporter.getNetworkElements(context);
        if (children == null) {
            return null;
        }
        for (FBNetworkElement elem : children) {
            if (elem instanceof UntypedSubApp) {
                UntypedSubApp usa = (UntypedSubApp)elem;
                VarDeclaration result = CommonElementImporter.getVarConfigVD(usa, remainingPath, lastSegment);
                if (result == null) continue;
                return result;
            }
            if (!elem.getName().equals(currentName)) continue;
            if (!nextPath.isEmpty()) {
                return CommonElementImporter.getVarConfigVD(elem, nextPath, lastSegment);
            }
            if (elem instanceof FB) {
                FB fb = (FB)elem;
                return CommonElementImporter.findAndMarkVarConfig(fb.getInterface(), lastSegment);
            }
            if (!(elem instanceof TypedSubApp)) continue;
            TypedSubApp tsa = (TypedSubApp)elem;
            return CommonElementImporter.findAndMarkVarConfig(tsa.getInterface(), lastSegment);
        }
        return null;
    }

    private static VarDeclaration findAndMarkVarConfig(InterfaceList iface, String name) {
        return iface.getAllInterfaceElements().stream().filter(i -> i instanceof VarDeclaration && i.getName().equals(name)).map(VarDeclaration.class::cast).peek(vd -> vd.setVarConfig(true)).findFirst().orElse(null);
    }

    private static Iterable<FBNetworkElement> getNetworkElements(EObject element) {
        if (element instanceof UntypedSubApp) {
            UntypedSubApp usa = (UntypedSubApp)element;
            return usa.getSubAppNetwork().getNetworkElements();
        }
        if (element instanceof TypedSubApp) {
            TypedSubApp tsa = (TypedSubApp)element;
            return tsa.getType().getFBNetwork().getNetworkElements();
        }
        return null;
    }

    public static IInterfaceElement getInterfaceElement(BlockFBNetworkElement block, String name, Value val) {
        IInterfaceElement ie = block.getInterfaceElement(name);
        if (ie == null) {
            ie = CommonElementImporter.createParameterErrorMarker(block, name, val);
        }
        return ie;
    }

    protected static ErrorMarkerInterface createParameterErrorMarker(BlockFBNetworkElement block, String name, Value value) {
        ErrorMarkerInterface errorMarkerInterface = FordiacErrorMarkerInterfaceHelper.createErrorMarkerInterface(IecTypes.GenericTypes.ANY, name, true, block.getInterface());
        errorMarkerInterface.setValue(value);
        return errorMarkerInterface;
    }

    protected boolean isProfileAttribute() {
        String name = this.getAttributeValue("Name");
        return "Profile".equals(name);
    }

    protected void parseProfile(Device device) {
        String value = this.getAttributeValue("Value");
        if (value != null) {
            device.setProfile(value);
        }
    }

    protected Resource parseResource(Map<String, FBNetworkElement> fbNetworkElementMap) throws TypeImportException, XMLStreamException {
        Resource resource = LibraryElementFactory.eINSTANCE.createResource();
        resource.setDeviceTypeResource(false);
        this.readNameCommentAttributes(resource);
        this.parseResourceType(resource);
        FBNetwork fbNetwork = CommonElementImporter.createResourceTypeNetwork(resource);
        resource.setFBNetwork(fbNetwork);
        this.processChildren("Resource", name -> {
            switch (name) {
                case "FBNetwork": {
                    this.parseResourceNetwork(fbNetworkElementMap, resource, fbNetwork);
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(resource);
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                case "Parameter": {
                    VarDeclaration parameter = this.parseParameter();
                    if (parameter == null) break;
                    VarDeclaration devParam = CommonElementImporter.getParamter((EList<VarDeclaration>)resource.getVarDeclarations(), parameter.getName());
                    if (devParam != null) {
                        devParam.setValue(parameter.getValue());
                        break;
                    }
                    parameter.setIsInput(true);
                    resource.getVarDeclarations().add((Object)parameter);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return resource;
    }

    protected void parseResourceNetwork(Map<String, FBNetworkElement> fbNetworkElementMap, Resource resource, FBNetwork fbNetwork) throws TypeImportException, XMLStreamException {
        new ResDevFBNetworkImporter(this, fbNetwork, (EList<VarDeclaration>)resource.getVarDeclarations(), fbNetworkElementMap).parseFBNetwork("FBNetwork");
    }

    private void parseResourceType(Resource resource) {
        String typeName = this.getAttributeValue("Type");
        if (typeName != null) {
            ResourceTypeEntry entry = this.getTypeEntry(typeName, this.getTypeLibrary()::getResourceTypeEntry);
            if (entry != null) {
                resource.setTypeEntry(entry);
                CommonElementImporter.createParameters(resource);
            }
        }
    }

    protected String readCDataSection() throws XMLStreamException {
        StringBuilder algText = new StringBuilder();
        while (this.getReader().hasNext() && 4 == this.getReader().next()) {
            algText.append(this.getReader().getText());
        }
        return algText.toString();
    }

    public static void createParameters(IVarElement element) {
        if (element instanceof Device) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((DeviceTypeEntry)((TypedConfigureableObject)((Object)element)).getTypeEntry()).getType().getVarDeclaration()));
        }
        if (element instanceof Resource) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((ResourceTypeEntry)((TypedConfigureableObject)((Object)element)).getTypeEntry()).getType().getVarDeclaration()));
        }
        if (element instanceof Segment) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((SegmentTypeEntry)((TypedConfigureableObject)((Object)element)).getTypeEntry()).getType().getVarDeclaration()));
        }
        for (VarDeclaration varDecl : element.getVarDeclarations()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            varDecl.setValue(value);
            VarDeclaration typeVar = CommonElementImporter.getTypeVariable(varDecl);
            if (typeVar == null || typeVar.getValue() == null) continue;
            value.setValue(typeVar.getValue().getValue());
        }
    }

    private static VarDeclaration getTypeVariable(VarDeclaration variable) {
        EList<VarDeclaration> varList = null;
        EObject eObject = variable.eContainer();
        if (eObject instanceof Device) {
            Device dev = (Device)eObject;
            if (dev.getType() != null) {
                varList = dev.getType().getVarDeclaration();
            }
        } else {
            Resource res;
            EObject eObject2 = variable.eContainer();
            if (eObject2 instanceof Resource && (res = (Resource)eObject2).getType() != null) {
                varList = res.getType().getVarDeclaration();
            }
        }
        if (varList != null) {
            return CommonElementImporter.getParamter(varList, variable.getName());
        }
        return null;
    }

    protected static VarDeclaration getParamter(EList<VarDeclaration> paramList, String name) {
        for (VarDeclaration varDecl : paramList) {
            if (!varDecl.getName().equals(name)) continue;
            return varDecl;
        }
        return null;
    }

    private static FBNetwork createResourceTypeNetwork(Resource resource) {
        FBNetwork resourceFBNetwork = null;
        if (resource.getType() != null && resource.getType().getFBNetwork() != null) {
            InterfaceList il = LibraryElementFactory.eINSTANCE.createInterfaceList();
            il.getInputVars().addAll((Collection)resource.getVarDeclarations());
            resourceFBNetwork = FBNetworkHelper.createResourceFBNetwork(resource.getType().getFBNetwork(), il);
            resource.getVarDeclarations().addAll(il.getInputVars());
        } else {
            resourceFBNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        }
        return resourceFBNetwork;
    }

    protected static String fullyUnEscapeValue(String value) {
        String escapedValue = value.replace("&amp;", "&");
        escapedValue = escapedValue.replace("&lt;", "<");
        escapedValue = escapedValue.replace("&gt;", ">");
        escapedValue = escapedValue.replace("&quot;", "\"");
        escapedValue = escapedValue.replace("&apos;", "'");
        escapedValue = escapedValue.replace("&#10;", "\n");
        escapedValue = escapedValue.replace("&#9;", "\t");
        escapedValue = escapedValue.replace("\r\n", "\n");
        return escapedValue;
    }

    protected <T extends TypeEntry> T addDependency(T entry) {
        if (entry != null) {
            this.dependencies.add(entry);
        }
        return entry;
    }

    protected <T extends LibraryElement> T addDependency(T libraryElement) {
        if (libraryElement != null) {
            this.addDependency(libraryElement.getTypeEntry());
        }
        return libraryElement;
    }

    protected <T extends TypeEntry> T getTypeEntry(String name, Function<String, T> typeResolver) {
        if (name == null) {
            return null;
        }
        return (T)this.addDependency(ImportHelper.resolveImport(name, this.getElement(), typeResolver, unused -> null));
    }

    protected <T extends LibraryElement> T getType(String name, Function<String, T> typeResolver) {
        if (name == null) {
            return null;
        }
        return (T)this.addDependency(ImportHelper.resolveImport(name, this.getElement(), typeResolver, unused -> null));
    }

    protected static interface IChildHandler {
        public boolean checkChild(String var1) throws XMLStreamException, TypeImportException;
    }

    protected static final class ImporterStreams
    implements AutoCloseable {
        private final InputStream inputStream;
        private final XMLStreamReader reader;

        public ImporterStreams(InputStream inputStream, XMLStreamReader reader) {
            this.inputStream = inputStream;
            this.reader = reader;
        }

        @Override
        public void close() throws IOException, XMLStreamException {
            this.reader.close();
            this.inputStream.close();
        }
    }
}

