/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.ConcurrentNotifierImpl;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorLibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.resource.FordiacTypeResource;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.util.LibraryElementHashException;
import org.eclipse.fordiac.ide.model.util.LibraryElementHasher;
import org.eclipse.fordiac.ide.model.value.StringValueConverter;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public abstract class AbstractTypeEntryImpl
extends ConcurrentNotifierImpl
implements TypeEntry,
Adapter.Internal {
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("Name=\\\"(\\w*)\\\"");
    private static final Pattern TYPE_COMMENT_PATTERN = Pattern.compile("Comment=\\\"([^\"]*)\\\"");
    private static final Pattern TYPE_PACKAGE_NAME_PATTERN = Pattern.compile("packageName=\\\"([\\w:]*)\\\"");
    private IFile file;
    private String fullTypeName;
    private final AtomicReference<String> comment = new AtomicReference();
    private final AtomicLong lastModificationTimestamp = new AtomicLong(-1L);
    private final AtomicLong lastModificationTimestampEditable = new AtomicLong(-1L);
    private SoftReference<LibraryElement> typeRef;
    private SoftReference<String> typeHashRef;
    private final AtomicReference<Set<TypeEntry>> dependencies = new AtomicReference(Collections.emptySet());
    private boolean loading;
    private TypeLibrary typeLibrary;

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public void setFile(IFile newFile) {
        if (this.typeLibrary != null) {
            throw new IllegalStateException("Cannot change file while added to type library");
        }
        NotificationChain notifications = this.basicSetFile(newFile, null);
        if (notifications != null) {
            notifications.dispatch();
        }
    }

    protected synchronized NotificationChain basicSetFile(IFile newFile, NotificationChain notifications) {
        IFile oldFile = this.file;
        if (Objects.equals(oldFile, newFile)) {
            return notifications;
        }
        this.file = newFile;
        LibraryElement type = this.basicGetType();
        if (type != null) {
            type.eResource().setURI(this.getURI());
        }
        if (this.eNotificationRequired()) {
            notifications = AbstractTypeEntryImpl.chainNotification(notifications, new TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_FILE_FEATURE", 1, oldFile, newFile));
        }
        return notifications;
    }

    @Override
    public String getTypeName() {
        return PackageNameHelper.extractPlainTypeName(this.getFullTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFullTypeName() {
        String result = this.fullTypeName;
        if (result != null) {
            return result;
        }
        NotificationChain notifications = null;
        AbstractTypeEntryImpl abstractTypeEntryImpl = this;
        synchronized (abstractTypeEntryImpl) {
            result = this.fullTypeName;
            if (result != null) {
                return result;
            }
            result = this.loadTypeNameFromFile();
            notifications = this.basicSetFullTypeName(result, notifications);
        }
        if (notifications != null) {
            notifications.dispatch();
        }
        return result;
    }

    protected synchronized NotificationChain basicSetFullTypeName(String newFullTypeName, NotificationChain notifications) {
        Objects.requireNonNull(newFullTypeName, "New full type name must not be null");
        String oldFullTypeName = this.fullTypeName;
        if (Objects.equals(oldFullTypeName, newFullTypeName)) {
            return notifications;
        }
        if (this.typeLibrary != null && this.fullTypeName != null) {
            this.typeLibrary.removeTypeEntryNameReference(this);
        }
        this.fullTypeName = newFullTypeName;
        if (this.typeLibrary != null) {
            this.typeLibrary.addTypeEntryNameReference(this);
        }
        if (this.eNotificationRequired()) {
            notifications = AbstractTypeEntryImpl.chainNotification(notifications, new TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_FULL_TYPE_NAME_FEATURE", 7, oldFullTypeName, newFullTypeName));
        }
        return notifications;
    }

    @Override
    public String getComment() {
        String result = this.comment.get();
        if (result != null) {
            return result;
        }
        NotificationChain notifications = null;
        result = this.loadTypeCommentFromFile();
        notifications = this.basicSetComment(result, notifications);
        if (notifications != null) {
            notifications.dispatch();
        }
        return result;
    }

    protected NotificationChain basicSetComment(String newComment, NotificationChain notifications) {
        Objects.requireNonNull(newComment, "New comment must not be null");
        String oldComment = this.comment.getAndSet(newComment);
        if (!Objects.equals(oldComment, newComment) && this.eNotificationRequired()) {
            notifications = AbstractTypeEntryImpl.chainNotification(notifications, new TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_COMMENT_FEATURE", 8, oldComment, newComment));
        }
        return notifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LibraryElement getType() {
        LibraryElement type = this.basicGetType();
        if (type != null) {
            return type;
        }
        NotificationChain notifications = null;
        AbstractTypeEntryImpl abstractTypeEntryImpl = this;
        synchronized (abstractTypeEntryImpl) {
            long modificationStamp;
            type = this.basicGetType();
            if (type != null) {
                return type;
            }
            IFile fileCached = this.getFile();
            if (fileCached != null && fileCached.exists()) {
                modificationStamp = fileCached.getModificationStamp();
                type = this.loadType();
            } else {
                modificationStamp = -1L;
            }
            if (type == null) {
                type = this.createErrorLibraryElement();
                PackageNameHelper.setFullTypeName(type, this.getFullTypeName());
            }
            notifications = this.basicSetType(type, notifications);
            this.lastModificationTimestamp.set(modificationStamp);
        }
        if (notifications != null) {
            notifications.dispatch();
        }
        return type;
    }

    protected LibraryElement basicGetType() {
        SoftReference<LibraryElement> typeRefCached = this.typeRef;
        return typeRefCached != null ? typeRefCached.get() : null;
    }

    private final boolean isFileContentChanged() {
        IFile fileCached = this.getFile();
        if (fileCached != null) {
            long modificationStamp = fileCached.getModificationStamp();
            return modificationStamp != -1L && modificationStamp != this.lastModificationTimestamp.get();
        }
        return false;
    }

    @Override
    public void setType(LibraryElement newType) {
        NotificationChain notifications = this.basicSetType(newType, null);
        if (notifications != null) {
            notifications.dispatch();
        }
    }

    protected synchronized NotificationChain basicSetType(LibraryElement newType, NotificationChain notifications) {
        LibraryElement oldType;
        LibraryElement libraryElement = oldType = this.typeRef != null ? this.typeRef.get() : null;
        if (newType != null) {
            Objects.requireNonNull(newType.getName(), "No name in new type");
            this.encloseInResource(newType);
            newType.setTypeEntry(this);
            notifications = this.basicSetFullTypeName(PackageNameHelper.getFullTypeName(newType), notifications);
            notifications = this.basicSetComment(newType.getComment(), notifications);
            this.typeRef = new SoftReference<LibraryElement>(newType);
        } else {
            this.typeRef = null;
        }
        this.typeHashRef = null;
        if (this.eNotificationRequired()) {
            notifications = AbstractTypeEntryImpl.chainNotification(notifications, new TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_TYPE_FEATURE", 3, oldType, newType));
        }
        return notifications;
    }

    protected void encloseInResource(LibraryElement newType) {
        if (newType.eResource() == null) {
            new FordiacTypeResource(Objects.requireNonNullElseGet(this.getURI(), () -> URI.createFileURI((String)(newType.getName() + "." + this.getFileExtension())))).getContents().add((Object)newType);
        }
    }

    private LibraryElement loadType() {
        if (this.loading) {
            FordiacLogHelper.logWarning((String)("Circular dependency when loading type " + this.getFile().getName()));
            return null;
        }
        try {
            this.loading = true;
            CommonElementImporter importer = this.getImporter();
            importer.loadElement();
            this.updateDependencies(importer.getDependencies());
            LibraryElement retval = importer.getElement();
            retval.setTypeEntry(this);
            LibraryElement libraryElement = retval;
            return libraryElement;
        }
        catch (Exception e) {
            FordiacLogHelper.logWarning((String)("Error loading type " + this.getFile().getName() + ": " + e.getMessage()), (Exception)e);
            return null;
        }
        finally {
            this.loading = false;
        }
    }

    @Override
    public LibraryElement copyType() {
        LibraryElement copy = (LibraryElement)EcoreUtil.copy((EObject)this.getType());
        this.encloseInResource(copy);
        copy.setTypeEntry(this);
        return copy;
    }

    @Override
    public Set<TypeEntry> getDependencies() {
        if (this.getType() != null) {
            return this.dependencies.get();
        }
        return Collections.emptySet();
    }

    @Override
    public String getTypeHash() throws LibraryElementHashException {
        String typeHash;
        SoftReference<String> typeHashRefCached = this.typeHashRef;
        if (!this.isFileContentChanged() && typeHashRefCached != null && (typeHash = typeHashRefCached.get()) != null) {
            return typeHash;
        }
        String newTypeHash = this.basicGetTypeHash();
        this.typeHashRef = new SoftReference<String>(newTypeHash);
        return newTypeHash;
    }

    private String basicGetTypeHash() throws LibraryElementHashException {
        LibraryElement type = this.getType();
        if (type == null) {
            return "";
        }
        Attribute typeHashAttribute = AbstractTypeEntryImpl.getTypeHashAttribute(type);
        if (typeHashAttribute != null) {
            String value = typeHashAttribute.getValue();
            if (value.isEmpty()) {
                return value;
            }
            return StringValueConverter.INSTANCE.toValue(value);
        }
        return LibraryElementHasher.hash(type);
    }

    private static Attribute getTypeHashAttribute(LibraryElement type) {
        Attribute typeHashAttribute = type.getAttribute("eclipse4diac::core::TypeHash");
        if (typeHashAttribute != null) {
            return typeHashAttribute;
        }
        return type.getAttribute("TypeHash");
    }

    private void updateDependencies(Set<TypeEntry> dependencies) {
        Set<TypeEntry> oldDependencies = this.dependencies.getAndSet(Set.copyOf(dependencies));
        oldDependencies.stream().filter(Predicate.not(dependencies::contains)).forEachOrdered(entry -> {
            boolean bl = entry.eAdapters().remove((Object)this);
        });
        dependencies.stream().filter(Predicate.not(oldDependencies::contains)).forEachOrdered(entry -> {
            boolean bl = entry.eAdapters().add((Object)this);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanged(Notification notification) {
        if ((notification.getFeature() == "TYPE_ENTRY_TYPE_FEATURE" && !(notification.getNotifier() instanceof InterfaceTypeEntry) || notification.getFeature() == "TYPE_ENTRY_INTERFACE_FEATURE" || notification.getFeature() == "TYPE_ENTRY_TYPE_LIBRARY") && this.dependencies.get().contains(notification.getNotifier())) {
            NotificationChain notifications = null;
            AbstractTypeEntryImpl abstractTypeEntryImpl = this;
            synchronized (abstractTypeEntryImpl) {
                if (this.basicGetType() != null) {
                    notifications = this.basicSetType(null, notifications);
                }
            }
            if (notifications != null) {
                notifications.dispatch();
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public void unsetTarget(Notifier oldTarget) {
    }

    protected abstract CommonElementImporter getImporter();

    protected abstract ErrorLibraryElement createErrorLibraryElement();

    @Override
    public TypeLibrary getTypeLibrary() {
        return this.typeLibrary;
    }

    @Override
    public void setTypeLibrary(TypeLibrary newTypeLibrary) {
        TypeLibrary oldTypeLibrary = this.typeLibrary;
        this.typeLibrary = newTypeLibrary;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_TYPE_LIBRARY", 4, oldTypeLibrary, newTypeLibrary));
        }
    }

    protected void doSaveInternal(AbstractTypeExporter exporter, IProgressMonitor monitor) throws CoreException {
        InputStream fileContent;
        if (exporter != null && (fileContent = exporter.getFileContent()) != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    try {
                        this.writeToFile(fileContent, exporter, monitor);
                    }
                    finally {
                        if (fileContent != null) {
                            fileContent.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        NotificationChain notifications = null;
        AbstractTypeEntryImpl abstractTypeEntryImpl = this;
        synchronized (abstractTypeEntryImpl) {
            notifications = this.performTypeRefresh(notifications);
        }
        if (notifications != null) {
            notifications.dispatch();
        }
    }

    protected NotificationChain performTypeRefresh(NotificationChain notifications) {
        if (this.isFileContentChanged()) {
            this.loadTypeNameFromFile();
            notifications = this.basicSetType(null, notifications);
            if (this.eNotificationRequired()) {
                notifications = AbstractTypeEntryImpl.chainNotification(notifications, new TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_FILE_CONTENT_FEATURE", 2, null, null));
            }
        }
        return notifications;
    }

    @Override
    public boolean hasError() {
        return this.file == null || !this.file.exists() || this.basicGetType() instanceof ErrorLibraryElement;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (label: ");
        result.append(this.getFullTypeName());
        result.append(", file: ");
        result.append(this.file);
        result.append(", lastModificationTimestamp: ");
        result.append(this.lastModificationTimestamp);
        result.append(", lastModificationTimestampEditable: ");
        result.append(this.lastModificationTimestampEditable);
        result.append(')');
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(InputStream fileContent, AbstractTypeExporter exporter, IProgressMonitor monitor) throws CoreException {
        NotificationChain notifications = null;
        AbstractTypeEntryImpl abstractTypeEntryImpl = this;
        synchronized (abstractTypeEntryImpl) {
            IFile fileCached = this.getFile();
            if (fileCached == null) {
                return;
            }
            if (fileCached.exists()) {
                fileCached.setContents(fileContent, 3, monitor);
            } else {
                AbstractTypeEntryImpl.checkAndCreateFolderHierarchy(fileCached.getParent(), monitor);
                fileCached.create(fileContent, 3, monitor);
            }
            this.updateDependencies(exporter.getDependencies());
            long modificationStamp = fileCached.getModificationStamp();
            this.lastModificationTimestampEditable.set(modificationStamp);
            notifications = this.updateTypeOnSave(exporter.getType(), notifications);
            this.lastModificationTimestamp.set(modificationStamp);
            if (this.eNotificationRequired()) {
                notifications = AbstractTypeEntryImpl.chainNotification(notifications, new TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_FILE_CONTENT_FEATURE", 2, null, null));
            }
        }
        if (notifications != null) {
            notifications.dispatch();
        }
    }

    protected NotificationChain updateTypeOnSave(LibraryElement savedType, NotificationChain notifications) {
        return this.basicSetType((LibraryElement)EcoreUtil.copy((EObject)savedType), notifications);
    }

    private static void checkAndCreateFolderHierarchy(IContainer container, IProgressMonitor monitor) throws CoreException {
        if (container == null || container.exists()) {
            return;
        }
        AbstractTypeEntryImpl.checkAndCreateFolderHierarchy(container.getParent(), monitor);
        if (container instanceof IFolder) {
            IFolder folder = (IFolder)container;
            folder.create(true, true, monitor);
            folder.refreshLocal(0, monitor);
        }
    }

    private String loadTypeNameFromFile() {
        IFile cachedFile = this.getFile();
        if (cachedFile != null) {
            if (cachedFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (Scanner scanner = new Scanner(cachedFile.getContents());){
                        if (scanner.findWithinHorizon(TYPE_NAME_PATTERN, 0) != null) {
                            String foundTypeName = scanner.match().group(1);
                            if (scanner.findWithinHorizon(TYPE_PACKAGE_NAME_PATTERN, 0) != null) {
                                String foundPackageName = scanner.match().group(1);
                                return foundPackageName + "::" + foundTypeName;
                            }
                            return foundTypeName;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
                }
            }
            return TypeEntry.getTypeNameFromFile(cachedFile);
        }
        return "";
    }

    private String loadTypeCommentFromFile() {
        IFile cachedFile = this.getFile();
        if (cachedFile != null && cachedFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Scanner scanner = new Scanner(cachedFile.getContents());){
                    if (scanner.findWithinHorizon(TYPE_COMMENT_PATTERN, 0) != null) {
                        return scanner.match().group(1);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
            }
        }
        return "";
    }

    protected static NotificationChain chainNotification(NotificationChain notifications, TypeEntryNotificationImpl notification) {
        if (notifications == null) {
            return notification;
        }
        notifications.add((Notification)notification);
        return notifications;
    }

    protected static class TypeEntryNotificationImpl
    extends NotificationImpl {
        protected final TypeEntry notifier;
        protected final String feature;
        protected final int featureID;

        public TypeEntryNotificationImpl(TypeEntry notifier, int eventType, String feature, int featureID, Object oldValue, Object newValue) {
            super(eventType, oldValue, newValue, -1);
            this.notifier = notifier;
            this.feature = feature;
            this.featureID = featureID;
        }

        public TypeEntry getNotifier() {
            return this.notifier;
        }

        public Object getFeature() {
            return this.feature;
        }

        public int getFeatureID(Class<?> expectedClass) {
            return this.featureID;
        }
    }
}

