/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class WStringValueConverter
implements ValueConverter<String> {
    public static final WStringValueConverter INSTANCE = new WStringValueConverter();
    private static final Pattern SCANNER_PATTERN = Pattern.compile("\"(?:\\$\"|[^\"])*\"");

    private WStringValueConverter() {
    }

    @Override
    public String toValue(String string) throws IllegalArgumentException {
        int length = string.length();
        if (length < 2) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        char quote = string.charAt(0);
        if (quote != '\"') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        if (string.charAt(length - 1) != '\"') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_UnevenlyQuotedStringLiteral, string));
        }
        StringBuilder result = new StringBuilder(length - 2);
        int index = 1;
        while (index < length - 1) {
            char c = string.charAt(index);
            switch (c) {
                case '$': {
                    index = WStringValueConverter.unescape(string, index + 1, result);
                    break;
                }
                case '\"': {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
                }
                default: {
                    result.append(c);
                    ++index;
                }
            }
        }
        return result.toString();
    }

    private static int unescape(CharSequence string, int index, StringBuilder result) {
        if (index >= string.length()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, string));
        }
        switch (string.charAt(index)) {
            case '$': {
                result.append('$');
                break;
            }
            case '\"': {
                result.append('\"');
                break;
            }
            case 'L': 
            case 'N': 
            case 'l': 
            case 'n': {
                result.append('\n');
                break;
            }
            case 'P': 
            case 'p': {
                result.append('\f');
                break;
            }
            case 'R': 
            case 'r': {
                result.append('\r');
                break;
            }
            case 'T': 
            case 't': {
                result.append('\t');
                break;
            }
            default: {
                return WStringValueConverter.unescapeHexValue(string, index, result);
            }
        }
        return index + 1;
    }

    private static int unescapeHexValue(CharSequence string, int index, StringBuilder result) {
        if (index + 4 > string.length()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, string));
        }
        int digit1 = Character.digit(string.charAt(index), 16);
        int digit2 = Character.digit(string.charAt(index + 1), 16);
        int digit3 = Character.digit(string.charAt(index + 2), 16);
        int digit4 = Character.digit(string.charAt(index + 3), 16);
        if (digit1 < 0 || digit2 < 0 || digit3 < 0 || digit4 < 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, string));
        }
        result.append((char)(digit1 << 12 | digit2 << 8 | digit3 << 4 | digit4));
        return index + 4;
    }

    @Override
    public String toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        return (String)this.toValue(scanner, SCANNER_PATTERN);
    }

    @Override
    public String toString(String value) {
        int length = value.length();
        StringBuilder result = new StringBuilder(length + 2);
        result.append('\"');
        value.chars().forEachOrdered(c -> WStringValueConverter.escape(c, result));
        result.append('\"');
        return result.toString();
    }

    protected static void escape(int value, StringBuilder result) {
        switch (value) {
            case 36: {
                result.append("$$");
                break;
            }
            case 34: {
                result.append("$\"");
                break;
            }
            case 10: {
                result.append("$L");
                break;
            }
            case 12: {
                result.append("$P");
                break;
            }
            case 13: {
                result.append("$R");
                break;
            }
            case 9: {
                result.append("$T");
                break;
            }
            default: {
                if (value >= 32 && value <= 126) {
                    result.append((char)value);
                    break;
                }
                WStringValueConverter.escapeHexValue(value, result);
            }
        }
    }

    private static void escapeHexValue(int value, StringBuilder result) {
        result.append(String.format("$%04X", value));
    }
}

