/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ArraySize;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.resource.STCoreResource;
import org.eclipse.fordiac.ide.structuredtextcore.ui.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.EditorDocumentChange;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ImportedNamespaceChange;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ProviderDocumentChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEditChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.edit.AttributeValueEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.edit.DataTypeEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.edit.ImportEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.edit.InitialValueEdit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.ui.refactoring2.ChangeConverter;
import org.eclipse.xtext.ui.refactoring2.ResourceURIConverter;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;

public class STCoreChangeConverter
extends ChangeConverter {
    private static final Logger LOG = Logger.getLogger(ChangeConverter.class);
    private final RefactoringIssueAcceptor issues;
    private final ResourceURIConverter resourceUriConverter;
    private final IWorkbench workbench;
    private final IGlobalServiceProvider globalServiceProvider;
    private final List<ModelEdit<?>> modelEdits = new ArrayList();

    protected STCoreChangeConverter(String name, Predicate<Change> changeFilter, RefactoringIssueAcceptor issues, ResourceURIConverter uriConverter, IWorkbench workbench, IGlobalServiceProvider globalServiceProvider) {
        super(name, changeFilter, issues, uriConverter, workbench);
        this.issues = issues;
        this.resourceUriConverter = uriConverter;
        this.workbench = workbench;
        this.globalServiceProvider = globalServiceProvider;
    }

    public Change getChange() {
        this.addChange((Change)ModelEditChange.fromModelEdits((String)Messages.STCoreChangeConverter_ModelChanges, this.modelEdits));
        this.modelEdits.clear();
        return super.getChange();
    }

    protected void _handleReplacements(IEmfResourceChange change) {
        if (change instanceof ImportedNamespaceChange) {
            ImportedNamespaceChange importedNamespaceChange = (ImportedNamespaceChange)change;
            Import imp = importedNamespaceChange.getImport();
            this.addModelEdit((ModelEdit<?>)new ImportEdit(STCoreChangeConverter.getSourceElementName((EObject)imp), LibraryElementXtextResource.getExternalURI((EObject)imp), importedNamespaceChange.getImportedNamespace()));
        }
    }

    protected void _handleReplacements(ITextDocumentChange change) {
        if (change.getReplacements().isEmpty()) {
            return;
        }
        IFile file = this.resourceUriConverter.toFile(change.getOldURI());
        if (!this.canWrite(file)) {
            this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, MessageFormat.format(Messages.STCoreChangeConverter_ReadOnly, file.getFullPath()), new Object[0]);
        }
        this.checkDerived(file);
        this.checkErrors(file);
        List<ReplaceEdit> textEdits = change.getReplacements().stream().map(replacement -> new ReplaceEdit(replacement.getOffset(), replacement.getLength(), replacement.getReplacementText())).toList();
        MultiTextEdit textEdit = new MultiTextEdit();
        textEdit.addChildren(textEdits.toArray(new TextEdit[textEdits.size()]));
        this.handleReplacements(change, (TextEdit)textEdit);
    }

    protected void handleReplacements(ITextDocumentChange change, TextEdit textEdit) {
        STCoreResource coreResource;
        XtextResource xtextResource = change.getResource();
        if (xtextResource instanceof STCoreResource && (coreResource = (STCoreResource)xtextResource).getURI().hasQuery()) {
            Value value;
            EObject eObject;
            ArraySize arraySize;
            EObject eObject2;
            EObject sourceElement = coreResource.getSourceElement();
            String sourceElementName = STCoreChangeConverter.getSourceElementName(sourceElement);
            if (sourceElement instanceof Attribute) {
                Attribute attribute = (Attribute)sourceElement;
                this.addModelEdit((ModelEdit<?>)new AttributeValueEdit(sourceElementName, LibraryElementXtextResource.getExternalURI((EObject)attribute), this.getEditedText(attribute.getValue(), textEdit)));
            } else if (sourceElement instanceof ArraySize && (eObject2 = (arraySize = (ArraySize)sourceElement).eContainer()) instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)eObject2;
                this.addModelEdit((ModelEdit<?>)new DataTypeEdit(sourceElementName, LibraryElementXtextResource.getExternalURI((EObject)varDeclaration), this.getEditedText(varDeclaration.getFullTypeName(), textEdit)));
            } else if (sourceElement instanceof Value && (eObject = (value = (Value)sourceElement).eContainer()) instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)eObject;
                this.addModelEdit((ModelEdit<?>)new InitialValueEdit(sourceElementName, LibraryElementXtextResource.getExternalURI((EObject)varDeclaration), this.getEditedText(value.getValue(), textEdit)));
            } else {
                this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, "Invalid query in ST resource: " + change.getOldURI().query(), new Object[0]);
            }
        } else {
            TextChange ltkChange = this.createDocumentChange(change);
            ltkChange.setEdit(textEdit);
            ltkChange.setTextType(change.getOldURI().fileExtension());
            this.addChange((Change)ltkChange);
        }
    }

    protected TextChange createDocumentChange(ITextDocumentChange change) {
        IDocumentProvider documentProvider;
        IFile file = this.resourceUriConverter.toFile(change.getOldURI());
        FileEditorInput editorInput = new FileEditorInput(file);
        ITextEditor editor = this.findOpenEditor((IEditorInput)editorInput);
        if (editor != null && (documentProvider = editor.getDocumentProvider()) != null) {
            return new EditorDocumentChange(change.getOldURI().lastSegment(), (IEditorPart)editor, documentProvider);
        }
        documentProvider = this.getDocumentProvider(change.getOldURI());
        if (documentProvider != null) {
            return new ProviderDocumentChange(change.getOldURI().lastSegment(), (IEditorInput)editorInput, documentProvider);
        }
        TextFileChange textFileChange = new TextFileChange(change.getOldURI().lastSegment(), file);
        textFileChange.setSaveMode(2);
        return textFileChange;
    }

    protected void addModelEdit(ModelEdit<?> edit) {
        this.modelEdits.add(edit);
    }

    protected IDocumentProvider getDocumentProvider(URI resourceURI) {
        return (IDocumentProvider)this.globalServiceProvider.findService(resourceURI, XtextDocumentProvider.class);
    }

    protected ITextEditor findOpenEditor(IFile file) {
        return this.findOpenEditor((IEditorInput)new FileEditorInput(file));
    }

    protected ITextEditor findOpenEditor(final IEditorInput editorInput) {
        if (this.workbench == null) {
            return null;
        }
        return (ITextEditor)new DisplayRunnableWithResult<ITextEditor>(){

            protected ITextEditor run() throws Exception {
                IEditorPart editorPart = STCoreChangeConverter.this.workbench.getActiveWorkbenchWindow().getActivePage().findEditor(editorInput);
                return (ITextEditor)Adapters.adapt((Object)editorPart, ITextEditor.class);
            }
        }.syncExec();
    }

    protected static String getSourceElementName(EObject element) {
        return FordiacMarkerHelper.getLocation((EObject)element);
    }

    protected String getEditedText(String original, TextEdit textEdit) {
        Document document = new Document(original);
        try {
            textEdit.apply((IDocument)document);
        }
        catch (BadLocationException | MalformedTreeException e) {
            this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, e.getMessage(), new Object[0]);
            return null;
        }
        return document.get();
    }

    protected void checkErrors(IFile file) {
        IMarker[] markers = this.findMarkers(file);
        boolean hasSyntaxErrors = false;
        boolean hasLinkingErrors = false;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                String code;
                IMarker marker = iMarkerArray[n2];
                int severity = marker.getAttribute("severity", -1);
                if (severity != 2) break block16;
                switch (code = marker.getAttribute("CODE_KEY", null)) {
                    case "org.eclipse.xtext.diagnostics.Diagnostic.Syntax": 
                    case "org.eclipse.xtext.diagnostics.Diagnostic.Syntax.Range": {
                        hasSyntaxErrors = true;
                        break;
                    }
                    case "org.eclipse.xtext.diagnostics.Diagnostic.Linking": {
                        hasLinkingErrors = true;
                        break;
                    }
                }
            }
            ++n2;
        }
        if (hasSyntaxErrors) {
            this.issues.add(RefactoringIssueAcceptor.Severity.ERROR, MessageFormat.format(Messages.STCoreChangeConverter_SyntaxErrors, file.getFullPath()), new Object[0]);
        } else if (hasLinkingErrors) {
            this.issues.add(RefactoringIssueAcceptor.Severity.WARNING, MessageFormat.format(Messages.STCoreChangeConverter_LinkingErrors, file.getFullPath()), new Object[0]);
        }
    }

    private IMarker[] findMarkers(IFile file) {
        try {
            return file.findMarkers("org.eclipse.xtext.ui.check", true, 0);
        }
        catch (CoreException e) {
            this.issues.add(RefactoringIssueAcceptor.Severity.FATAL, "Cannot retrieve markers for " + String.valueOf(file.getFullPath()), (Exception)((Object)e), LOG);
            return new IMarker[0];
        }
    }

    public static class Factory
    extends ChangeConverter.Factory {
        @Inject
        private ResourceURIConverter resourceURIConverter;
        @Inject(optional=true)
        private IWorkbench workbench;
        @Inject
        private IGlobalServiceProvider globalServiceProvider;

        public STCoreChangeConverter create(String name, Predicate<Change> changeFilter, RefactoringIssueAcceptor issues) {
            return new STCoreChangeConverter(name, changeFilter, issues, this.resourceURIConverter, this.workbench, this.globalServiceProvider);
        }
    }
}

