/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.document;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocument;

public class LibraryElementXtextDocumentUpdater
extends Job {
    private final LibraryElementChangeAdapter changeAdapter;
    private LibraryElementXtextDocument document;
    private volatile boolean paused = false;
    private long delay = 750L;

    @Inject
    public LibraryElementXtextDocumentUpdater(@Named(value="languageName") String name, LibraryElementChangeAdapterFilter filter) {
        super(name);
        this.changeAdapter = new LibraryElementChangeAdapter(this, filter);
        this.setPriority(20);
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled() || this.paused) {
            return Status.CANCEL_STATUS;
        }
        if (this.document != null) {
            this.document.internalModify(state -> {
                this.doRun((LibraryElementXtextResource)state, monitor);
                return null;
            });
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected void doRun(LibraryElementXtextResource resource, IProgressMonitor monitor) {
        resource.updateInternalLibraryElement();
    }

    public void install(LibraryElementXtextDocument document) {
        if (this.document != null) {
            this.uninstall();
        }
        this.document = document;
        this.changeAdapter.install(document);
        this.handleLibraryElementChanged();
    }

    public void uninstall() {
        this.changeAdapter.uninstall(this.document);
        this.cancel();
        this.document = null;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
        this.schedule(this.delay);
    }

    protected void handleLibraryElementChanged() {
        this.cancel();
        if (!this.paused) {
            this.schedule(this.delay);
        }
    }

    public LibraryElementXtextDocument getDocument() {
        return this.document;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public static class DefaultLibraryElementChangeAdapterFilter
    implements LibraryElementChangeAdapterFilter {
        @Override
        public boolean shouldAdapt(Notifier notifier) {
            return true;
        }

        @Override
        public boolean shouldNotify(Notification notification) {
            return !notification.isTouch();
        }
    }

    protected static class LibraryElementChangeAdapter
    extends EContentAdapter {
        private final LibraryElementXtextDocumentUpdater reconciler;
        private final LibraryElementChangeAdapterFilter filter;

        protected LibraryElementChangeAdapter(LibraryElementXtextDocumentUpdater reconciler, LibraryElementChangeAdapterFilter filter) {
            this.reconciler = reconciler;
            this.filter = filter;
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (this.filter.shouldNotify(notification)) {
                this.reconciler.handleLibraryElementChanged();
            }
        }

        public void install(LibraryElementXtextDocument document) {
            if (document != null) {
                document.readOnly(state -> {
                    EList adapters;
                    LibraryElementXtextResource libraryElementXtextResource;
                    LibraryElement libraryElement;
                    if (state instanceof LibraryElementXtextResource && (libraryElement = (libraryElementXtextResource = (LibraryElementXtextResource)state).getLibraryElement()) != null && !(adapters = libraryElement.eAdapters()).contains((Object)this)) {
                        adapters.add((Object)this);
                    }
                    return null;
                });
            }
        }

        public void uninstall(LibraryElementXtextDocument document) {
            if (document != null) {
                document.readOnly(state -> {
                    LibraryElementXtextResource libraryElementXtextResource;
                    LibraryElement libraryElement;
                    if (state instanceof LibraryElementXtextResource && (libraryElement = (libraryElementXtextResource = (LibraryElementXtextResource)state).getLibraryElement()) != null) {
                        EList adapters = libraryElement.eAdapters();
                        adapters.remove((Object)this);
                    }
                    return null;
                });
            }
        }

        protected void addAdapter(Notifier notifier) {
            if (this.filter.shouldAdapt(notifier)) {
                super.addAdapter(notifier);
            }
        }

        protected boolean useRecursion() {
            return false;
        }
    }

    @ImplementedBy(value=DefaultLibraryElementChangeAdapterFilter.class)
    public static interface LibraryElementChangeAdapterFilter {
        public boolean shouldAdapt(Notifier var1);

        public boolean shouldNotify(Notification var1);
    }
}

