/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.structuredtextcore.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElseIfPart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElsePart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.AccessMode;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreValidator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STCoreControlFlowValidator {
    private final ValidationMessageAcceptor acceptor;
    private final IssueSeverities severities;
    private Map<STVarDeclaration, VariableState> variables = new HashMap<STVarDeclaration, VariableState>();

    public STCoreControlFlowValidator(ValidationMessageAcceptor acceptor, IssueSeverities severities) {
        this.acceptor = acceptor;
        this.severities = severities;
    }

    public void validateVariableBlocks(List<? extends STVarDeclarationBlock> blocks) {
        blocks.forEach(this::validateVariableBlock);
    }

    public void validateVariableBlock(STVarDeclarationBlock block) {
        this.validateVariables((List<? extends STVarDeclaration>)block.getVarDeclarations());
    }

    public void validateVariables(List<? extends STVarDeclaration> declarations) {
        declarations.forEach(this::validateVariable);
    }

    public void validateVariable(STVarDeclaration declaration) {
        this.validateFeatureReferences((EObject)declaration);
        this.variables.put(declaration, VariableState.DEFINED);
    }

    public void validateStatements(List<? extends STStatement> statements) {
        statements.forEach(this::validateStatement);
    }

    protected Map<STVarDeclaration, VariableState> validateSubStatements(List<? extends STStatement> statements) {
        Map<STVarDeclaration, VariableState> originalVariables = this.variables;
        this.variables = new HashMap<STVarDeclaration, VariableState>(this.variables);
        statements.forEach(this::validateStatement);
        Map<STVarDeclaration, VariableState> subVariables = this.variables;
        this.variables = originalVariables;
        return subVariables;
    }

    public void validateStatement(STStatement statement) {
        STStatement sTStatement = statement;
        Objects.requireNonNull(sTStatement);
        STStatement sTStatement2 = sTStatement;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STAssignment.class, STIfStatement.class, STCaseStatement.class, STForStatement.class, STWhileStatement.class, STRepeatStatement.class}, (Object)sTStatement2, 0)) {
            case 0: {
                STAssignment assignment = (STAssignment)sTStatement2;
                this.validateStatement(assignment);
                break;
            }
            case 1: {
                STIfStatement ifStatement = (STIfStatement)sTStatement2;
                this.validateStatement(ifStatement);
                break;
            }
            case 2: {
                STCaseStatement caseStatement = (STCaseStatement)sTStatement2;
                this.validateStatement(caseStatement);
                break;
            }
            case 3: {
                STForStatement forStatement = (STForStatement)sTStatement2;
                this.validateStatement(forStatement);
                break;
            }
            case 4: {
                STWhileStatement whileStatement = (STWhileStatement)sTStatement2;
                this.validateStatement(whileStatement);
                break;
            }
            case 5: {
                STRepeatStatement repeatStatement = (STRepeatStatement)sTStatement2;
                this.validateStatement(repeatStatement);
                break;
            }
            default: {
                this.validateFeatureReferences((EObject)statement);
            }
        }
    }

    protected void validateStatement(STAssignment assignment) {
        this.validateFeatureReferences((EObject)assignment.getRight());
        this.validateFeatureReferences((EObject)assignment.getLeft());
    }

    protected void validateStatement(STIfStatement statement) {
        this.validateFeatureReferences((EObject)statement.getCondition());
        this.variables = Stream.concat(Stream.of(this.validateSubStatements((List<? extends STStatement>)statement.getStatements()), this.validateElsePart(statement.getElse())), statement.getElseifs().stream().map(this::validateElseIfPart)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, VariableState::intersect));
    }

    protected Map<STVarDeclaration, VariableState> validateElseIfPart(STElseIfPart statement) {
        this.validateFeatureReferences((EObject)statement.getCondition());
        return this.validateSubStatements((List<? extends STStatement>)statement.getStatements());
    }

    protected Map<STVarDeclaration, VariableState> validateElsePart(STElsePart statement) {
        if (statement != null) {
            return this.validateSubStatements((List<? extends STStatement>)statement.getStatements());
        }
        return this.variables;
    }

    protected void validateStatement(STCaseStatement statement) {
        this.validateFeatureReferences((EObject)statement.getSelector());
        this.variables = Stream.concat(Stream.of(this.validateElsePart(statement.getElse())), statement.getCases().stream().map(this::validateCasePart)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, VariableState::intersect));
    }

    protected Map<STVarDeclaration, VariableState> validateCasePart(STCaseCases statement) {
        statement.getConditions().forEach(this::validateFeatureReferences);
        return this.validateSubStatements((List<? extends STStatement>)statement.getStatements());
    }

    protected void validateStatement(STForStatement statement) {
        this.validateFeatureReferences((EObject)statement.getVariable());
        this.validateFeatureReferences((EObject)statement.getFrom());
        this.validateFeatureReferences((EObject)statement.getTo());
        this.validateFeatureReferences((EObject)statement.getBy());
        this.validateSubStatements((List<? extends STStatement>)statement.getStatements()).forEach((key, value) -> {
            VariableState variableState = this.variables.merge((STVarDeclaration)key, (VariableState)((Object)value), VariableState::intersect);
        });
        STCoreUtil.getFeaturePath((STExpression)statement.getVariable()).stream().findFirst().filter(STVarDeclaration.class::isInstance).ifPresent(controlVariable -> {
            VariableState variableState = this.variables.put((STVarDeclaration)controlVariable, VariableState.UNDEFINED_AFTER_FOR);
        });
    }

    protected void validateStatement(STWhileStatement statement) {
        this.validateFeatureReferences((EObject)statement.getCondition());
        this.validateSubStatements((List<? extends STStatement>)statement.getStatements()).forEach((key, value) -> {
            VariableState variableState = this.variables.merge((STVarDeclaration)key, (VariableState)((Object)value), VariableState::intersect);
        });
        this.validateFeatureReferences((EObject)statement.getCondition());
    }

    protected void validateStatement(STRepeatStatement statement) {
        this.validateSubStatements((List<? extends STStatement>)statement.getStatements()).forEach((key, value) -> {
            VariableState variableState = this.variables.merge((STVarDeclaration)key, (VariableState)((Object)value), VariableState::intersect);
        });
        this.validateFeatureReferences((EObject)statement.getCondition());
    }

    protected void validateFeatureReferences(EObject container) {
        if (container != null) {
            EcoreUtil2.eAllOfType((EObject)container, STFeatureExpression.class).forEach(this::validateFeatureReference);
        }
    }

    protected void validateFeatureReference(STFeatureExpression expression) {
        this.validateAccess(expression.getFeature(), STCoreUtil.getAccessMode((STExpression)expression), (EObject)expression);
    }

    protected void validateAccess(INamedElement feature, AccessMode mode, EObject context) {
        switch (mode) {
            case READ: {
                this.validateReadAccess(feature, context);
                break;
            }
            case WRITE: {
                this.validateWriteAccess(feature, context);
                break;
            }
            case READ_WRITE: {
                this.validateReadAccess(feature, context);
                this.validateWriteAccess(feature, context);
                break;
            }
        }
    }

    protected void validateReadAccess(INamedElement feature, EObject context) {
        if (this.variables.get(feature) == VariableState.UNDEFINED_AFTER_FOR) {
            this.addIssue(MessageFormat.format(Messages.STCoreControlFlowValidator_VariableUndefinedAfterForLoop, feature.getName()), context, null, -1, "org.eclipse.fordiac.ide.structuredtextcore.forControlVariableUndefined", new String[0]);
        }
    }

    protected void validateWriteAccess(INamedElement feature, EObject context) {
        if (feature instanceof STVarDeclaration) {
            STVarDeclaration stVarDeclaration = (STVarDeclaration)feature;
            this.variables.put(stVarDeclaration, VariableState.DEFINED);
        }
    }

    protected void addIssue(String message, EObject source, EStructuralFeature feature, int index, String issueCode, String ... issueData) {
        STCoreValidator.addIssue(this.acceptor, this.severities, message, source, feature, index, issueCode, issueData);
    }

    public static enum VariableState {
        DEFINED,
        UNDEFINED_AFTER_FOR;


        public VariableState intersect(VariableState other) {
            return VariableState.values()[this.ordinal() | other.ordinal()];
        }
    }
}

