/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import java.util.Collection;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.AttributeInheritMode;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.commands.Command;

public class ResourceCreateCommand
extends Command {
    private final ResourceTypeEntry entry;
    private Resource resource;
    private final Device device;
    private final boolean deviceTypeRes;
    private int index = -1;

    public ResourceCreateCommand(ResourceTypeEntry entry, Device device, boolean deviceTypeRes) {
        this.entry = entry;
        this.device = device;
        this.deviceTypeRes = deviceTypeRes;
    }

    public ResourceCreateCommand(ResourceTypeEntry entry, Device device, int index, boolean deviceTypeRes) {
        this.entry = entry;
        this.device = device;
        this.index = index;
        this.deviceTypeRes = deviceTypeRes;
    }

    public void execute() {
        this.resource = LibraryElementFactory.eINSTANCE.createResource();
        this.resource.setDeviceTypeResource(this.deviceTypeRes);
        this.resource.setTypeEntry((TypeEntry)this.entry);
        this.createResourceInputs();
        this.resource.setFBNetwork(this.createResourceFBNetwork());
        if (this.index < 0 || this.index > this.device.getResource().size()) {
            this.index = this.device.getResource().size();
        }
        this.device.getResource().add(this.index, (Object)this.resource);
        this.resource.setName(NameRepository.createUniqueName((INamedElement)this.resource, (String)this.entry.getTypeName()));
        AttributeInheritMode.copyAttributeValuesFromType((TypedConfigureableObject)this.resource);
    }

    public void undo() {
        this.device.getResource().remove((Object)this.resource);
    }

    public void redo() {
        this.device.getResource().add(this.index, (Object)this.resource);
    }

    private void createResourceInputs() {
        this.resource.getVarDeclarations().addAll(EcoreUtil.copyAll((Collection)this.entry.getType().getVarDeclaration()));
        for (VarDeclaration element : this.resource.getVarDeclarations()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            element.setValue(value);
        }
    }

    private FBNetwork createResourceFBNetwork() {
        FBNetwork resourceFBNetwork = null;
        if (this.entry.getType().getFBNetwork() != null) {
            InterfaceList il = LibraryElementFactory.eINSTANCE.createInterfaceList();
            il.getInputVars().addAll((Collection)this.resource.getVarDeclarations());
            resourceFBNetwork = FBNetworkHelper.createResourceFBNetwork((FBNetwork)this.entry.getType().getFBNetwork(), (InterfaceList)il);
            this.resource.getVarDeclarations().addAll((Collection)il.getInputVars());
        } else {
            resourceFBNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        }
        return resourceFBNetwork;
    }

    public Resource getResource() {
        return this.resource;
    }
}

