/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.SystemExplorerCopyAction;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.SystemExplorerPasteAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.ide.ResourceSelectionUtil;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class SystemExplorerEditActionProvider
extends CommonActionProvider {
    private IAction copyPackageAction;
    private Clipboard clipboard;
    private SystemExplorerCopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private SystemExplorerPasteAction pasteAction;
    private Shell shell;

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void init(ICommonActionExtensionSite aSite) {
        ICommonViewerSite viewSite = aSite.getViewSite();
        this.shell = viewSite.getShell();
        this.makeEditActions();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)viewSite;
            this.copyPackageAction = new CopyPackageNameAction(workbenchSite.getSelectionProvider());
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
        this.copyAction.selectionChanged(selection);
        menu.appendToGroup("group.edit", (IAction)this.copyAction);
        if (this.copyPackageAction.isEnabled()) {
            menu.appendToGroup("group.edit", this.copyPackageAction);
        }
        this.pasteAction.selectionChanged(selection);
        menu.appendToGroup("group.edit", (IAction)this.pasteAction);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(selection);
            menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.updateActionBars();
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeEditActions() {
        this.clipboard = new Clipboard(this.shell.getDisplay());
        this.pasteAction = new SystemExplorerPasteAction(this.shell, this.clipboard);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new SystemExplorerCopyAction(this.shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.deleteAction = new DeleteResourceAction(() -> this.shell);
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
    }

    private class CopyPackageNameAction
    extends Action {
        private final ISelectionProvider selectionProvider;

        public CopyPackageNameAction(ISelectionProvider selectionProvider) {
            this.setText(Messages.SystemExplorer_CopyPackageNameAction);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
            this.selectionProvider = selectionProvider;
        }

        public boolean isEnabled() {
            return this.getTypeEntry() != null;
        }

        public void run() {
            TypeEntry typeEntry = this.getTypeEntry();
            if (typeEntry == null) {
                return;
            }
            String packName = PackageNameHelper.getContainerPackageName((EObject)typeEntry.getType());
            if (packName == null || packName.isEmpty()) {
                packName = " ";
            }
            SystemExplorerEditActionProvider.this.clipboard.setContents(new Object[]{packName}, new Transfer[]{TextTransfer.getInstance()});
        }

        private TypeEntry getTypeEntry() {
            Object object;
            IStructuredSelection sel;
            ISelection selection = this.selectionProvider.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1 && (object = sel.getFirstElement()) instanceof IFile) {
                IFile file = (IFile)object;
                return TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            }
            return null;
        }
    }
}

