/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.application.editors.ApplicationEditor;
import org.eclipse.fordiac.ide.application.editors.SubAppNetworkEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeInstanceViewer;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.DiagramOutlinePage;
import org.eclipse.fordiac.ide.gef.commands.OperationHistoryCommandStack;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListenerManager;
import org.eclipse.fordiac.ide.model.edit.ITypeEntryEditor;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementActivationListener;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementStateListener;
import org.eclipse.fordiac.ide.model.ui.editors.SubEditorInput;
import org.eclipse.fordiac.ide.model.ui.listeners.EditorTabCommandStackListener;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceDiagramEditor;
import org.eclipse.fordiac.ide.subapptypeeditor.viewer.SubappInstanceViewer;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditor;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.editors.SystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.ui.providers.AutomationSystemProviderAdapterFactory;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.StyledSystemLabelProvider;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.widget.SelectionTabbedPropertySheetPage;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class AutomationSystemEditor
extends AbstractBreadCrumbEditor
implements ITypeEntryEditor {
    private AutomationSystem system;
    private final OperationHistoryCommandStack commandStack = new OperationHistoryCommandStack();
    private final LibraryElementStateListener elementStateListener = new EditorStateListener();
    private LibraryElementActivationListener activationListener;
    private DiagramOutlinePage outlinePage;
    private Composite mainComposite;

    public AutomationSystemEditor() {
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)new EditorTabCommandStackListener((INavigationLocationProvider)this));
        QualNameChangeListenerManager.addCommandStackEventListener((CommandStack)this.getCommandStack());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        LibraryElementProvider.INSTANCE.addLibraryElementStateListener(this.elementStateListener);
        this.activationListener = new LibraryElementActivationListener((IEditorPart)this);
    }

    public void createPartControl(Composite parent) {
        this.mainComposite = parent;
        this.createEditorContent();
    }

    private void createEditorContent() {
        if (this.system != null) {
            super.createPartControl(this.mainComposite);
        } else {
            this.showLoadErrorMessage(this.mainComposite);
        }
    }

    private void clearEditorContent() {
        this.getModelToEditorNumMapping().clear();
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            this.removePage(i);
            --i;
        }
        this.pages.clear();
        Control[] controlArray = this.mainComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.mainComposite.layout(true, true);
    }

    public void showLoadErrorMessage(Composite parent) {
        SystemEntry entry = this.getTypeEntry();
        boolean fileExists = entry != null && entry.getFile() != null && entry.getFile().exists();
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(fileExists ? 3 : 2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)composite);
        Image image = Display.getDefault().getSystemImage(1);
        Label imageLabel = new Label(composite, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText(MessageFormat.format(Messages.AutomationSystemEditor_CouldNotLoadSystem, this.getEditorInput().getName()));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)messageLabel);
        if (fileExists) {
            Button textEditorButton = new Button(composite, 0);
            textEditorButton.setText(Messages.AutomationSystemEditor_OpenTextEditor);
            textEditorButton.addListener(13, e -> {
                IEditorPart iEditorPart = EditorUtils.openTextEditor((IEditorInput)this.getEditorInput());
            });
        }
    }

    public String getTitleToolTip() {
        String tooltip = this.system != null ? this.system.getTypeEntry().getFullTypeName() + "\n" : "";
        return tooltip + super.getTitleToolTip();
    }

    protected Composite createPageContainer(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayoutData((Object)new GridData(1808));
        return pageContainer;
    }

    protected void addPages() {
        try {
            int pagenum = this.addPage((IEditorPart)new SystemEditor(), this.getEditorInput());
            this.getModelToEditorNumMapping().put(this.system, pagenum);
        }
        catch (PartInitException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (-1 != newPageIndex && this.outlinePage != null) {
            GraphicalViewer viewer = (GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class);
            this.outlinePage.viewerChanged(viewer);
        }
    }

    protected EditorPart createEditorPart(Object model) {
        SystemEditor systemEditor;
        Object object;
        Object object2 = object = model;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IFile.class, CFBInstance.class, TypedSubApp.class, UntypedSubApp.class, UntypedSubApp.class, Application.class, SystemConfiguration.class, Device.class, Resource.class}, (Object)object2, n)) {
                case 0: {
                    IFile file = (IFile)object;
                    systemEditor = new SystemEditor();
                    break block11;
                }
                case 1: {
                    CFBInstance cfb = (CFBInstance)object;
                    systemEditor = new CompositeInstanceViewer();
                    break block11;
                }
                case 2: {
                    TypedSubApp subApp = (TypedSubApp)object;
                    systemEditor = new SubappInstanceViewer();
                    break block11;
                }
                case 3: {
                    UntypedSubApp subApp = (UntypedSubApp)object;
                    if (!subApp.isContainedInTypedInstance()) {
                        object2 = object;
                        n = 4;
                        continue block11;
                    }
                    systemEditor = new SubappInstanceViewer();
                    break block11;
                }
                case 4: {
                    UntypedSubApp subApp = (UntypedSubApp)object;
                    systemEditor = new SubAppNetworkEditor();
                    break block11;
                }
                case 5: {
                    Application application = (Application)object;
                    systemEditor = new ApplicationEditor();
                    break block11;
                }
                case 6: {
                    SystemConfiguration systemConfiguration = (SystemConfiguration)object;
                    systemEditor = new SystemConfigurationEditor();
                    break block11;
                }
                case 7: {
                    Device device = (Device)object;
                    systemEditor = new SystemConfigurationEditor();
                    break block11;
                }
                case 8: {
                    Resource resource = (Resource)object;
                    systemEditor = new ResourceDiagramEditor();
                    break block11;
                }
                default: {
                    systemEditor = null;
                }
            }
            break;
        }
        return systemEditor;
    }

    protected IEditorInput createEditorInput(Object model) {
        Object object = model;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Device.class}, (Object)object, 0)) {
            case 0 -> {
                Device device = (Device)object;
                yield new SubEditorInput(this.getEditorInput(), (EObject)device.getSystemConfiguration());
            }
            default -> super.createEditorInput(model);
        };
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.system != null) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)this.getFile().getParent()){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    LibraryElementProvider.INSTANCE.saveLibraryElement(AutomationSystemEditor.this.getEditorInput(), monitor);
                }
            };
            try {
                operation.run(monitor);
            }
            catch (InvocationTargetException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.getCommandStack().markSaveLocation();
        }
    }

    protected AdapterFactoryContentProvider createBreadcrumbContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)new AutomationSystemProviderAdapterFactory());
    }

    protected AdapterFactoryLabelProvider createBreadcrumbLabelProvider() {
        return new StyledSystemLabelProvider();
    }

    protected Object getInitialModel(String itemPath) {
        String searchPath;
        EObject targetmodel;
        String[] nameList;
        if (itemPath != null && (nameList = itemPath.split("\\.")).length > 1 && (targetmodel = FBNetworkHelper.getModelFromHierarchicalName((String)(searchPath = itemPath.substring(itemPath.indexOf(46) + 1)), (AutomationSystem)this.system)) != null) {
            return targetmodel;
        }
        return this.system;
    }

    public void doSaveAs() {
        if (this.system == null) {
            return;
        }
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalName(this.getFile().getName());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path == null) {
            return;
        }
        IPath fullPath = this.getFile().getFullPath();
        if (fullPath.equals((Object)path)) {
            this.doSave(null);
            return;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)file.getParent()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                AutomationSystemEditor.this.system.setName(TypeEntry.getTypeNameFromFile((IFile)file));
                TypeEntry newSystemEntry = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject()).createTypeEntry(file);
                newSystemEntry.save((LibraryElement)AutomationSystemEditor.this.system, monitor);
                AutomationSystemEditor.this.setInput((IEditorInput)new FileEditorInput(file));
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new SelectionTabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null && this.system != null) {
                this.outlinePage = new DiagramOutlinePage((GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class));
            }
            return adapter.cast(this.outlinePage);
        }
        if (adapter == AutomationSystem.class || adapter == LibraryElement.class) {
            return adapter.cast(this.system);
        }
        if (adapter == GraphicalAnnotationModel.class) {
            return adapter.cast(LibraryElementProvider.INSTANCE.getAnnotationModel(this.getEditorInput()));
        }
        return (T)super.getAdapter(adapter);
    }

    public OperationHistoryCommandStack getCommandStack() {
        return this.commandStack;
    }

    public String getContributorId() {
        return "org.eclipse.fordiac.ide.application.editors.DiagramEditor";
    }

    private IFile getFile() {
        return this.system.getTypeEntry().getFile();
    }

    public void dispose() {
        super.dispose();
        if (this.getCommandStack() != null) {
            this.commandStack.dispose();
        }
        if (this.activationListener != null) {
            this.activationListener.dispose();
            this.activationListener = null;
        }
        LibraryElementProvider.INSTANCE.disconnect(this.getEditorInput());
        LibraryElementProvider.INSTANCE.removeLibraryElementStateListener(this.elementStateListener);
    }

    private SystemEntry getTypeEntry() {
        if (this.system != null) {
            return (SystemEntry)this.system.getTypeEntry();
        }
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)iEditorInput;
            return (SystemEntry)TypeLibraryManager.INSTANCE.getTypeEntryForFile(fileInput.getFile());
        }
        return null;
    }

    public void reloadType() {
        try {
            LibraryElementProvider.INSTANCE.resetLibraryElement(this.getEditorInput(), null);
            this.system = (AutomationSystem)LibraryElementProvider.INSTANCE.getElement(this.getEditorInput(), AutomationSystem.class);
            this.commandStack.setUndoContext(LibraryElementProvider.INSTANCE.getUndoContext(this.getEditorInput()));
        }
        catch (ClassCastException | CoreException e) {
            this.system = null;
            this.commandStack.setUndoContext((IUndoContext)new UndoContext());
        }
        this.clearEditorContent();
        this.createEditorContent();
        if (this.system == null) {
            return;
        }
        this.setPartName(this.system.getName());
        this.restoreOpenEditor();
    }

    protected void restoreOpenEditor() {
        String path = this.getBreadcrumb().serializePath();
        boolean opened = this.getBreadcrumb().openPath(path, this.system);
        if (!opened) {
            if (!this.system.getApplication().isEmpty()) {
                OpenListenerManager.openEditor((EObject)((EObject)this.system.getApplication().get(0)));
                this.showReloadErrorMessage(path, Messages.AutomationSystemEditor_ShowingFirstApplication);
            } else {
                OpenListenerManager.openEditor((EObject)this.system);
                this.showReloadErrorMessage(path, Messages.AutomationSystemEditor_ShowingSystem);
            }
        }
        this.selectRootModelOfEditor();
    }

    public void setInput(IEditorInput input) {
        try {
            LibraryElementProvider.INSTANCE.disconnect(this.getEditorInput());
            LibraryElementProvider.INSTANCE.connect(input);
            this.system = (AutomationSystem)LibraryElementProvider.INSTANCE.getElement(input, AutomationSystem.class);
            this.commandStack.setUndoContext(LibraryElementProvider.INSTANCE.getUndoContext(input));
        }
        catch (ClassCastException | CoreException e) {
            this.system = null;
            this.commandStack.setUndoContext((IUndoContext)new UndoContext());
        }
        this.setPartName(TypeEntry.getTypeNameFromFileName((String)input.getName()));
        super.setInput(input);
    }

    private void selectRootModelOfEditor() {
        Display.getDefault().asyncExec(() -> {
            GraphicalViewer viewer = this.getAdapter(GraphicalViewer.class);
            if (viewer != null) {
                Object selection = this.getSelection(viewer);
                EditorUtils.refreshPropertySheetWithSelection((IEditorPart)this, (EditPartViewer)viewer, (Object)selection);
            }
        });
    }

    private Object getSelection(GraphicalViewer viewer) {
        RootEditPart selection = null;
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof DiagramEditorWithFlyoutPalette) {
            DiagramEditorWithFlyoutPalette diagramEditor = (DiagramEditorWithFlyoutPalette)activeEditor;
            selection = viewer.getEditPartForModel(diagramEditor.getModel());
        }
        if (selection == null) {
            selection = viewer.getRootEditPart();
        }
        return selection;
    }

    protected class EditorStateListener
    implements LibraryElementStateListener {
        protected EditorStateListener() {
        }

        public void elementDirtyStateChanged(IEditorInput input, boolean isDirty) {
            if (input.equals(AutomationSystemEditor.this.getEditorInput())) {
                AutomationSystemEditor.this.firePropertyChange(257);
            }
        }

        public void elementContentReplaced(IEditorInput input) {
            if (!input.equals(AutomationSystemEditor.this.getEditorInput())) {
                return;
            }
            LibraryElement newType = LibraryElementProvider.INSTANCE.getLibraryElement(AutomationSystemEditor.this.getEditorInput());
            AutomationSystemEditor.this.commandStack.setUndoContext(LibraryElementProvider.INSTANCE.getUndoContext(AutomationSystemEditor.this.getEditorInput()));
            AutomationSystemEditor.this.clearEditorContent();
            AutomationSystemEditor.this.createEditorContent();
            AutomationSystemEditor.this.setPartName(newType.getName());
            AutomationSystemEditor.this.restoreOpenEditor();
        }

        public void elementDeleted(IEditorInput input) {
            if (input.equals(AutomationSystemEditor.this.getEditorInput())) {
                AutomationSystemEditor.this.close(false);
            }
        }

        public void elementMoved(IEditorInput originalInput, IEditorInput movedInput) {
            if (originalInput.equals(AutomationSystemEditor.this.getEditorInput())) {
                AutomationSystemEditor.this.setInput(movedInput);
            }
        }
    }
}

