/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;
import org.eclipse.xtext.scoping.ICaseInsensitivityHelper;
import org.eclipse.xtext.scoping.impl.CaseInsensitivityHelper;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper;
import org.eclipse.xtext.validation.UniqueInResourceContext;

@Beta
public class DefaultUniqueNameContext
implements INamesAreUniqueValidationHelper.Context {
    private final IResourceDescription resourceDescription;
    private final ISelectable validationScope;
    private final CancelIndicator cancelIndicator;
    private final ICaseInsensitivityHelper caseInsensitivityHelper;

    public DefaultUniqueNameContext(IResourceDescription resourceDescription, ISelectable validationScope, ICaseInsensitivityHelper caseInsensitivityHelper, CancelIndicator cancelIndicator) {
        this.resourceDescription = resourceDescription;
        this.validationScope = validationScope;
        this.caseInsensitivityHelper = caseInsensitivityHelper;
        this.cancelIndicator = cancelIndicator;
    }

    @Override
    public ISelectable getValidationScope(IEObjectDescription description, EClass clusterType) {
        return this.validationScope;
    }

    @Override
    public boolean isCaseSensitive(EObject object, EClass clusterType) {
        return !this.caseInsensitivityHelper.isIgnoreCase(object.eContainmentFeature());
    }

    @Override
    public Iterable<IEObjectDescription> getObjectsToValidate() {
        return this.resourceDescription.getExportedObjects();
    }

    @Override
    public CancelIndicator cancelIndicator() {
        return this.cancelIndicator;
    }

    public static abstract class BaseContextProvider
    implements INamesAreUniqueValidationHelper.ContextProvider {
        @Inject
        private IResourceServiceProvider.Registry resourceServiceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
        @Inject
        private ICaseInsensitivityHelper caseInsensitivityHelper = new CaseInsensitivityHelper();

        protected IResourceServiceProvider getResourceServiceProvider(Resource r) {
            return this.resourceServiceProviderRegistry.getResourceServiceProvider(r.getURI());
        }

        protected IResourceDescription getResourceDescription(Resource resource) {
            IResourceDescription.Manager manager = this.getResourceDescriptionManager(resource);
            if (manager != null) {
                return manager.getResourceDescription(resource);
            }
            return null;
        }

        protected IResourceDescription.Manager getResourceDescriptionManager(Resource resource) {
            IResourceServiceProvider resourceServiceProvider = this.getResourceServiceProvider(resource);
            if (resourceServiceProvider == null) {
                return null;
            }
            return resourceServiceProvider.getResourceDescriptionManager();
        }

        protected ICaseInsensitivityHelper getCaseInsensitivityHelper() {
            return this.caseInsensitivityHelper;
        }

        protected void setResourceServiceProviderRegistry(IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
            this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
        }
    }

    public static abstract class BaseGlobalContextProvider
    extends BaseContextProvider {
        @Inject
        private IResourceDescriptionsProvider indexAccess;

        protected IResourceDescriptions getIndex(Resource resource) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet == null) {
                return null;
            }
            return this.indexAccess.getResourceDescriptions(resourceSet);
        }

        protected boolean intersects(IResourceDescription left, IResourceDescription right, boolean caseSensitive) {
            for (IEObjectDescription description : left.getExportedObjects()) {
                Iterable<IEObjectDescription> exportedObjects = right.getExportedObjects(EcorePackage.Literals.EOBJECT, description.getName(), !caseSensitive);
                if (Iterables.isEmpty(exportedObjects)) continue;
                return true;
            }
            return false;
        }

        protected boolean isAffected(IResourceDescription.Delta delta, IResourceDescription candidate, boolean caseSensitive) {
            if (candidate.getURI().equals(delta.getUri())) {
                return false;
            }
            if (delta.getNew() != null && this.intersects(delta.getNew(), candidate, caseSensitive)) {
                return true;
            }
            return delta.getOld() != null && this.intersects(delta.getOld(), candidate, caseSensitive);
        }
    }

    @Singleton
    public static class Container
    extends BaseGlobalContextProvider {
        @Inject
        private IContainer.Manager containerManager;

        @Override
        public INamesAreUniqueValidationHelper.Context tryGetContext(Resource resource, CancelIndicator cancelIndicator) {
            IResourceDescriptions index = this.getIndex(resource);
            if (index == null) {
                return null;
            }
            IResourceDescription description = this.getResourceDescription(resource);
            if (description == null) {
                return null;
            }
            IContainer container = this.containerManager.getContainer(description, index);
            return new DefaultUniqueNameContext(description, container, this.getCaseInsensitivityHelper(), cancelIndicator);
        }

        @Override
        public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
            IContainer container = this.containerManager.getContainer(candidate, context);
            for (IResourceDescription.Delta delta : deltas) {
                if (!(delta.getNew() == null ? this.intersects(delta.getOld(), candidate, true) : container.getResourceDescription(delta.getUri()) != null && this.isAffected(delta, candidate, true))) continue;
                return true;
            }
            return false;
        }
    }

    @Singleton
    public static class ExportedFromResource
    extends BaseContextProvider {
        @Override
        public INamesAreUniqueValidationHelper.Context tryGetContext(Resource resource, CancelIndicator cancelIndicator) {
            IResourceDescription description = this.getResourceDescription(resource);
            if (description != null) {
                return new UniqueInResourceContext(description, cancelIndicator);
            }
            return null;
        }
    }

    @Singleton
    public static class Global
    extends BaseGlobalContextProvider {
        @Override
        public INamesAreUniqueValidationHelper.Context tryGetContext(Resource resource, CancelIndicator cancelIndicator) {
            IResourceDescriptions index = this.getIndex(resource);
            if (index == null) {
                return null;
            }
            IResourceDescription description = this.getResourceDescription(resource);
            if (description != null) {
                return new DefaultUniqueNameContext(description, index, this.getCaseInsensitivityHelper(), cancelIndicator);
            }
            return null;
        }

        @Override
        public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
            for (IResourceDescription.Delta delta : deltas) {
                if (!this.isAffected(delta, candidate, true)) continue;
                return true;
            }
            return false;
        }
    }

    @Singleton
    public static class VisibleContainers
    extends BaseGlobalContextProvider {
        @Inject
        private IContainer.Manager containerManager;

        @Override
        public INamesAreUniqueValidationHelper.Context tryGetContext(Resource resource, CancelIndicator cancelIndicator) {
            IResourceDescriptions index = this.getIndex(resource);
            if (index == null) {
                return null;
            }
            IResourceDescription description = this.getResourceDescription(resource);
            if (description == null) {
                return null;
            }
            List<IContainer> containers = this.containerManager.getVisibleContainers(description, index);
            return new DefaultUniqueNameContext(description, new Selectable(containers), this.getCaseInsensitivityHelper(), cancelIndicator);
        }

        @Override
        public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
            List<IContainer> containers = this.containerManager.getVisibleContainers(candidate, context);
            block0: for (IResourceDescription.Delta delta : deltas) {
                if (delta.getNew() == null) {
                    if (!this.intersects(delta.getOld(), candidate, true)) continue;
                    return true;
                }
                for (IContainer container : containers) {
                    if (container.getResourceDescription(delta.getUri()) == null) continue;
                    if (!this.isAffected(delta, candidate, true)) continue block0;
                    return true;
                }
            }
            return false;
        }

        public static class Selectable
        extends AbstractCompoundSelectable {
            private final List<IContainer> containers;

            public Selectable(List<IContainer> containers) {
                this.containers = containers;
            }

            @Override
            protected Iterable<? extends ISelectable> getSelectables() {
                return this.containers;
            }
        }
    }
}

