/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.module.main;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ide.ui.module.main.AbstractGenerator;
import org.eclipse.acceleo.aql.ide.ui.module.services.Services;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StandaloneGenerator
extends AbstractGenerator {
    private final IFile moduleFile;
    protected Module modelModule;
    protected Set<String> dependencyBundleNames;

    public StandaloneGenerator(IFile moduleFile) {
        this.moduleFile = moduleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Monitor monitor) {
        String moduleQualifiedName = this.getModuleQualifiedName();
        URI targetURI = URI.createFileURI((String)(this.moduleFile.getParent().getLocation().toFile().getAbsolutePath() + "/"));
        Map<String, String> options = this.getOptions();
        ArrayList exceptions = new ArrayList();
        ResourceSetImpl resourceSetForModels = new ResourceSetImpl();
        IQualifiedNameResolver resolver = this.createResolver();
        IQualifiedNameQueryEnvironment queryEnvironment = this.createAcceleoQueryEnvironment(options, resolver, (ResourceSet)resourceSetForModels);
        AcceleoEvaluator evaluator = this.createAcceleoEvaluator(resolver, queryEnvironment);
        IAcceleoGenerationStrategy strategy = this.createGenerationStrategy((ResourceSet)resourceSetForModels);
        Module module = (Module)resolver.resolve(moduleQualifiedName);
        Set nsURIs = AQLUtils.getAllNeededEPackages((IQualifiedNameResolver)resolver, (String)moduleQualifiedName);
        AQLUtils.registerEPackages((IQueryEnvironment)queryEnvironment, (EPackage.Registry)EPackage.Registry.INSTANCE, (Set)nsURIs);
        URI logURI = AcceleoUtil.getlogURI((URI)targetURI, (String)options.get("logURI"));
        IQualifiedNameResolver workspaceResolver = QueryPlugin.getPlugin().createQualifiedNameResolver(this.getClass().getClassLoader(), EPackage.Registry.INSTANCE, this.moduleFile.getProject(), "::", true);
        workspaceResolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), null));
        String modelModuleQualifiedName = this.getQualifiedNameFromSourceFile(this.moduleFile);
        String moduleAbsolutePath = this.moduleFile.getLocation().toFile().getAbsolutePath();
        this.modelModule = this.loadModelModule(URI.createFileURI((String)moduleAbsolutePath), modelModuleQualifiedName);
        this.dependencyBundleNames = new LinkedHashSet<String>();
        this.dependencyBundleNames.add("org.eclipse.acceleo.query;bundle-version=\"[" + this.getAQLVersionLowerBound() + "," + this.getAQLVersionUpperBound() + ")\"");
        this.dependencyBundleNames.add("org.eclipse.acceleo.aql;bundle-version=\"[" + this.getAcceleoVersionLowerBound() + "," + this.getAcceleoVersionUpperBound() + ")\"");
        this.dependencyBundleNames.add("org.eclipse.acceleo.aql.profiler;bundle-version=\"[" + this.getAcceleoVersionLowerBound() + "," + this.getAcceleoVersionUpperBound() + ")\"");
        this.dependencyBundleNames.add("org.antlr.antlr4-runtime;bundle-version=\"[" + this.getANTLRVersionLowerBound() + "," + this.getANTLRVersionUpperBound() + ")\"");
        Set modelNsURIs = AQLUtils.getAllNeededEPackages((IQualifiedNameResolver)workspaceResolver, (String)modelModuleQualifiedName);
        AQLUtils.registerEPackages((IQueryEnvironment)queryEnvironment, (EPackage.Registry)EPackage.Registry.INSTANCE, (Set)modelNsURIs);
        this.dependencyBundleNames.addAll(this.getDependencyBundleNames(queryEnvironment, this.modelModule));
        StandaloneGenerator standaloneGenerator = this;
        synchronized (standaloneGenerator) {
            this.beforeGeneration(queryEnvironment, workspaceResolver);
            try {
                AcceleoUtil.generate((AcceleoEvaluator)evaluator, (IQualifiedNameQueryEnvironment)queryEnvironment, (Module)module, (Resource)this.modelModule.eResource(), (IAcceleoGenerationStrategy)strategy, (URI)targetURI, (URI)logURI, (Monitor)monitor);
            }
            finally {
                AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
                this.printDiagnostics(evaluator.getGenerationResult());
                this.afterGeneration(evaluator.getGenerationResult());
            }
        }
    }

    protected String getModuleQualifiedName() {
        return "org::eclipse::acceleo::aql::ide::ui::module::main::standalone";
    }

    protected Map<String, String> getOptions() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put("logURI", "acceleo.log");
        res.put("newLine", System.lineSeparator());
        return res;
    }

    protected IQualifiedNameResolver createResolver() {
        ClassLoaderQualifiedNameResolver resolver = new ClassLoaderQualifiedNameResolver(this.getClass().getClassLoader(), EPackage.Registry.INSTANCE, "::");
        return resolver;
    }

    protected IQualifiedNameQueryEnvironment createAcceleoQueryEnvironment(Map<String, String> options, IQualifiedNameResolver resolver, ResourceSet resourceSetForModels) {
        IQualifiedNameQueryEnvironment queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)false);
        return queryEnvironment;
    }

    protected AcceleoEvaluator createAcceleoEvaluator(IQualifiedNameResolver resolver, IQualifiedNameQueryEnvironment queryEnvironment) {
        AcceleoEvaluator evaluator = new AcceleoEvaluator(queryEnvironment.getLookupEngine(), System.lineSeparator());
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), evaluator));
        resolver.addLoader((ILoader)new JavaLoader("::", false));
        return evaluator;
    }

    protected IAcceleoGenerationStrategy createGenerationStrategy(ResourceSet resourceSetForModels) {
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(resourceSetForModels.getURIConverter(), this.getWriterFactory());
        return strategy;
    }

    protected void beforeGeneration(IQualifiedNameQueryEnvironment queryEnvironment, IQualifiedNameResolver workspaceResolver) {
        Services.initialize(queryEnvironment, workspaceResolver);
    }

    protected void printDiagnostics(GenerationResult generationResult) {
        if (generationResult.getDiagnostic().getSeverity() > 1) {
            this.printDiagnostic(generationResult.getDiagnostic());
        }
        this.printSummary(generationResult);
    }

    protected void printDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getMessage() != null) {
            Object location = !diagnostic.getData().isEmpty() && diagnostic.getData().get(0) instanceof ASTNode ? AcceleoUtil.getLocation((ASTNode)((ASTNode)diagnostic.getData().get(0))) + ": " : "";
            switch (diagnostic.getSeverity()) {
                case 1: {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(1, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 2: {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(2, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 4: {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, diagnostic.getSource(), (String)location + diagnostic.getMessage(), diagnostic.getException()));
                }
            }
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(child);
        }
    }

    protected void printSummary(GenerationResult result) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        String message = "Files: " + result.getGeneratedFiles().size() + ", Lost Files: " + result.getLostFiles().size() + ", Errors: " + nbErrors + ", Warnings: " + nbWarnings + ", Infos: " + nbInfos + ".";
        AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(1, this.getClass(), message));
    }

    protected void afterGeneration(GenerationResult generationResult) {
        Services.initialize(null, null);
        try {
            this.moduleFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            if (this.isInPluginProject((IResource)this.moduleFile)) {
                IFile manifest = PDEProject.getManifest((IProject)this.moduleFile.getProject());
                if (manifest.isAccessible()) {
                    WorkspaceBundleModel model = new WorkspaceBundleModel(manifest);
                    model.load();
                    this.addPluginDependencies((IBundleModel)model, this.dependencyBundleNames);
                    String packageName = new Services().getJavaPackage(this.modelModule);
                    if (!packageName.isEmpty()) {
                        this.addExportPackages((IBundleModel)model, Collections.singleton(packageName));
                    }
                    StringWriter writer = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(writer);
                    model.save(printWriter);
                    this.getPreview().put(URI.createFileURI((String)manifest.getLocation().toFile().getAbsolutePath()), ((Object)writer).toString());
                }
            } else if (this.isInMavenProject((IResource)this.moduleFile)) {
                this.updateMavenPom(this.moduleFile.getProject());
            }
        }
        catch (CoreException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "could not refresh " + String.valueOf(this.moduleFile.getParent().getFullPath()), (Throwable)e));
        }
    }

    private void updateMavenPom(IProject project) {
        IFile pomFile = project.getFile("pom.xml");
        if (pomFile.isAccessible()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                Node pomProject;
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document pom = db.parse(pomFile.getContents());
                NodeList projectList = pom.getElementsByTagName("project");
                if (projectList.getLength() > 0 && (pomProject = projectList.item(0)) instanceof Element) {
                    ArrayList<AbstractGenerator.MavenDependency> dependencies = new ArrayList<AbstractGenerator.MavenDependency>();
                    dependencies.add(new AbstractGenerator.MavenDependency("org.eclipse.acceleo", "acceleo", "[" + this.getAcceleoVersionLowerBound() + "," + this.getAcceleoVersionUpperBound() + ")"));
                    boolean dependenciesUpdated = this.addMavenDependencies(pom, (Element)pomProject, dependencies);
                    boolean resourcesUpdated = this.updateResources(pom, (Element)pomProject);
                    if (dependenciesUpdated || resourcesUpdated) {
                        try {
                            Transformer tr = TransformerFactory.newInstance().newTransformer();
                            ByteArrayOutputStream ouputStream = new ByteArrayOutputStream();
                            tr.transform(new DOMSource(pom), new StreamResult(ouputStream));
                            this.getPreview().put(URI.createFileURI((String)pomFile.getLocation().toFile().getAbsolutePath()), new String(ouputStream.toByteArray()).toString());
                        }
                        catch (TransformerException te) {
                            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "can't write pom.xml file for " + String.valueOf(this.moduleFile.getParent().getFullPath()), (Throwable)te));
                        }
                    }
                }
            }
            catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
                AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "can't load pom.xml file for " + String.valueOf(this.moduleFile.getParent().getFullPath()), e));
            }
        }
    }

    private boolean updateResources(Document pom, Element project) {
        boolean resourcesCreated;
        boolean needResourceNode;
        Element resources;
        boolean buildCreated;
        Element build;
        NodeList buildList = project.getElementsByTagName("build");
        if (buildList.getLength() > 0 && buildList.item(0) instanceof Element) {
            build = (Element)buildList.item(0);
            buildCreated = false;
        } else {
            build = pom.createElement("build");
            project.appendChild(pom.createTextNode(System.lineSeparator() + System.lineSeparator() + "    "));
            build.appendChild(pom.createTextNode(System.lineSeparator() + "    "));
            project.appendChild(build);
            project.appendChild(pom.createTextNode(System.lineSeparator()));
            buildCreated = true;
        }
        NodeList resourcesList = build.getElementsByTagName("resources");
        if (resourcesList.getLength() > 0 && resourcesList.item(0) instanceof Element) {
            resources = (Element)resourcesList.item(0);
            boolean needNewResource = true;
            int i = 0;
            block0: while (i < resourcesList.getLength()) {
                if (resourcesList.item(i) instanceof Element) {
                    Element currentResources = (Element)resourcesList.item(i);
                    NodeList includeList = currentResources.getElementsByTagName("include");
                    int j = 0;
                    while (j < includeList.getLength()) {
                        Element include;
                        if (includeList.item(j) instanceof Element && (include = (Element)includeList.item(j)).getTextContent().contains("mtl")) {
                            needNewResource = false;
                            break block0;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            needResourceNode = needNewResource;
            resourcesCreated = false;
        } else {
            resources = pom.createElement("resources");
            build.appendChild(pom.createTextNode("    "));
            build.appendChild(resources);
            build.appendChild(pom.createTextNode(System.lineSeparator() + "    "));
            resourcesCreated = true;
            needResourceNode = true;
        }
        if (needResourceNode) {
            Element resource = pom.createElement("resource");
            resources.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            resources.appendChild(resource);
            resources.appendChild(pom.createTextNode(System.lineSeparator() + "        "));
            Element directory = pom.createElement("directory");
            resource.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            directory.setTextContent("${project.basedir}/src/main/java");
            resource.appendChild(directory);
            Element includes = pom.createElement("includes");
            resource.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
            resource.appendChild(includes);
            resource.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            Element include = pom.createElement("include");
            include.setTextContent("**/*.mtl");
            includes.appendChild(pom.createTextNode(System.lineSeparator() + "                    "));
            includes.appendChild(include);
            includes.appendChild(pom.createTextNode(System.lineSeparator() + "                "));
        }
        return buildCreated || resourcesCreated || needResourceNode;
    }
}

