/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import org.eclipse.acute.AcutePreferenceInitializer;
import org.eclipse.acute.AcutePreferencePage;
import org.eclipse.acute.DotnetVersionUtil;
import org.eclipse.acute.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AcutePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acute";
    private static AcutePlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AcutePlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable t) {
        AcutePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void logError(String message) {
        AcutePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static String getDotnetCommand() {
        return AcutePlugin.getDotnetCommand(true);
    }

    public static String getDotnetCommand(boolean showErrors) {
        String path = plugin.getPreferenceStore().getString(AcutePreferenceInitializer.explicitDotnetPathPreference);
        if (path.isEmpty()) {
            if (showErrors) {
                AcutePlugin.openCommandErrorDialog(Messages.dotnetNoPathError_title, Messages.dotnetNoPathError_message);
            }
        } else {
            String version = DotnetVersionUtil.getVersion(path);
            if (!DotnetVersionUtil.isValidVersionFormat(version)) {
                if (showErrors) {
                    AcutePlugin.openCommandErrorDialog(Messages.dotnetInvalidPathError_title, Messages.dotnetInvalidPathError_message);
                }
            } else if (!DotnetVersionUtil.isValidVersionNumber(version)) {
                if (showErrors) {
                    AcutePlugin.openCommandErrorDialog(Messages.dotnetInvalidVersionError_title, Messages.dotnetInvalidVersionError_message);
                }
            } else {
                return path;
            }
        }
        throw new IllegalStateException();
    }

    public static void showError(String title, String message, Exception exception) {
        AcutePlugin.showError(title, String.valueOf(message) + '\n' + exception.getLocalizedMessage());
    }

    public static void showError(String title, String message) {
        Display.getDefault().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 1, 0, new String[]{IDialogConstants.OK_LABEL});
            dialog.setBlockOnOpen(false);
            dialog.open();
        });
    }

    private static void openCommandErrorDialog(String title, String content) {
        Display.getDefault().asyncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            int dialogResponse = MessageDialog.open((int)5, (Shell)shell, (String)title, (String)content, (int)0, (String[])new String[]{Messages.acutePlugin_openPreferences, Messages.acutePlugin_cancel});
            if (dialogResponse == 0) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)AcutePreferencePage.PAGE_ID, (String[])new String[]{AcutePreferencePage.PAGE_ID}, null);
                preferenceDialog.setBlockOnOpen(false);
                preferenceDialog.open();
            }
        });
    }
}

