/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class CommandJob
extends Job {
    private Process process;
    private String[] command;
    private String progressMessage;
    private String errorTitle;
    private String errorMessage;
    private String commandID;
    private MessageConsoleStream consoleStream;
    private MessageConsole console;

    public CommandJob(String[] command, String progressMessage, String errorTitle, String errorMessage, String commandID) {
        super(progressMessage);
        this.command = command == null ? null : Arrays.copyOf(command, command.length);
        this.progressMessage = progressMessage;
        this.errorTitle = errorTitle;
        this.errorMessage = errorMessage;
        this.commandID = commandID;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)0);
        try {
            subMonitor.beginTask(this.progressMessage, 0);
            this.process = new ProcessBuilder(this.command).start();
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                CompletableFuture.runAsync(() -> reader.lines().forEachOrdered(line -> this.logToConsole((String)line)));
                if (this.process.waitFor() != 0) {
                    if (!subMonitor.isCanceled()) {
                        AcutePlugin.showError(this.errorTitle, this.errorMessage);
                    }
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            AcutePlugin.showError(this.errorTitle, this.errorMessage, e);
            return Status.CANCEL_STATUS;
        }
        catch (InterruptedException e) {
            AcutePlugin.showError(this.errorTitle, this.errorMessage, e);
            Thread.currentThread().interrupt();
            return Status.CANCEL_STATUS;
        }
    }

    private void logToConsole(String string) {
        if (this.consoleStream == null || this.consoleStream.isClosed()) {
            this.consoleStream = this.findConsole().newMessageStream();
        }
        this.consoleStream.println(string);
    }

    private MessageConsole findConsole() {
        if (this.console == null) {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            IConsole[] existing = conMan.getConsoles();
            int i = 0;
            while (i < existing.length) {
                if (this.commandID.equals(existing[i].getName())) {
                    this.console = (MessageConsole)existing[i];
                    this.console.clearConsole();
                    return this.console;
                }
                ++i;
            }
            MessageConsole myConsole = new MessageConsole(this.commandID, null);
            conMan.addConsoles(new IConsole[]{myConsole});
            this.console = myConsole;
        }
        return this.console;
    }

    protected void canceling() {
        if (this.process != null) {
            this.process.destroyForcibly();
        }
    }
}

