/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnettest;

import java.util.List;
import java.util.Map;
import org.eclipse.acute.Messages;
import org.eclipse.acute.ProjectFileAccessor;
import org.eclipse.acute.dotnettest.DotnetTestAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DotnetTestTab
extends AbstractLaunchConfigurationTab {
    private String projectConfig;
    private Path projectPath;
    private String testType;
    private Map<String, List<String>> testMethods;
    private String[] targetFrameworks;
    private String loadedSelectedTargetFramework;
    private String loadedTestsParentProject;
    private Text pathText;
    private Button runAllRadio;
    private Button runMatchingRadio;
    private Label filterLabel;
    private Text filterText;
    private Button runSelectedRadio;
    private Label classLabel;
    private Text classText;
    private Button classBrowseButton;
    private Label methodLabel;
    private Text methodText;
    private Button methodBrowseButton;
    private ListViewer frameworkViewer;
    private Button releaseRadio;
    private Button debugRadio;
    private Button buildCheckBoxButton;
    private Button restoreCheckBoxButton;

    public void createControl(Composite parent) {
        Group container = new Group(parent, 2048);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)container);
        Label pathLabel = new Label((Composite)container, 0);
        pathLabel.setText(Messages.DotnetTestTab_project);
        pathLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.pathText = new Text((Composite)container, 2048);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.pathText.addModifyListener(e -> {
            this.updateProjectPath(this.pathText.getText());
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Button browseButton = new Button((Composite)container, 0);
        browseButton.setText(Messages.DotnetTestTab_browse);
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(browseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.pathText.setText(path);
                this.updateProjectPath(path.toString());
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.runAllRadio = new Button((Composite)container, 16);
        this.runAllRadio.setText(Messages.DotnetTestTab_runAll);
        this.runAllRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.runAllRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.switchSelector("ALL")));
        this.runMatchingRadio = new Button((Composite)container, 16);
        this.runMatchingRadio.setText(Messages.DotnetTestTab_runMatching);
        this.runMatchingRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.runMatchingRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.switchSelector("MATCHING")));
        this.filterLabel = new Label((Composite)container, 0);
        this.filterLabel.setText(Messages.DotnetTestTab_testFilter);
        this.filterLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.filterText = new Text((Composite)container, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.filterText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label((Composite)container, 0);
        this.runSelectedRadio = new Button((Composite)container, 16);
        this.runSelectedRadio.setText(Messages.DotnetTestTab_runSingle);
        this.runSelectedRadio.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        this.runSelectedRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.switchSelector("SELECTED")));
        this.classLabel = new Label((Composite)container, 0);
        this.classLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.classLabel.setText(Messages.DotnetTestTab_testClass);
        this.classText = new Text((Composite)container, 2048);
        this.classText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.classText.addModifyListener(e -> {
            if (this.classText.getText().isEmpty()) {
                this.methodBrowseButton.setEnabled(true);
                this.methodLabel.setEnabled(true);
                this.methodText.setEnabled(true);
            }
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.classBrowseButton = new Button((Composite)container, 0);
        this.classBrowseButton.setText(Messages.DotnetTestTab_search);
        this.classBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.classBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.searchForTestClass()));
        this.methodLabel = new Label((Composite)container, 0);
        this.methodLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.methodLabel.setText(Messages.DotnetTestTab_testMethod);
        this.methodText = new Text((Composite)container, 2048);
        this.methodText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.methodText.setMessage(Messages.DotnetTestTab_allMethods);
        this.methodText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.methodBrowseButton = new Button((Composite)container, 0);
        this.methodBrowseButton.setText(Messages.DotnetTestTab_search);
        this.methodBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.methodBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.searchForTestMethods()));
        Label configLabel = new Label((Composite)container, 0);
        configLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        configLabel.setText(Messages.DotnetTestTab_configuration);
        Composite configComp = new Composite((Composite)container, 0);
        configComp.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        configComp.setLayout((Layout)new RowLayout());
        Listener configRadioListener = new Listener(){

            public void handleEvent(Event e) {
                DotnetTestTab.this.projectConfig = ((Button)e.widget).getText();
                DotnetTestTab.this.setDirty(true);
                DotnetTestTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.debugRadio = new Button(configComp, 16);
        this.debugRadio.setText(Messages.DotnetTestTab_debug);
        this.debugRadio.addListener(13, configRadioListener);
        this.releaseRadio = new Button(configComp, 16);
        this.releaseRadio.setText(Messages.DotnetTestTab_release);
        this.releaseRadio.addListener(13, configRadioListener);
        Label frameworkLabel = new Label((Composite)container, 0);
        frameworkLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        frameworkLabel.setText(Messages.DotnetTestTab_framework);
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)container, 2560);
        GridData listBoxData = new GridData(4, 0x1000000, true, false, 2, 1);
        listBoxData.heightHint = 50;
        list.setLayoutData((Object)listBoxData);
        new Label((Composite)container, 0).setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        this.buildCheckBoxButton = new Button((Composite)container, 32);
        this.buildCheckBoxButton.setSelection(true);
        this.buildCheckBoxButton.setText(Messages.DotnetTestTab_buildProject);
        this.buildCheckBoxButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.buildCheckBoxButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
        this.restoreCheckBoxButton = new Button((Composite)container, 32);
        this.restoreCheckBoxButton.setSelection(true);
        this.restoreCheckBoxButton.setText(Messages.DotnetTestTab_restoreProject);
        this.restoreCheckBoxButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.restoreCheckBoxButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
        list.setEnabled(false);
        this.frameworkViewer = new ListViewer(list);
        this.frameworkViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.frameworkViewer.add((Object)Messages.DotnetTestTab_noFrameworks);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "");
        configuration.setAttribute("TEST_SELECTION_TYPE", "ALL");
        configuration.setAttribute("TEST_FILTER", "");
        configuration.setAttribute("TEST_CLASS", "");
        configuration.setAttribute("TEST_METHOD", "");
        configuration.setAttribute("CONFIGURATION", "Debug");
        configuration.setAttribute("FRAMEWORK", "");
        configuration.setAttribute("PROJECT_BUILD", true);
        configuration.setAttribute("PROJECT_RESTORE", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block43: {
            block41: {
                try {
                    this.pathText.setText(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", ""));
                }
                catch (CoreException ce) {
                    this.pathText.setText("");
                }
                try {
                    this.filterText.setText(configuration.getAttribute("TEST_FILTER", ""));
                }
                catch (CoreException ce) {
                    this.filterText.setText("");
                }
                try {
                    this.classText.setText(configuration.getAttribute("TEST_CLASS", ""));
                }
                catch (CoreException ce) {
                    this.classText.setText("");
                }
                try {
                    this.methodText.setText(configuration.getAttribute("TEST_METHOD", ""));
                }
                catch (CoreException ce) {
                    this.methodText.setText("");
                }
                try {
                    try {
                        this.testType = configuration.getAttribute("TEST_SELECTION_TYPE", "ALL");
                    }
                    catch (CoreException ce) {
                        this.testType = "ALL";
                        this.switchSelector(this.testType);
                        this.runSelectedRadio.setSelection(false);
                        this.runMatchingRadio.setSelection(false);
                        this.runAllRadio.setSelection(false);
                        if (this.testType.equals("SELECTED")) {
                            this.runSelectedRadio.setSelection(true);
                        } else if (this.testType.equals("MATCHING")) {
                            this.runMatchingRadio.setSelection(true);
                        } else {
                            this.runAllRadio.setSelection(true);
                        }
                        break block41;
                    }
                }
                catch (Throwable throwable) {
                    this.switchSelector(this.testType);
                    this.runSelectedRadio.setSelection(false);
                    this.runMatchingRadio.setSelection(false);
                    this.runAllRadio.setSelection(false);
                    if (this.testType.equals("SELECTED")) {
                        this.runSelectedRadio.setSelection(true);
                    } else if (this.testType.equals("MATCHING")) {
                        this.runMatchingRadio.setSelection(true);
                    } else {
                        this.runAllRadio.setSelection(true);
                    }
                    throw throwable;
                }
                this.switchSelector(this.testType);
                this.runSelectedRadio.setSelection(false);
                this.runMatchingRadio.setSelection(false);
                this.runAllRadio.setSelection(false);
                if (this.testType.equals("SELECTED")) {
                    this.runSelectedRadio.setSelection(true);
                } else if (this.testType.equals("MATCHING")) {
                    this.runMatchingRadio.setSelection(true);
                } else {
                    this.runAllRadio.setSelection(true);
                }
            }
            try {
                try {
                    this.projectConfig = configuration.getAttribute("CONFIGURATION", "Debug");
                }
                catch (CoreException ce) {
                    this.projectConfig = "Debug";
                    if (this.projectConfig.equals("Debug")) {
                        this.debugRadio.setSelection(true);
                        this.releaseRadio.setSelection(false);
                    } else {
                        this.releaseRadio.setSelection(true);
                        this.debugRadio.setSelection(false);
                    }
                    break block43;
                }
            }
            catch (Throwable throwable) {
                if (this.projectConfig.equals("Debug")) {
                    this.debugRadio.setSelection(true);
                    this.releaseRadio.setSelection(false);
                } else {
                    this.releaseRadio.setSelection(true);
                    this.debugRadio.setSelection(false);
                }
                throw throwable;
            }
            if (this.projectConfig.equals("Debug")) {
                this.debugRadio.setSelection(true);
                this.releaseRadio.setSelection(false);
            } else {
                this.releaseRadio.setSelection(true);
                this.debugRadio.setSelection(false);
            }
        }
        try {
            this.loadedSelectedTargetFramework = configuration.getAttribute("FRAMEWORK", "");
        }
        catch (CoreException ce) {
            // empty catch block
        }
        try {
            this.buildCheckBoxButton.setSelection(configuration.getAttribute("PROJECT_BUILD", true));
        }
        catch (CoreException ce) {
            this.buildCheckBoxButton.setSelection(true);
        }
        try {
            this.restoreCheckBoxButton.setSelection(configuration.getAttribute("PROJECT_RESTORE", true));
        }
        catch (CoreException ce) {
            this.restoreCheckBoxButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", this.pathText.getText());
        configuration.setAttribute("TEST_SELECTION_TYPE", this.testType);
        configuration.setAttribute("TEST_FILTER", this.filterText.getText());
        configuration.setAttribute("TEST_CLASS", this.classText.getText());
        configuration.setAttribute("TEST_METHOD", this.methodText.getText());
        configuration.setAttribute("CONFIGURATION", this.projectConfig);
        configuration.setAttribute("FRAMEWORK", this.getTargetFramework());
        configuration.setAttribute("PROJECT_BUILD", this.buildCheckBoxButton.getSelection());
        configuration.setAttribute("PROJECT_RESTORE", this.restoreCheckBoxButton.getSelection());
        this.setDirty(false);
    }

    public String getName() {
        return Messages.DotnetTestTab_name;
    }

    private void switchSelector(String type) {
        this.filterLabel.setEnabled(false);
        this.filterText.setEnabled(false);
        this.classBrowseButton.setEnabled(false);
        this.classLabel.setEnabled(false);
        this.classText.setEnabled(false);
        this.methodBrowseButton.setEnabled(false);
        this.methodLabel.setEnabled(false);
        this.methodText.setEnabled(false);
        if (type.equals("SELECTED")) {
            this.classBrowseButton.setEnabled(true);
            this.classLabel.setEnabled(true);
            this.classText.setEnabled(true);
            if (!this.classText.getText().isEmpty()) {
                this.methodBrowseButton.setEnabled(true);
                this.methodLabel.setEnabled(true);
                this.methodText.setEnabled(true);
            }
            this.testType = "SELECTED";
        } else if (type.equals("MATCHING")) {
            this.filterLabel.setEnabled(true);
            this.filterText.setEnabled(true);
            this.testType = "MATCHING";
        } else {
            this.testType = "ALL";
        }
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private void updateProjectPath(String location) {
        this.projectPath = new Path(location);
        this.updateFrameworkList();
    }

    private void searchForTestClass() {
        if (!this.pathText.getText().equals(this.loadedTestsParentProject) || this.testMethods == null) {
            this.loadedTestsParentProject = this.pathText.getText();
            this.testMethods = null;
            Job.create((String)Messages.DotnetTestTab_retrieveClasses, monitor -> {
                this.testMethods = DotnetTestAccessor.getTestMethods(this.projectPath.toFile());
                Display.getDefault().asyncExec(() -> this.displayClassSelectorDialog());
            }).schedule();
        } else {
            this.displayClassSelectorDialog();
        }
    }

    private void displayClassSelectorDialog() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.classBrowseButton.getShell(), (ILabelProvider)new LabelProvider());
        dialog.setTitle(Messages.DotnetTestTab_classSelection_title);
        dialog.setMessage(Messages.DotnetTestTab_classSelection_message);
        dialog.setElements(this.testMethods.keySet().toArray());
        dialog.open();
        String selected = (String)dialog.getFirstResult();
        if (selected != null) {
            this.methodBrowseButton.setEnabled(true);
            this.methodLabel.setEnabled(true);
            this.methodText.setEnabled(true);
            this.classText.setText(selected);
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void searchForTestMethods() {
        if (!this.pathText.getText().equals(this.loadedTestsParentProject) || this.testMethods == null) {
            this.loadedTestsParentProject = this.pathText.getText();
            this.testMethods = null;
            Job.create((String)Messages.DotnetTestTab_retrieveClasses, monitor -> {
                this.testMethods = DotnetTestAccessor.getTestMethods(this.projectPath.toFile());
                Display.getDefault().asyncExec(() -> this.displayMethodSelectorDialog());
            }).schedule();
        } else {
            this.displayMethodSelectorDialog();
        }
    }

    private void displayMethodSelectorDialog() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.classBrowseButton.getShell(), (ILabelProvider)new LabelProvider());
        dialog.setTitle(NLS.bind((String)Messages.DotnetTestTab_methodSelection_title, (Object)this.classText.getText()));
        dialog.setMessage(Messages.DotnetTestTab_methodSelection_message);
        List<String> methods = this.testMethods.get(this.classText.getText());
        if (methods != null) {
            dialog.setElements(methods.toArray());
        }
        dialog.open();
        String selected = (String)dialog.getFirstResult();
        if (selected != null) {
            this.methodText.setText(selected);
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void updateFrameworkList() {
        this.frameworkViewer.getList().removeAll();
        if (this.isProjectFile(this.projectPath)) {
            this.frameworkViewer.getList().deselectAll();
            this.frameworkViewer.add((Object)Messages.DotnetTestTab_loadingFrameworks);
            this.frameworkViewer.getList().setEnabled(false);
            this.targetFrameworks = ProjectFileAccessor.getTargetFrameworks((IPath)this.projectPath);
            this.frameworkViewer.getList().removeAll();
            if (this.targetFrameworks.length > 0) {
                this.frameworkViewer.add((Object[])this.targetFrameworks);
                this.frameworkViewer.getList().select(0);
                this.frameworkViewer.getList().setEnabled(true);
                this.loadFramework();
                return;
            }
        }
        this.frameworkViewer.add((Object)Messages.DotnetTestTab_noFrameworks);
    }

    private void loadFramework() {
        if (this.loadedSelectedTargetFramework == null || this.loadedSelectedTargetFramework.isEmpty()) {
            return;
        }
        int index = 0;
        String[] stringArray = this.frameworkViewer.getList().getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String framework = stringArray[n2];
            if (framework.equals(this.loadedSelectedTargetFramework)) {
                this.frameworkViewer.getList().select(index);
                break;
            }
            ++index;
            ++n2;
        }
        this.loadedSelectedTargetFramework = null;
    }

    private boolean isProjectFile(Path path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        if (!path.lastSegment().matches("(.*\\.csproj|project.json)")) {
            return false;
        }
        return path.toFile().isFile();
    }

    public String getTargetFramework() {
        IStructuredSelection selection = (IStructuredSelection)this.frameworkViewer.getSelection();
        if (selection.isEmpty()) {
            return "";
        }
        return (String)selection.getFirstElement();
    }
}

