/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.core;

public class EngineStateAdapter {
    private boolean running;
    private boolean stepping;
    private boolean pausing;
    private boolean endReached;

    public EngineStateAdapter(boolean isRunning, boolean isStepping, boolean isPausing, boolean isEndReached) {
        this.update(isRunning, isStepping, isPausing, isEndReached);
    }

    public boolean update(boolean isRunning, boolean isStepping, boolean isPausing, boolean isEndReached) {
        EngineState stateBefore = this.getState();
        this.running = isRunning;
        this.stepping = isStepping;
        this.pausing = isPausing;
        this.endReached = isEndReached;
        return stateBefore != this.getState();
    }

    public EngineState getState() {
        if (this.isEndReached()) {
            return EngineState.ENDED;
        }
        if (!this.isRunning()) {
            return EngineState.IDLE;
        }
        if (this.isStepping() || this.isPausing()) {
            return EngineState.PAUSED;
        }
        return EngineState.RUNNING;
    }

    public boolean isPausing() {
        return this.pausing;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public boolean isEndReached() {
        return this.endReached;
    }

    public static enum EngineState {
        IDLE,
        RUNNING,
        PAUSED,
        ENDED;

    }
}

