/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.scoping.AbstractResourceScope;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;

public class ContainerResourceScope
extends AbstractResourceScope {
    protected IContainer rootContainer;

    public ContainerResourceScope(IResource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isTrue((!(resource instanceof IWorkspaceRoot) ? 1 : 0) != 0);
        this.rootContainer = resource.getParent();
    }

    public IResource getRoot() {
        return this.rootContainer;
    }

    public Collection<IResource> getReferencedRoots() {
        return Collections.emptySet();
    }

    public Collection<IResource> getReferencingRoots() {
        return Collections.emptySet();
    }

    public boolean belongsTo(IFile file, boolean includeReferencedScopes) {
        if (this.belongsToRootContainer(file)) {
            return true;
        }
        return this.isShared(file);
    }

    public boolean belongsTo(Resource resource, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile((Resource)resource);
        if (this.belongsToRootContainer(file)) {
            return true;
        }
        return this.isShared(resource);
    }

    public boolean belongsTo(URI uri, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile((URI)uri);
        if (this.belongsToRootContainer(file)) {
            return true;
        }
        return this.isShared(uri);
    }

    public boolean didBelongTo(IFile file, boolean includeReferencedScopes) {
        return this.belongsToRootContainer(file);
    }

    public boolean didBelongTo(Resource resource, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile((Resource)resource);
        return this.belongsToRootContainer(file);
    }

    public boolean didBelongTo(URI uri, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile((URI)uri);
        return this.belongsToRootContainer(file);
    }

    protected boolean belongsToRootContainer(IFile file) {
        if (file != null && this.rootContainer != null) {
            return this.rootContainer.equals((Object)file.getParent());
        }
        return false;
    }
}

