/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.hw.templates;

import org.eclipse.app4mc.amalthea.model.ConnectionHandler;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.visualization.hw.ModelToTextResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HWBlockDiagramCreator {
    public static ModelToTextResult generatePlantUML(HWModel model) {
        ModelToTextResult state = new ModelToTextResult();
        CharSequence output = HWBlockDiagramCreator.generatePlantUmlContent(model, state);
        boolean _success = state.success();
        if (_success) {
            state.setOutput(output);
        } else {
            state.setErrorFlag(false);
            state.setOutput(HWBlockDiagramCreator.error(state.getErrorMessage()));
        }
        return state;
    }

    public static CharSequence error(String message) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        _builder.append("left to right direction");
        _builder.newLine();
        _builder.append("actor User");
        _builder.newLine();
        _builder.append("rectangle Visualization {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("usecase \"Invalid Input\" as ii");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("User ---> ii");
        _builder.newLine();
        _builder.append("note top of ii");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(message, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("end note");
        _builder.newLine();
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generatePlantUmlContent(HWModel model, ModelToTextResult result) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        boolean _isEmpty = model.getStructures().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            _builder.append("' ===== FRAMES =====");
            _builder.newLine();
            EList _structures = model.getStructures();
            for (HwStructure s : _structures) {
                CharSequence _generateLevel = HWBlockDiagramCreator.generateLevel(model, s, result);
                _builder.append((Object)_generateLevel);
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("' ===== ROUTES =====");
            _builder.newLine();
            EList _structures_1 = model.getStructures();
            for (HwStructure s_1 : _structures_1) {
                CharSequence _generateRoutes = HWBlockDiagramCreator.generateRoutes(model, s_1, result);
                _builder.append((Object)_generateRoutes);
                _builder.newLineIfNotEmpty();
            }
        } else {
            result.setErrorFlag(true);
            _builder.newLineIfNotEmpty();
            result.setErrorMessage(" No Structure in the model. ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("skinparam component {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<ProcessingUnit>> #8CACFF");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<ProcessingUnit>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<ConnectionHandler>> #FFFFA0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<ConnectionHandler>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<Memory>> #60FF82");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<Memory>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("backgroundColor<<Cache>> #C8FFA6");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("borderColor<<Cache>> #000000");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ArrowFontColor #C0C0C0");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generateLevel(HWModel model, HwStructure s, ModelToTextResult errorCheck) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _not = s != null && !StringExtensions.isNullOrEmpty((String)s.getName());
        if (_not) {
            boolean _not_1;
            _builder.newLine();
            _builder.append("\t");
            _builder.append("frame \"");
            String _name = s.getName();
            _builder.append(_name, "\t");
            _builder.append("\" as ");
            String _convertFluxString = HWBlockDiagramCreator.convertFluxString(s.getName());
            _builder.append(_convertFluxString, "\t");
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = s.getModules().isEmpty();
            boolean bl2 = _not_1 = !_isEmpty;
            if (_not_1) {
                _builder.append("\t");
                _builder.newLine();
                EList _modules = s.getModules();
                for (HwModule m : _modules) {
                    boolean _not_2;
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)m.getName());
                    boolean bl3 = _not_2 = !_isNullOrEmpty;
                    if (_not_2) {
                        if (m instanceof ProcessingUnit) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("[");
                            String _convertFluxString_1 = HWBlockDiagramCreator.convertFluxString(((ProcessingUnit)m).getName());
                            _builder.append(_convertFluxString_1, "\t\t");
                            _builder.append("] as ");
                            String _convertFluxString_2 = HWBlockDiagramCreator.convertFluxString(((ProcessingUnit)m).getName());
                            _builder.append(_convertFluxString_2, "\t\t");
                            _builder.append(" <<ProcessingUnit>>");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        if (m instanceof Memory) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("[");
                            String _convertFluxString_3 = HWBlockDiagramCreator.convertFluxString(((Memory)m).getName());
                            _builder.append(_convertFluxString_3, "\t\t");
                            _builder.append("] as ");
                            String _convertFluxString_4 = HWBlockDiagramCreator.convertFluxString(((Memory)m).getName());
                            _builder.append(_convertFluxString_4, "\t\t");
                            _builder.append(" <<Memory>>");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        if (m instanceof ConnectionHandler) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("[");
                            String _convertFluxString_5 = HWBlockDiagramCreator.convertFluxString(((ConnectionHandler)m).getName());
                            _builder.append(_convertFluxString_5, "\t\t");
                            _builder.append("] as ");
                            String _convertFluxString_6 = HWBlockDiagramCreator.convertFluxString(((ConnectionHandler)m).getName());
                            _builder.append(_convertFluxString_6, "\t\t");
                            _builder.append(" <<ConnectionHandler>>");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("[");
                        String _convertFluxString_7 = HWBlockDiagramCreator.convertFluxString(m.getName());
                        _builder.append(_convertFluxString_7, "\t\t");
                        _builder.append("] as ");
                        String _convertFluxString_8 = HWBlockDiagramCreator.convertFluxString(m.getName());
                        _builder.append(_convertFluxString_8, "\t\t");
                        _builder.append(" <<Cache>>");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    errorCheck.setErrorFlag(true);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    errorCheck.setErrorMessage(" Missing HW Module name. ");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _structures = s.getStructures();
            for (HwStructure su : _structures) {
                _builder.append("\t");
                CharSequence _generateLevel = HWBlockDiagramCreator.generateLevel(model, su, errorCheck);
                _builder.append((Object)_generateLevel, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            errorCheck.setErrorFlag(true);
            _builder.newLineIfNotEmpty();
            errorCheck.setErrorMessage(" Name of HwStructure is missing. ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generateRoutes(HWModel model, HwStructure s, ModelToTextResult errorCheck) {
        boolean _not_5;
        boolean _not_2;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _not = s != null && !s.getConnections().isEmpty();
        if (_not) {
            _builder.newLine();
            _builder.append("' add physical connections of structure ");
            String _name = s.getName();
            _builder.append(_name);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            EList _connections = s.getConnections();
            for (HwConnection c : _connections) {
                boolean _not_1;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)c.getName());
                boolean bl2 = _not_1 = !_isNullOrEmpty;
                if (_not_1) {
                    _builder.newLine();
                    _builder.append("\t");
                    HwPort _port1 = c.getPort1();
                    EObject _eContainer = null;
                    if (_port1 != null) {
                        _eContainer = _port1.eContainer();
                    }
                    String _convertFluxString = HWBlockDiagramCreator.convertFluxString(HWBlockDiagramCreator.name((INamed)_eContainer));
                    _builder.append(_convertFluxString, "\t");
                    _builder.append(" -- ");
                    HwPort _port2 = c.getPort2();
                    EObject _eContainer_1 = null;
                    if (_port2 != null) {
                        _eContainer_1 = _port2.eContainer();
                    }
                    String _convertFluxString_1 = HWBlockDiagramCreator.convertFluxString(HWBlockDiagramCreator.name((INamed)_eContainer_1));
                    _builder.append(_convertFluxString_1, "\t");
                    _builder.append(" : ");
                    String _name_1 = c.getName();
                    _builder.append(_name_1, "\t");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.newLine();
                _builder.append("\t");
                HwPort _port1_1 = c.getPort1();
                EObject _eContainer_2 = null;
                if (_port1_1 != null) {
                    _eContainer_2 = _port1_1.eContainer();
                }
                String _convertFluxString_2 = HWBlockDiagramCreator.convertFluxString(HWBlockDiagramCreator.name((INamed)_eContainer_2));
                _builder.append(_convertFluxString_2, "\t");
                _builder.append(" -- ");
                HwPort _port2_1 = c.getPort2();
                EObject _eContainer_3 = null;
                if (_port2_1 != null) {
                    _eContainer_3 = _port2_1.eContainer();
                }
                String _convertFluxString_3 = HWBlockDiagramCreator.convertFluxString(HWBlockDiagramCreator.name((INamed)_eContainer_3));
                _builder.append(_convertFluxString_3, "\t");
                _builder.append(" : ");
                String _string = c.toString();
                _builder.append(_string, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _not_2 = s != null && !s.getModules().isEmpty();
        if (_not_2) {
            EList _modules = s.getModules();
            for (HwModule m : _modules) {
                boolean _not_3;
                if (!(m instanceof ProcessingUnit)) continue;
                ProcessingUnit pUnit = (ProcessingUnit)m;
                _builder.newLineIfNotEmpty();
                boolean _isEmpty = pUnit.getAccessElements().isEmpty();
                boolean bl4 = _not_3 = !_isEmpty;
                if (!_not_3) continue;
                _builder.newLine();
                _builder.append("' add logical connections of processing unit ");
                String _name_2 = pUnit.getName();
                _builder.append(_name_2);
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                EList _accessElements = pUnit.getAccessElements();
                for (HwAccessElement ae : _accessElements) {
                    boolean _tripleNotEquals_1;
                    boolean _not_4;
                    boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)ae.getName());
                    boolean bl5 = _not_4 = !_isNullOrEmpty_1;
                    if (_not_4) {
                        boolean _tripleNotEquals;
                        HwDestination _destination = ae.getDestination();
                        boolean bl6 = _tripleNotEquals = _destination != null;
                        if (_tripleNotEquals) {
                            _builder.newLine();
                            _builder.append("\t");
                            String _convertFluxString_4 = HWBlockDiagramCreator.convertFluxString(pUnit.getName());
                            _builder.append(_convertFluxString_4, "\t");
                            _builder.append(" ..>");
                            String _convertFluxString_5 = HWBlockDiagramCreator.convertFluxString(ae.getDestination().getName());
                            _builder.append(_convertFluxString_5, "\t");
                            _builder.append(" : ");
                            String _name_3 = ae.getName();
                            _builder.append(_name_3, "\t");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        errorCheck.setErrorFlag(true);
                        _builder.newLineIfNotEmpty();
                        errorCheck.setErrorMessage(" Missing Destination of AccessElement. ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    HwDestination _destination_1 = ae.getDestination();
                    boolean bl7 = _tripleNotEquals_1 = _destination_1 != null;
                    if (_tripleNotEquals_1) {
                        _builder.newLine();
                        _builder.append("\t");
                        String _convertFluxString_6 = HWBlockDiagramCreator.convertFluxString(pUnit.getName());
                        _builder.append(_convertFluxString_6, "\t");
                        _builder.append(" ..>");
                        String _convertFluxString_7 = HWBlockDiagramCreator.convertFluxString(ae.getDestination().getName());
                        _builder.append(_convertFluxString_7, "\t");
                        _builder.append(" : ");
                        String _string_1 = ae.toString();
                        _builder.append(_string_1, "\t");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    errorCheck.setErrorFlag(true);
                    _builder.newLineIfNotEmpty();
                    errorCheck.setErrorMessage(" Missing Destination of AccessElement. ");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        boolean bl8 = _not_5 = s != null && !s.getStructures().isEmpty();
        if (_not_5) {
            EList _structures = s.getStructures();
            for (HwStructure su : _structures) {
                CharSequence _generateRoutes = HWBlockDiagramCreator.generateRoutes(model, su, errorCheck);
                _builder.append((Object)_generateRoutes);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static String name(INamed obj) {
        if (obj == null) {
            return "<undefined>";
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)obj.getName());
        if (_isNullOrEmpty) {
            return "?";
        }
        return obj.getName();
    }

    public static String convertFluxString(String str) {
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)str);
        _xifexpression = _isNullOrEmpty ? "<no name>" : HWBlockDiagramCreator.convertGenericString(str, "_");
        return _xifexpression;
    }

    public static String convertGenericString(String instring, String replacestring) {
        String tmpstr0 = instring.replaceAll("/", replacestring);
        String tmpstr1 = tmpstr0.replaceAll(" ", replacestring);
        String tmpstr2 = tmpstr1.replaceAll("\\(", replacestring);
        String tmpstr3 = tmpstr2.replaceAll("\\)", replacestring);
        String tmpstr4 = tmpstr3.replaceAll("-", replacestring);
        String tmpstr5 = tmpstr4.replaceAll("\\+", replacestring);
        String tmpstr6 = tmpstr5.replaceAll("%2f", replacestring);
        String tmpstr7 = tmpstr6.replaceAll("\\(", replacestring);
        String tmpstr8 = tmpstr7.replaceAll("\\)", replacestring);
        String tmpstr9 = tmpstr8.replaceAll("%2b", "plus");
        String tmpstr10 = tmpstr9.replaceAll("%3a%3a", replacestring);
        String tmpstr11 = tmpstr10.replaceAll("\\.", replacestring);
        String tmpstr12 = tmpstr11.replaceAll("#", replacestring);
        String tmpstr13 = tmpstr12.replaceAll("\"", replacestring);
        String tmpstr14 = tmpstr13.replaceAll("$", replacestring);
        String tmpstr15 = tmpstr14.replaceAll("~", replacestring);
        String tmpstr16 = tmpstr15.replaceAll("%", replacestring);
        String tmpstr17 = tmpstr16.replaceAll("&", replacestring);
        return tmpstr17;
    }
}

