/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.MetricAggregation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EventChainMetricCalculator
implements IRunnableWithProgress {
    private final ATDBConnection con;

    public EventChainMetricCalculator(ATDBConnection con) {
        this.con = con;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Calculating event chain metrics...", (int)3);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Statement mStmt = this.con.createStatement();){
                String ecInstCalculationSQL;
                block28: {
                    ecInstCalculationSQL = "";
                    Bundle bundle = FrameworkUtil.getBundle(EventChainMetricCalculator.class);
                    String pathInBundle = String.valueOf(EventChainMetricCalculator.class.getPackage().getName().replace('.', '/')) + "/ecinststatements.sql";
                    URL fileURL = bundle.getResource(pathInBundle);
                    try {
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try {
                            InputStream fileIS = fileURL.openStream();
                            try {
                                try (ByteArrayOutputStream bAOS = new ByteArrayOutputStream();){
                                    byte[] buffer = new byte[1024];
                                    while (true) {
                                        int length;
                                        if ((length = fileIS.read(buffer)) == -1) {
                                            ecInstCalculationSQL = bAOS.toString();
                                            break;
                                        }
                                        bAOS.write(buffer, 0, length);
                                    }
                                }
                                if (fileIS == null) break block28;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                if (fileIS == null) throw throwable2;
                                fileIS.close();
                                throw throwable2;
                            }
                            fileIS.close();
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (ecInstCalculationSQL.length() == 0) {
                    return;
                }
                this.con.executeUpdate(ecInstCalculationSQL);
                subMon.worked(1);
                this.con.executeBatchUpdate(atdbCon -> {
                    List<String> latencyTypes = Arrays.asList("Age", "Reaction");
                    for (String latencyType : latencyTypes) {
                        atdbCon.insertMetric(String.valueOf(latencyType.toLowerCase()) + "Latency", "time");
                        mStmt.addBatch("INSERT OR IGNORE INTO entityInstanceMetricValue SELECT entityId, entityInstance, (SELECT id FROM metric WHERE name = '" + latencyType.toLowerCase() + "Latency'), responseTimestamp - stimulusTimestamp FROM eventChainInstanceInfo " + "WHERE is" + latencyType + ";");
                        MetricAggregation[] metricAggregationArray = MetricAggregation.values();
                        int n = metricAggregationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MetricAggregation kind = metricAggregationArray[n2];
                            String metricName = String.valueOf(latencyType.toLowerCase()) + "Latency" + "_" + kind;
                            String aggregateFunction = kind.getSQLStr("value");
                            atdbCon.insertMetric(metricName, "time");
                            mStmt.addBatch("INSERT OR IGNORE INTO entityMetricValue SELECT entityId, (SELECT id FROM metric WHERE name = '" + metricName + "'), " + aggregateFunction + " FROM entityInstanceMetricValue WHERE (SELECT is" + latencyType + " FROM " + "eventChainInstanceInfo WHERE eventChainInstanceInfo.entityId = entityInstanceMetricValue.entityId AND " + "eventChainInstanceInfo.entityInstance = entityInstanceMetricValue.entityInstance) " + "GROUP BY entityId;");
                            ++n2;
                        }
                    }
                });
                subMon.worked(1);
                this.con.executeBatchStatements(new Statement[]{mStmt});
                subMon.worked(1);
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new InvocationTargetException(e);
        }
    }
}

