/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.7.1", "output_model_version=0.7.2"}, service={IConverter.class})
public class ConstraintsConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.7.1 to 0.7.2 : Executing Constraints converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = fileName2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateAffinityConstraints(rootElement);
    }

    private void updateAffinityConstraints(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./constraintsModel/affinityConstraints");
        List affinityConstraintElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element affinityConstraintElement : affinityConstraintElements) {
            String targetType;
            Element targetElement;
            String type = affinityConstraintElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (type == null) continue;
            Element childElement = null;
            if ("am:RunnablePairingConstraint".equals(type)) {
                childElement = affinityConstraintElement.getChild("runnables");
            } else if ("am:ProcessPairingConstraint".equals(type)) {
                childElement = affinityConstraintElement.getChild("processes");
            } else if ("am:DataPairingConstraint".equals(type)) {
                childElement = affinityConstraintElement.getChild("labels");
            }
            if (childElement != null) {
                childElement.setName("group");
            }
            if ((targetElement = affinityConstraintElement.getChild("target")) == null || (targetType = targetElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"))) == null || !"am:TargetCallSequence".equals(targetType) && !"am:TargetProcess".equals(targetType)) continue;
            affinityConstraintElement.removeContent((Content)targetElement);
        }
    }
}

