/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf;

import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BTFImporter
implements IRunnableWithProgress {
    private static final String STIMULI = "stimuli";
    private static final String RUNNABLES = "runnables";
    private static final String START = "start";
    private static final String TERMINATE = "terminate";
    private static final String READ_SIGNALS = "readSignals";
    private static final String WRITTEN_SIGNALS = "writtenSignals";
    private static final String ENTITY_ID_REF = "entityIdRef";
    private final String btfFile;
    private final ATDBConnection con;
    private final long maxBatchSize;
    private final Map<String, String> entity2Type = new LinkedHashMap<String, String>();
    private final Set<String> entityTypes = new HashSet<String>();
    private final Map<String, Long> entityTypeName2Id = new LinkedHashMap<String, Long>();
    private final Map<String, Long> entityName2Id = new LinkedHashMap<String, Long>();
    private final Map<String, Set<Integer>> instNames = new HashMap<String, Set<Integer>>();
    private final Set<String> eventTypes = new HashSet<String>();
    private final Map<String, Long> eventTypeName2Id = new LinkedHashMap<String, Long>();
    private final Map<String, Map<String, List<String>>> entity2property2Value = new LinkedHashMap<String, Map<String, List<String>>>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    public BTFImporter(ATDBConnection con, String btfFile) {
        this.con = con;
        this.btfFile = btfFile;
        long maxMemory = Runtime.getRuntime().maxMemory();
        this.maxBatchSize = maxMemory < Long.MAX_VALUE ? maxMemory >> 16 : 131072L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Importing BTF file...", (int)1);
        SubMonitor readingBTFMonitor = subMon.split(1, 0);
        readingBTFMonitor.beginTask("Reading BTF file...", 10000);
        int readingBTFProgress = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileInputStream fis = new FileInputStream(this.btfFile);
                try {
                    Scanner sc = new Scanner((InputStream)fis, "UTF-8");
                    try {
                        try (Statement propStmt = this.con.createStatement();){
                            PreparedStatement updEntStmt = this.con.getPreparedStatementFor("UPDATE entity SET entityTypeId = ? WHERE name = ?;");
                            PreparedStatement instStmt = this.con.getPreparedStatementFor("INSERT INTO entityInstance VALUES(?, ?);");
                            PreparedStatement evStmt = this.con.getPreparedStatementFor("INSERT INTO traceEvent VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
                            long fileSize = new File(this.btfFile).length();
                            long currentTimestamp = Long.MIN_VALUE;
                            int currentSQCNR = 0;
                            String currentECU = "";
                            String currentProcessor = "";
                            long currentLineNumber = 0L;
                            long currentBatchSize = 0L;
                            long lineLengthSum = 0L;
                            long avgLineLength = 64L;
                            HashBiMap actCore2Process = HashBiMap.create();
                            HashBiMap actProcess2Runnable = HashBiMap.create();
                            while (sc.hasNextLine()) {
                                String line;
                                block67: {
                                    block66: {
                                        Optional value;
                                        String eventType;
                                        int sourceInstance;
                                        String sourceName;
                                        int entityInstance;
                                        String entityName;
                                        String entityType;
                                        long newTimestamp;
                                        block70: {
                                            block68: {
                                                ++currentLineNumber;
                                                ++currentBatchSize;
                                                line = sc.nextLine();
                                                if (line.startsWith("#")) break block66;
                                                String[] fields = line.split(",");
                                                if (fields.length <= 6) break block67;
                                                newTimestamp = Long.parseLong(fields[0]);
                                                entityType = fields[3];
                                                entityName = fields[4];
                                                entityInstance = Integer.parseInt(fields[5]);
                                                sourceName = fields[1];
                                                sourceInstance = Integer.parseInt(fields[2]);
                                                eventType = fields[6];
                                                value = fields.length > 7 ? Optional.of(fields[7]) : Optional.empty();
                                                this.insertEntity(entityName, entityType);
                                                if (!eventType.equalsIgnoreCase("tag") || !value.isPresent()) break block68;
                                                String sourceType = "";
                                                switch ((String)value.get()) {
                                                    case "ECU_INIT": {
                                                        sourceType = "ECU";
                                                        currentECU = sourceName;
                                                        break;
                                                    }
                                                    case "PROCESSOR_INIT": {
                                                        sourceType = "Processor";
                                                        currentProcessor = sourceName;
                                                        this.appendToProperty(currentECU, "processors", ENTITY_ID_REF, sourceName);
                                                        break;
                                                    }
                                                    case "CORE_INIT": {
                                                        sourceType = "C";
                                                        this.appendToProperty(currentProcessor, "cores", ENTITY_ID_REF, sourceName);
                                                        break;
                                                    }
                                                    case "SIG_INIT_VALUE": {
                                                        sourceType = "SIG";
                                                        if (fields.length <= 8) break;
                                                        this.setProperty(sourceName, "initialValue", "object", fields[8]);
                                                        break;
                                                    }
                                                    default: {
                                                        this.setProperty(sourceName, "tag", "object", (String)value.get());
                                                    }
                                                }
                                                if (sourceType.isEmpty()) break block70;
                                                this.insertEntity(sourceName, sourceType);
                                                break block70;
                                            }
                                            if (eventType.equalsIgnoreCase("set_frequence") && value.isPresent()) {
                                                this.setProperty(entityName, "frequencyInHz", "long", (String)value.get());
                                                continue;
                                            }
                                            if ((eventType.equalsIgnoreCase(START) || eventType.equalsIgnoreCase("stop")) && entityType.equals("SYS")) {
                                                this.setProperty(entityName, "system" + eventType.substring(0, 1).toUpperCase() + eventType.substring(1) + "Time", "time", "" + newTimestamp);
                                                continue;
                                            }
                                        }
                                        if (BTFEntityType.PROCESS.isTraceAlias(entityType) && "C".equals(this.entity2Type.getOrDefault(sourceName, "")) && (!this.entity2property2Value.containsKey(entityName) || !this.entity2property2Value.get(entityName).containsKey("executingCore"))) {
                                            this.setProperty(entityName, "executingCore", ENTITY_ID_REF, sourceName);
                                        }
                                        if (!(!BTFEntityType.RUNNABLE.isTraceAlias(entityType) || !BTFEntityType.PROCESS.isTraceAlias(this.entity2Type.getOrDefault(sourceName, "")) || this.entity2property2Value.containsKey(sourceName) && this.entity2property2Value.get(sourceName).containsKey(RUNNABLES) && this.entity2property2Value.get(sourceName).get(RUNNABLES).contains(entityName))) {
                                            this.appendToProperty(sourceName, RUNNABLES, ENTITY_ID_REF, entityName);
                                        }
                                        if (eventType.equalsIgnoreCase("activate") && BTFEntityType.PROCESS.isTraceAlias(entityType)) {
                                            this.insertEntity(sourceName, "STI");
                                            if (!(this.entity2property2Value.containsKey(entityName) && this.entity2property2Value.get(entityName).containsKey(STIMULI) && this.entity2property2Value.get(entityName).get(STIMULI).contains(sourceName))) {
                                                this.appendToProperty(entityName, STIMULI, ENTITY_ID_REF, sourceName);
                                            }
                                        } else {
                                            this.insertEntity(sourceName, "");
                                        }
                                        this.insertEntityInstance(instStmt, sourceName, sourceInstance);
                                        this.insertEntityInstance(instStmt, entityName, entityInstance);
                                        if (eventType.equalsIgnoreCase("tag")) continue;
                                        if (newTimestamp > currentTimestamp) {
                                            currentSQCNR = 0;
                                            currentTimestamp = newTimestamp;
                                        } else {
                                            ++currentSQCNR;
                                        }
                                        this.insertEventType(eventType);
                                        if (BTFEntityType.PROCESS.isTraceAlias(entityType) && "C".equals(this.entity2Type.getOrDefault(sourceName, ""))) {
                                            if (eventType.equalsIgnoreCase(START)) {
                                                actCore2Process.put((Object)sourceName, (Object)entityName);
                                            } else if (eventType.equalsIgnoreCase(TERMINATE)) {
                                                actCore2Process.remove((Object)sourceName);
                                            }
                                        }
                                        if (BTFEntityType.RUNNABLE.isTraceAlias(entityType) && BTFEntityType.PROCESS.isTraceAlias(this.entity2Type.getOrDefault(sourceName, "")) && actCore2Process.containsValue((Object)sourceName)) {
                                            if (eventType.equalsIgnoreCase(START)) {
                                                actProcess2Runnable.put((Object)sourceName, (Object)entityName);
                                            } else if (eventType.equalsIgnoreCase(TERMINATE)) {
                                                actProcess2Runnable.remove((Object)sourceName);
                                            }
                                        }
                                        if (entityType.equals("SIG") && BTFEntityType.PROCESS.isTraceAlias(this.entity2Type.getOrDefault(sourceName, "")) && actProcess2Runnable.containsKey((Object)sourceName)) {
                                            String rName = (String)actProcess2Runnable.get((Object)sourceName);
                                            if (!(!eventType.equalsIgnoreCase("read") || this.entity2property2Value.containsKey(rName) && this.entity2property2Value.get(rName).containsKey(READ_SIGNALS) && this.entity2property2Value.get(rName).get(READ_SIGNALS).contains(entityName))) {
                                                this.appendToProperty(rName, READ_SIGNALS, ENTITY_ID_REF, entityName);
                                            } else if (!(!eventType.equalsIgnoreCase("write") || this.entity2property2Value.containsKey(rName) && this.entity2property2Value.get(rName).containsKey(WRITTEN_SIGNALS) && this.entity2property2Value.get(rName).get(WRITTEN_SIGNALS).contains(entityName))) {
                                                this.appendToProperty(rName, WRITTEN_SIGNALS, ENTITY_ID_REF, entityName);
                                            }
                                        }
                                        List<Object> parameters = Arrays.asList(currentTimestamp, currentSQCNR, this.entityName2Id.get(entityName), entityInstance, this.entityName2Id.get(sourceName), sourceInstance, this.eventTypeName2Id.get(eventType), null);
                                        if (value.isPresent()) {
                                            parameters.set(parameters.size() - 1, value.get());
                                        }
                                        this.con.setPreparedParameters(evStmt, parameters);
                                        evStmt.addBatch();
                                        break block67;
                                    }
                                    if (line.toLowerCase().startsWith("#timescale")) {
                                        this.con.insertMetaInformation("timeBase", line.substring(11));
                                    } else if (line.startsWith("#simulation_duration")) {
                                        this.setProperty("SIM", "simulationDuration", "time", line.substring(21, line.lastIndexOf(32)));
                                    }
                                }
                                if ((currentLineNumber & 0xFFL) != 0L) continue;
                                lineLengthSum += (long)line.length();
                                if ((currentLineNumber & 0xFFFFL) == 0L) {
                                    avgLineLength = avgLineLength + (lineLengthSum >> 8) >> 1;
                                    lineLengthSum = 0L;
                                    long numberOfLines = fileSize / avgLineLength;
                                    int worked = (int)Math.min(10000L, currentLineNumber * 10000L / numberOfLines);
                                    if (readingBTFProgress < worked) {
                                        readingBTFMonitor.worked(worked - readingBTFProgress);
                                        readingBTFProgress = worked;
                                    }
                                }
                                if (currentBatchSize <= this.maxBatchSize) continue;
                                this.con.executeBatchStatements(new Statement[]{instStmt, evStmt});
                                currentBatchSize = 0L;
                            }
                            this.updateEntityTypes(updEntStmt);
                            this.executePropertyInsertStatements(propStmt);
                            readingBTFMonitor.done();
                            this.con.executeBatchStatements(new Statement[]{updEntStmt, instStmt, evStmt, propStmt});
                        }
                        if (sc != null) {
                            sc.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (sc == null) throw throwable;
                        sc.close();
                        throw throwable;
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | SQLException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void insertEntity(String name, String entityType) throws SQLException {
        if (!entityType.isEmpty() && this.entityTypes.add(entityType)) {
            long entityTypeId = this.con.immediateInsertEntityType(entityType);
            this.entityTypeName2Id.put(entityType, entityTypeId);
        }
        if (!this.entity2Type.containsKey(name)) {
            long entityId = this.con.immediateInsertEntity(name, -1L);
            this.entityName2Id.put(name, entityId);
        }
        this.entity2Type.compute(name, (k, v) -> v == null || v.isEmpty() ? entityType : v);
    }

    private void updateEntityTypes(PreparedStatement updEStmt) throws SQLException {
        for (Map.Entry<String, String> entry : this.entity2Type.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            String entityName = entry.getKey();
            long entityType = this.entityTypeName2Id.get(entry.getValue());
            this.con.setPreparedParameters(updEStmt, Arrays.asList(entityType, entityName));
            updEStmt.addBatch();
        }
    }

    private void insertEntityInstance(PreparedStatement stmt, String name, int inst) throws SQLException {
        Set instSet = this.instNames.computeIfAbsent(name, k -> new HashSet());
        if (instSet.add(inst)) {
            this.con.setPreparedParameters(stmt, Arrays.asList(this.entityName2Id.get(name), inst));
            stmt.addBatch();
        }
    }

    private void insertEventType(String name) throws SQLException {
        if (this.eventTypes.add(name)) {
            long eventTypeId = this.con.immediateInsertEventType(name);
            this.eventTypeName2Id.put(name, eventTypeId);
        }
    }

    private void appendToProperty(String entityName, String propertyName, String propertyType, String propertyValue) {
        this.setProperty(entityName, propertyName, propertyType, propertyValue, true);
    }

    private void setProperty(String entityName, String propertyName, String propertyType, String propertyValue) {
        this.setProperty(entityName, propertyName, propertyType, propertyValue, false);
    }

    private void setProperty(String entityName, String propertyName, String propertyType, String propertyValue, boolean append) {
        this.properties.putIfAbsent(propertyName, propertyType);
        Map property2Value = this.entity2property2Value.computeIfAbsent(entityName, k -> new LinkedHashMap());
        List values = property2Value.computeIfAbsent(propertyName, k -> new ArrayList());
        if (!append) {
            values.clear();
        }
        values.add(propertyValue);
    }

    private void executePropertyInsertStatements(Statement stmt) throws SQLException {
        ArrayList statements = new ArrayList();
        this.properties.forEach((propertyName, propertyType) -> {
            boolean bl = statements.add("INSERT INTO property(name, type) VALUES('" + propertyName + "', '" + propertyType + "');");
        });
        this.entity2property2Value.forEach((entityName, property2Value) -> property2Value.forEach((propertyName, propertyValue) -> {
            ArrayList<String> propertyValueStrings = new ArrayList<String>();
            String propertyType = this.properties.get(propertyName);
            if (propertyType.endsWith("IdRef")) {
                String tableName = propertyType.substring(0, propertyType.lastIndexOf("IdRef"));
                propertyValue.forEach(pv -> {
                    boolean bl = propertyValueStrings.add("(SELECT id FROM " + tableName + " WHERE name = '" + pv + "')");
                });
            } else {
                propertyValueStrings.add("'" + String.join((CharSequence)", ", propertyValue) + "'");
            }
            int i = 0;
            while (i < propertyValueStrings.size()) {
                statements.add("INSERT INTO propertyValue(entityId, propertyId, sqcnr, value) VALUES((SELECT id FROM entity   WHERE name = '" + entityName + "'), " + "(SELECT id FROM property WHERE name = '" + propertyName + "'), " + i + "," + (String)propertyValueStrings.get(i) + ");");
                ++i;
            }
        }));
        for (String st : statements) {
            stmt.addBatch(st);
        }
    }
}

