/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb;

public enum MetricAggregation {
    Min("minimum"),
    Max("maximum"),
    Avg("average", "printf('%.2f', ", ")"),
    StDev("stddev", "printf('%.2f', ", ")");

    private final String sqlStrPrefix;
    private final String sqlStrSuffix;
    private final String sqlLabel;

    private MetricAggregation(String uiLabel) {
        this(uiLabel, "", "");
    }

    private MetricAggregation(String sqlLabel, String extraPrefix, String extraSuffix) {
        this.sqlLabel = sqlLabel;
        this.sqlStrPrefix = String.valueOf(extraPrefix) + this.name().toUpperCase() + "(CAST(";
        this.sqlStrSuffix = " AS INTEGER))" + extraSuffix;
    }

    public String getSQLStr(String valueProvider) {
        return String.valueOf(this.sqlStrPrefix) + valueProvider + this.sqlStrSuffix;
    }

    public String getSQLLabel() {
        return this.sqlLabel;
    }
}

