/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.sw;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.EnforcedMigration;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="Inchron-SW-Task-EnforcedMigrationCheck", checks={"Invalid Enforced Migration of a task to a task Scheduler"})
public class InchronSWTaskEnforcedMigrationCheck
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getTask();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof Task) {
            Task task = (Task)eObject;
            HashSet<TaskScheduler> setScheduler = new HashSet<TaskScheduler>();
            if (task.getActivityGraph() == null) {
                return;
            }
            EList listItems = task.getActivityGraph().eContents();
            for (EObject item : listItems) {
                EnforcedMigration emItem;
                TaskScheduler sched;
                if (!(item instanceof EnforcedMigration) || (sched = (emItem = (EnforcedMigration)item).getResourceOwner()) == null) continue;
                setScheduler.add(emItem.getResourceOwner());
            }
            Set taskAllocations = AmaltheaIndex.getReferringObjects((EObject)task, TaskAllocation.class);
            HashSet<TaskScheduler> setSchedulerAssigned = new HashSet<TaskScheduler>();
            for (TaskAllocation taskAllocation : taskAllocations) {
                TaskScheduler sched = taskAllocation.getScheduler();
                if (sched == null) continue;
                setSchedulerAssigned.add(sched);
            }
            for (TaskScheduler sched : setScheduler) {
                if (setSchedulerAssigned.contains(sched)) continue;
                this.addIssue(results, (EObject)task, null, "Enforced Migration of task " + this.name((INamed)task) + " to Task Scheduler: " + this.name((INamed)sched) + " that is not part of the list of schedulers allocated to the task");
            }
        }
    }
}

