/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.impl;

import java.io.File;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.7.0", "output_model_version=0.7.1"}, service={IConverter.class})
public class ConstraintsConverter
extends AbstractConverter {
    private static final String AMLT_PREFIX = "amlt:/#";
    private static final String AM = "am";
    private static final String XSI = "xsi";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.7.0 to 0.7.1 : Executing Constraints converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = fileName2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.removeSchedulerPairingAndSchedulerSeparationConstraints(rootElement);
        this.updateProcessRunnableGroup(rootElement);
        this.removeOrderConstraints(rootElement);
        this.updateSynchronisationConstraints(rootElement);
    }

    private void updateSynchronisationConstraints(Element rootElement) {
        List ageConstraints = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/timingConstraints[@xsi:type=\"am:AgeConstraint\" or @xsi:type=\"am:ReactionConstraint\" or  @xsi:type=\"am:DelayConstraint\" or @xsi:type=\"am:SynchronisationConstraint\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element constraint : ageConstraints) {
            Attribute typeAttrib = constraint.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            String attribValue = typeAttrib.getValue();
            if ("am:AgeConstraint".equals(attribValue)) {
                typeAttrib.setValue("am:EventChainLatencyConstraint");
                constraint.setAttribute("type", "Age");
                continue;
            }
            if ("am:ReactionConstraint".equals(attribValue)) {
                typeAttrib.setValue("am:EventChainLatencyConstraint");
                constraint.setAttribute("type", "Reaction");
                continue;
            }
            if ("am:SynchronisationConstraint".equals(attribValue)) {
                typeAttrib.setValue("am:EventSynchronizationConstraint");
                continue;
            }
            if (!"am:DelayConstraint".equals(attribValue)) continue;
            constraint.setAttribute("mappingType", "Reaction");
        }
    }

    private void removeOrderConstraints(Element rootElement) {
        List constraints = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/timingConstraints[@xsi:type=\"am:OrderConstraint\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element constraint : constraints) {
            constraint.getParentElement().removeContent((Content)constraint);
        }
    }

    private void removeSchedulerPairingAndSchedulerSeparationConstraints(Element rootElement) {
        List constraints = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/affinityConstraints[@xsi:type=\"am:SchedulerPairingConstraint\" or @xsi:type=\"am:SchedulerSeparationConstraint\" ]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element constraint : constraints) {
            constraint.getParentElement().removeContent((Content)constraint);
        }
    }

    private void updateProcessRunnableGroup(Element rootElement) {
        List runnableGroups = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/runnableSequencingConstraints/runnableGroups", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_071, (String)AM)});
        for (Element runnableGroup : runnableGroups) {
            runnableGroup.removeAttribute("groupingType");
            List processRunnableGroupEntries = runnableGroup.getChildren("entries");
            Map.Entry<Boolean, Set<String>> resultEntry = this.getRunnableRefs(processRunnableGroupEntries);
            boolean isExternalAmaltheaModelElementReferred = resultEntry.getKey();
            Set<String> runnableRefs = resultEntry.getValue();
            if (isExternalAmaltheaModelElementReferred) {
                for (String runnableRef : runnableRefs) {
                    Element runnableRefElement = new Element("runnables");
                    if (runnableRef.contains("?")) {
                        if (!runnableRef.contains(AMLT_PREFIX)) {
                            runnableRef = AMLT_PREFIX + runnableRef;
                        }
                    } else {
                        int indexOf = runnableRef.indexOf(35);
                        if (indexOf != -1) {
                            runnableRef = runnableRef.substring(indexOf + 1);
                        }
                        runnableRef = AMLT_PREFIX + runnableRef;
                    }
                    runnableRefElement.setAttribute("href", runnableRef);
                    runnableGroup.addContent((Content)runnableRefElement);
                }
            } else {
                StringBuilder runnablesBuffer = new StringBuilder();
                for (String runnable : runnableRefs) {
                    runnablesBuffer.append(runnable);
                    runnablesBuffer.append(" ");
                }
                runnableGroup.setAttribute(new Attribute("runnables", runnablesBuffer.toString().trim()));
            }
            runnableGroup.removeChildren("entries");
        }
    }

    private Map.Entry<Boolean, Set<String>> getRunnableRefs(List<Element> processRunnableGroupEntries) {
        boolean isElementFromOtherFilePresent = false;
        LinkedHashSet<String> runnableRefs = new LinkedHashSet<String>();
        for (Element entry : processRunnableGroupEntries) {
            Element runnableElement;
            String attributeValue = entry.getAttributeValue("runnable");
            if (attributeValue == null && (runnableElement = entry.getChild("runnable")) != null && (attributeValue = runnableElement.getAttributeValue("href")) != null) {
                isElementFromOtherFilePresent = true;
            }
            if (attributeValue == null) continue;
            runnableRefs.add(attributeValue);
        }
        return new AbstractMap.SimpleEntry<Boolean, Set<String>>(isElementFromOtherFilePresent, runnableRefs);
    }
}

