/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.emf;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.util.AmaltheaValidator;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.Severity;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

@Validation(id="AM-EMF-INTRINSIC", checks={"EMF extended metadata constraints (generated)", "AMALTHEA invariants (generated)"})
public class AmEmfIntrinsic
implements IValidation {
    private static final EValidator.SubstitutionLabelProvider LABEL_PROVIDER = AmEmfIntrinsic.createCustomLabelProvider();

    public EPackage getEPackage() {
        return AmaltheaPackage.eINSTANCE;
    }

    public EClassifier getEClassifier() {
        return EcorePackage.eINSTANCE.getEObject();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> resultList) {
        if (eObject.eClass().eContainer() == this.getEPackage()) {
            BasicDiagnostic diagnostics = new BasicDiagnostic();
            HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider> context = new HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider>();
            context.put(EValidator.SubstitutionLabelProvider.class, LABEL_PROVIDER);
            boolean valid = AmaltheaValidator.INSTANCE.validate(eObject.eClass(), eObject, (DiagnosticChain)diagnostics, context);
            if (!valid) {
                for (Diagnostic emfDiagnostic : diagnostics.getChildren()) {
                    EObject problematicObject = emfDiagnostic.getData().stream().filter(EObject.class::isInstance).map(EObject.class::cast).findFirst().orElse(eObject);
                    EStructuralFeature problematicFeature = emfDiagnostic.getData().stream().filter(EStructuralFeature.class::isInstance).map(EStructuralFeature.class::cast).findFirst().orElse(null);
                    String subMessages = emfDiagnostic.getChildren().isEmpty() ? "" : emfDiagnostic.getChildren().stream().map(Diagnostic::getMessage).map(String::trim).collect(Collectors.joining(", ", " => ", ""));
                    String message = String.valueOf(emfDiagnostic.getMessage()) + this.objectOrContainerInfo(problematicObject) + subMessages;
                    ValidationDiagnostic result = new ValidationDiagnostic(message, problematicObject, problematicFeature);
                    result.setSeverityLevel(this.getSeverity(emfDiagnostic));
                    resultList.add(result);
                }
            }
        }
    }

    private Severity getSeverity(Diagnostic emfDiagnostic) {
        switch (emfDiagnostic.getSeverity()) {
            case 1: {
                return Severity.INFO;
            }
            case 2: {
                return Severity.WARNING;
            }
            case 4: {
                return Severity.ERROR;
            }
        }
        return Severity.UNDEFINED;
    }

    /*
     * WARNING - void declaration
     */
    private String objectOrContainerInfo(EObject object) {
        if (object != null) {
            IReferable container;
            EObject eObject = object;
            if (eObject instanceof IReferable) {
                void refObject;
                IReferable iReferable = (IReferable)eObject;
                IReferable cfr_ignored_0 = (IReferable)eObject;
                if (this.isValid(refObject.getName())) {
                    return " ( in " + this.objectInfo(object) + " )";
                }
            }
            if ((container = (IReferable)AmaltheaServices.getContainerOfType((EObject)object, IReferable.class)) != null && this.isValid(container.getName())) {
                return " ( in " + this.objectInfo((EObject)container) + " )";
            }
        }
        return "";
    }

    private boolean isValid(String s) {
        return s != null && !s.isEmpty();
    }

    private static EValidator.SubstitutionLabelProvider createCustomLabelProvider() {
        return new EValidator.SubstitutionLabelProvider(){

            public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
                return eStructuralFeature.getName();
            }

            /*
             * WARNING - void declaration
             */
            public String getObjectLabel(EObject eObject) {
                String string;
                String s1 = eObject.eClass().getName();
                EObject eObject2 = eObject;
                if (eObject2 instanceof INamed) {
                    void namedObject;
                    INamed iNamed = (INamed)eObject2;
                    INamed cfr_ignored_0 = (INamed)eObject2;
                    string = " " + namedObject.getName();
                } else {
                    string = "";
                }
                String s2 = string;
                return String.valueOf(s1) + s2;
            }

            public String getValueLabel(EDataType eDataType, Object value) {
                return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
            }
        };
    }
}

