/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import org.eclipse.bpmn2.modeler.core.features.ICustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class CustomTaskDescriptor
extends ModelExtensionDescriptor {
    public static final String EXTENSION_NAME = "customTask";
    protected ICustomElementFeatureContainer featureContainer;
    protected String category;
    protected String icon;
    protected String[] propertyTabs;
    protected boolean permanent;

    public CustomTaskDescriptor(IConfigurationElement e) {
        super(e);
        this.category = e.getAttribute("category");
        this.icon = e.getAttribute("icon");
        String tabs = e.getAttribute("propertyTabs");
        if (tabs != null) {
            this.propertyTabs = tabs.split(" ");
        }
        try {
            this.featureContainer = (ICustomElementFeatureContainer)e.createExecutableExtension("featureContainer");
            this.featureContainer.setCustomTaskDescriptor(this);
            this.featureContainer.setId(this.id);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        this.setPermanent(true);
    }

    @Deprecated
    public CustomTaskDescriptor(String id, String name) {
        super(id, name);
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ICustomElementFeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    public void setFeatureContainer(ICustomElementFeatureContainer featureContainer) {
        this.featureContainer = featureContainer;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public String[] getPropertyTabs() {
        if (this.propertyTabs == null) {
            this.propertyTabs = new String[0];
        }
        return this.propertyTabs;
    }

    public String getImageId(String icon, CustomTaskImageProvider.IconSize size) {
        if (icon != null && icon.trim().length() > 0) {
            String prefix = this.featureContainer.getClass().getPackage().getName();
            return String.valueOf(prefix) + "." + icon.trim() + "." + size.value;
        }
        return null;
    }

    public String getImagePath(String icon, CustomTaskImageProvider.IconSize size) {
        if (icon != null && icon.trim().length() > 0) {
            this.featureContainer.getClass().getPackage().getName();
            return "icons/" + size.value + "/" + icon.trim();
        }
        return null;
    }
}

