/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;

public class SyntaxCheckerUtils {
    private static char invalidChar;
    private static final Charset charsetUTF8;

    static {
        charsetUTF8 = Charset.forName("UTF-8");
    }

    public static char getInvalidChar() {
        return invalidChar;
    }

    public static final boolean isQName(String name) {
        invalidChar = '\u0000';
        String[] parts = name.split(":");
        if (parts.length == 1 && !name.endsWith(":")) {
            return SyntaxCheckerUtils.isNCName(parts[0]);
        }
        if (parts.length == 2) {
            if (!name.endsWith(":")) {
                return SyntaxCheckerUtils.isNCName(parts[0]) && SyntaxCheckerUtils.isNCName(parts[1]);
            }
        } else {
            invalidChar = (char)58;
        }
        return false;
    }

    public static String toQName(String name) {
        if (name == null || name.isEmpty()) {
            return "_";
        }
        String[] parts = name.split(":");
        if (parts.length == 1) {
            return SyntaxCheckerUtils.toNCName(parts[0]);
        }
        if (parts.length >= 2) {
            return String.valueOf(SyntaxCheckerUtils.toNCName(parts[0])) + ":" + SyntaxCheckerUtils.toNCName(parts[1]);
        }
        return SyntaxCheckerUtils.toNCName(name);
    }

    public static final boolean isNCName(String name) {
        invalidChar = '\u0000';
        if (name == null || name.isEmpty()) {
            return false;
        }
        int nameLength = name.length();
        char c = name.charAt(0);
        if (c == '_' || SyntaxCheckerUtils.isLetter(c)) {
            int i = 1;
            while (i < nameLength) {
                c = name.charAt(i);
                if (!SyntaxCheckerUtils.isNCNameChar(c)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        invalidChar = c;
        return false;
    }

    public static final String toNCName(String name) {
        if (name == null || name.isEmpty()) {
            return "_";
        }
        StringBuffer ncname = new StringBuffer();
        int nameLength = name.length();
        char c = name.charAt(0);
        if (c == '_' || SyntaxCheckerUtils.isLetter(c)) {
            ncname.append(c);
        } else {
            ncname.append('_');
        }
        int i = 1;
        while (i < nameLength) {
            c = name.charAt(i);
            if (!SyntaxCheckerUtils.isNCNameChar(c)) {
                c = '_';
            }
            ncname.append(c);
            ++i;
        }
        return ncname.toString();
    }

    public static final boolean isNCNameChar(char c) {
        boolean result;
        boolean bl = result = SyntaxCheckerUtils._isAsciiBaseChar(c) || SyntaxCheckerUtils._isAsciiDigit(c) || c == '.' || c == '-' || c == '_' || SyntaxCheckerUtils._isNonAsciiBaseChar(c) || SyntaxCheckerUtils._isNonAsciiDigit(c) || SyntaxCheckerUtils.isIdeographic(c) || SyntaxCheckerUtils.isCombiningChar(c) || SyntaxCheckerUtils.isExtender(c);
        if (!result) {
            invalidChar = c;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isJavaIdentifier(String name) {
        char c;
        invalidChar = '\u0000';
        if (name == null || name.isEmpty()) {
            return false;
        }
        try {
            CharBuffer charbuf = charsetUTF8.newDecoder().decode(ByteBuffer.wrap(name.getBytes()));
            c = charbuf.charAt(0);
            int nameLength = charbuf.length();
            if (Character.isJavaIdentifierStart(c)) {
                int i = 1;
                while (true) {
                    if (i >= nameLength) {
                        return true;
                    }
                    c = charbuf.charAt(i);
                    if (!Character.isJavaIdentifierPart(c)) {
                        invalidChar = c;
                        return false;
                    }
                    ++i;
                }
            }
        }
        catch (CharacterCodingException characterCodingException) {}
        int nameLength = name.length();
        c = name.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int i = 1;
        while (i < nameLength) {
            c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                invalidChar = c;
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String toJavaIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return "_";
        }
        StringBuffer ncname = new StringBuffer();
        int nameLength = name.length();
        char c = name.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            ncname.append(c);
        } else {
            ncname.append('_');
        }
        int i = 1;
        while (i < nameLength) {
            c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            ncname.append(c);
            ++i;
        }
        return ncname.toString();
    }

    public static boolean isJavaPackageName(String name) {
        invalidChar = '\u0000';
        if (name == null || name.isEmpty()) {
            return false;
        }
        String[] stringArray = name.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!SyntaxCheckerUtils.isJavaIdentifier(part)) {
                return false;
            }
            ++n2;
        }
        if (name.endsWith(".")) {
            invalidChar = (char)46;
            return false;
        }
        return true;
    }

    public static String toJavaPackageName(String name) {
        if (name == null || name.isEmpty()) {
            return "_";
        }
        String result = null;
        String[] stringArray = name.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = result == null || result.isEmpty() ? SyntaxCheckerUtils.toJavaIdentifier(part) : String.valueOf(result) + "." + SyntaxCheckerUtils.toJavaIdentifier(part);
            ++n2;
        }
        return result;
    }

    public static boolean isJavaTypespec(String name) {
        invalidChar = '\u0000';
        if (name == null || name.isEmpty()) {
            return false;
        }
        String part = "";
        int brackets = 0;
        int parts = 0;
        int last = 0;
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ' ') {
                if (!part.isEmpty()) {
                    if (!SyntaxCheckerUtils.isJavaPackageName(part)) {
                        return false;
                    }
                    ++parts;
                    part = "";
                }
            } else if (c == '<') {
                ++brackets;
                if (last != 60 && last != 44 && !SyntaxCheckerUtils.isJavaPackageName(part)) {
                    return false;
                }
                part = "";
                last = c;
            } else if (c == ',') {
                if (brackets == 0) {
                    invalidChar = c;
                    return false;
                }
                if (last != 62 && !SyntaxCheckerUtils.isJavaPackageName(part)) {
                    return false;
                }
                part = "";
                last = c;
            } else if (c == '>') {
                if (--brackets < 0) {
                    invalidChar = c;
                    return false;
                }
                if (last != 62 && !SyntaxCheckerUtils.isJavaPackageName(part)) {
                    return false;
                }
                part = "";
                last = c;
            } else {
                part = String.valueOf(part) + c;
            }
            ++n2;
        }
        if (brackets != 0) {
            invalidChar = (char)60;
            return false;
        }
        if (!(last != 62 && last != 60 && last != 44 || part.isEmpty())) {
            invalidChar = part.charAt(0);
            return false;
        }
        if (!part.isEmpty()) {
            if (!SyntaxCheckerUtils.isJavaPackageName(part)) {
                return false;
            }
            if (parts > 0) {
                invalidChar = part.charAt(0);
                return false;
            }
        }
        return true;
    }

    public static final boolean isLetter(char c) {
        return SyntaxCheckerUtils._isAsciiBaseChar(c) || SyntaxCheckerUtils._isNonAsciiBaseChar(c) || SyntaxCheckerUtils.isIdeographic(c);
    }

    public static final String toXMLString(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        StringBuffer xmlString = new StringBuffer();
        int stringLength = string.length();
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (c == '\"') {
                xmlString.append("&quot;");
            } else if (c == '&') {
                xmlString.append("&amp;");
            } else if (c == '\'') {
                xmlString.append("&apos;");
            } else if (c == '<') {
                xmlString.append("&lt;");
            } else if (c == '>') {
                xmlString.append("&gt;");
            } else {
                xmlString.append(c);
            }
            ++i;
        }
        return xmlString.toString();
    }

    public static final String fromXMLString(String xmlString) {
        if (xmlString == null || xmlString.isEmpty()) {
            return "";
        }
        StringBuffer string = new StringBuffer();
        int stringLength = xmlString.length();
        int i = 0;
        while (i < stringLength) {
            int si;
            int c = xmlString.charAt(i);
            if (c == 38 && (si = xmlString.indexOf(59, i)) > 0) {
                String ss = xmlString.substring(i, si);
                if ("&quot".equals(ss)) {
                    c = 34;
                } else if ("&amp".equals(ss)) {
                    c = 38;
                } else if ("&apos".equals(ss)) {
                    c = 39;
                } else if ("&lt".equals(ss)) {
                    c = 60;
                } else if ("&gt".equals(ss)) {
                    c = 62;
                } else {
                    si = -1;
                }
                if (si > 0) {
                    i = si;
                }
            }
            string.append((char)c);
            ++i;
        }
        return string.toString();
    }

    private static final boolean _isAsciiBaseChar(char c) {
        return SyntaxCheckerUtils._charInRange(c, 65, 90) || SyntaxCheckerUtils._charInRange(c, 97, 122);
    }

    private static final boolean _isNonAsciiBaseChar(char c) {
        return SyntaxCheckerUtils._charInRange(c, 192, 214) || SyntaxCheckerUtils._charInRange(c, 216, 246) || SyntaxCheckerUtils._charInRange(c, 248, 255) || SyntaxCheckerUtils._charInRange(c, 256, 305) || SyntaxCheckerUtils._charInRange(c, 308, 318) || SyntaxCheckerUtils._charInRange(c, 321, 328) || SyntaxCheckerUtils._charInRange(c, 330, 382) || SyntaxCheckerUtils._charInRange(c, 384, 451) || SyntaxCheckerUtils._charInRange(c, 461, 496) || SyntaxCheckerUtils._charInRange(c, 500, 501) || SyntaxCheckerUtils._charInRange(c, 506, 535) || SyntaxCheckerUtils._charInRange(c, 592, 680) || SyntaxCheckerUtils._charInRange(c, 699, 705) || c == '\u0386' || SyntaxCheckerUtils._charInRange(c, 904, 906) || c == '\u038c' || SyntaxCheckerUtils._charInRange(c, 910, 929) || SyntaxCheckerUtils._charInRange(c, 931, 974) || SyntaxCheckerUtils._charInRange(c, 976, 982) || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || SyntaxCheckerUtils._charInRange(c, 994, 1011) || SyntaxCheckerUtils._charInRange(c, 1025, 1036) || SyntaxCheckerUtils._charInRange(c, 1038, 1103) || SyntaxCheckerUtils._charInRange(c, 1105, 1116) || SyntaxCheckerUtils._charInRange(c, 1118, 1153) || SyntaxCheckerUtils._charInRange(c, 1168, 1220) || SyntaxCheckerUtils._charInRange(c, 1223, 1224) || SyntaxCheckerUtils._charInRange(c, 1227, 1228) || SyntaxCheckerUtils._charInRange(c, 1232, 1259) || SyntaxCheckerUtils._charInRange(c, 1262, 1269) || SyntaxCheckerUtils._charInRange(c, 1272, 1273) || SyntaxCheckerUtils._charInRange(c, 1329, 1366) || c == '\u0559' || SyntaxCheckerUtils._charInRange(c, 1377, 1414) || SyntaxCheckerUtils._charInRange(c, 1488, 1514) || SyntaxCheckerUtils._charInRange(c, 1520, 1522) || SyntaxCheckerUtils._charInRange(c, 1569, 1594) || SyntaxCheckerUtils._charInRange(c, 1601, 1610) || SyntaxCheckerUtils._charInRange(c, 1649, 1719) || SyntaxCheckerUtils._charInRange(c, 1722, 1726) || SyntaxCheckerUtils._charInRange(c, 1728, 1742) || SyntaxCheckerUtils._charInRange(c, 1744, 1747) || c == '\u06d5' || SyntaxCheckerUtils._charInRange(c, 1765, 1766) || SyntaxCheckerUtils._charInRange(c, 2309, 2361) || c == '\u093d' || SyntaxCheckerUtils._charInRange(c, 2392, 2401) || SyntaxCheckerUtils._charInRange(c, 2437, 2444) || SyntaxCheckerUtils._charInRange(c, 2447, 2448) || SyntaxCheckerUtils._charInRange(c, 2451, 2472) || SyntaxCheckerUtils._charInRange(c, 2474, 2480) || c == '\u09b2' || SyntaxCheckerUtils._charInRange(c, 2486, 2489) || SyntaxCheckerUtils._charInRange(c, 2524, 2525) || SyntaxCheckerUtils._charInRange(c, 2527, 2529) || SyntaxCheckerUtils._charInRange(c, 2544, 2545) || SyntaxCheckerUtils._charInRange(c, 2565, 2570) || SyntaxCheckerUtils._charInRange(c, 2575, 2576) || SyntaxCheckerUtils._charInRange(c, 2579, 2600) || SyntaxCheckerUtils._charInRange(c, 2602, 2608) || SyntaxCheckerUtils._charInRange(c, 2610, 2611) || SyntaxCheckerUtils._charInRange(c, 2613, 2614) || SyntaxCheckerUtils._charInRange(c, 2616, 2617) || SyntaxCheckerUtils._charInRange(c, 2649, 2652) || c == '\u0a5e' || SyntaxCheckerUtils._charInRange(c, 2674, 2676) || SyntaxCheckerUtils._charInRange(c, 2693, 2699) || c == '\u0a8d' || SyntaxCheckerUtils._charInRange(c, 2703, 2705) || SyntaxCheckerUtils._charInRange(c, 2707, 2728) || SyntaxCheckerUtils._charInRange(c, 2730, 2736) || SyntaxCheckerUtils._charInRange(c, 2738, 2739) || SyntaxCheckerUtils._charInRange(c, 2741, 2745) || c == '\u0abd' || c == '\u0ae0' || SyntaxCheckerUtils._charInRange(c, 2821, 2828) || SyntaxCheckerUtils._charInRange(c, 2831, 2832) || SyntaxCheckerUtils._charInRange(c, 2835, 2856) || SyntaxCheckerUtils._charInRange(c, 2858, 2864) || SyntaxCheckerUtils._charInRange(c, 2866, 2867) || SyntaxCheckerUtils._charInRange(c, 2870, 2873) || c == '\u0b3d' || SyntaxCheckerUtils._charInRange(c, 2908, 2909) || SyntaxCheckerUtils._charInRange(c, 2911, 2913) || SyntaxCheckerUtils._charInRange(c, 2949, 2954) || SyntaxCheckerUtils._charInRange(c, 2958, 2960) || SyntaxCheckerUtils._charInRange(c, 2962, 2965) || SyntaxCheckerUtils._charInRange(c, 2969, 2970) || c == '\u0b9c' || SyntaxCheckerUtils._charInRange(c, 2974, 2975) || SyntaxCheckerUtils._charInRange(c, 2979, 2980) || SyntaxCheckerUtils._charInRange(c, 2984, 2986) || SyntaxCheckerUtils._charInRange(c, 2990, 2997) || SyntaxCheckerUtils._charInRange(c, 2999, 3001) || SyntaxCheckerUtils._charInRange(c, 3077, 3084) || SyntaxCheckerUtils._charInRange(c, 3086, 3088) || SyntaxCheckerUtils._charInRange(c, 3090, 3112) || SyntaxCheckerUtils._charInRange(c, 3114, 3123) || SyntaxCheckerUtils._charInRange(c, 3125, 3129) || SyntaxCheckerUtils._charInRange(c, 3168, 3169) || SyntaxCheckerUtils._charInRange(c, 3205, 3212) || SyntaxCheckerUtils._charInRange(c, 3214, 3216) || SyntaxCheckerUtils._charInRange(c, 3218, 3240) || SyntaxCheckerUtils._charInRange(c, 3242, 3251) || SyntaxCheckerUtils._charInRange(c, 3253, 3257) || c == '\u0cde' || SyntaxCheckerUtils._charInRange(c, 3296, 3297) || SyntaxCheckerUtils._charInRange(c, 3333, 3340) || SyntaxCheckerUtils._charInRange(c, 3342, 3344) || SyntaxCheckerUtils._charInRange(c, 3346, 3368) || SyntaxCheckerUtils._charInRange(c, 3370, 3385) || SyntaxCheckerUtils._charInRange(c, 3424, 3425) || SyntaxCheckerUtils._charInRange(c, 3585, 3630) || c == '\u0e30' || SyntaxCheckerUtils._charInRange(c, 3634, 3635) || SyntaxCheckerUtils._charInRange(c, 3648, 3653) || SyntaxCheckerUtils._charInRange(c, 3713, 3714) || c == '\u0e84' || SyntaxCheckerUtils._charInRange(c, 3719, 3720) || c == '\u0e8a' || c == '\u0e8d' || SyntaxCheckerUtils._charInRange(c, 3732, 3735) || SyntaxCheckerUtils._charInRange(c, 3737, 3743) || SyntaxCheckerUtils._charInRange(c, 3745, 3747) || c == '\u0ea5' || c == '\u0ea7' || SyntaxCheckerUtils._charInRange(c, 3754, 3755) || SyntaxCheckerUtils._charInRange(c, 3757, 3758) || c == '\u0eb0' || SyntaxCheckerUtils._charInRange(c, 3762, 3763) || c == '\u0ebd' || SyntaxCheckerUtils._charInRange(c, 3776, 3780) || SyntaxCheckerUtils._charInRange(c, 3904, 3911) || SyntaxCheckerUtils._charInRange(c, 3913, 3945) || SyntaxCheckerUtils._charInRange(c, 4256, 4293) || SyntaxCheckerUtils._charInRange(c, 4304, 4342) || c == '\u1100' || SyntaxCheckerUtils._charInRange(c, 4354, 4355) || SyntaxCheckerUtils._charInRange(c, 4357, 4359) || c == '\u1109' || SyntaxCheckerUtils._charInRange(c, 4363, 4364) || SyntaxCheckerUtils._charInRange(c, 4366, 4370) || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || SyntaxCheckerUtils._charInRange(c, 4436, 4437) || c == '\u1159' || SyntaxCheckerUtils._charInRange(c, 4447, 4449) || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || SyntaxCheckerUtils._charInRange(c, 4461, 4462) || SyntaxCheckerUtils._charInRange(c, 4466, 4467) || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || SyntaxCheckerUtils._charInRange(c, 4526, 4527) || SyntaxCheckerUtils._charInRange(c, 4535, 4536) || c == '\u11ba' || SyntaxCheckerUtils._charInRange(c, 4540, 4546) || c == '\u11eb' || c == '\u11f0' || c == '\u11f9' || SyntaxCheckerUtils._charInRange(c, 7680, 7835) || SyntaxCheckerUtils._charInRange(c, 7840, 7929) || SyntaxCheckerUtils._charInRange(c, 7936, 7957) || SyntaxCheckerUtils._charInRange(c, 7960, 7965) || SyntaxCheckerUtils._charInRange(c, 7968, 8005) || SyntaxCheckerUtils._charInRange(c, 8008, 8013) || SyntaxCheckerUtils._charInRange(c, 8016, 8023) || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || SyntaxCheckerUtils._charInRange(c, 8031, 8061) || SyntaxCheckerUtils._charInRange(c, 8064, 8116) || SyntaxCheckerUtils._charInRange(c, 8118, 8124) || c == '\u1fbe' || SyntaxCheckerUtils._charInRange(c, 8130, 8132) || SyntaxCheckerUtils._charInRange(c, 8134, 8140) || SyntaxCheckerUtils._charInRange(c, 8144, 8147) || SyntaxCheckerUtils._charInRange(c, 8150, 8155) || SyntaxCheckerUtils._charInRange(c, 8160, 8172) || SyntaxCheckerUtils._charInRange(c, 8178, 8180) || SyntaxCheckerUtils._charInRange(c, 8182, 8188) || c == '\u2126' || SyntaxCheckerUtils._charInRange(c, 8490, 8491) || c == '\u212e' || SyntaxCheckerUtils._charInRange(c, 8576, 8578) || SyntaxCheckerUtils._charInRange(c, 12353, 12436) || SyntaxCheckerUtils._charInRange(c, 12449, 12538) || SyntaxCheckerUtils._charInRange(c, 12549, 12588) || SyntaxCheckerUtils._charInRange(c, 44032, 55203);
    }

    public static final boolean isIdeographic(char c) {
        return SyntaxCheckerUtils._charInRange(c, 19968, 40869) || c == '\u3007' || SyntaxCheckerUtils._charInRange(c, 12321, 12329);
    }

    public static final boolean isCombiningChar(char c) {
        return SyntaxCheckerUtils._charInRange(c, 768, 837) || SyntaxCheckerUtils._charInRange(c, 864, 865) || SyntaxCheckerUtils._charInRange(c, 1155, 1158) || SyntaxCheckerUtils._charInRange(c, 1425, 1441) || SyntaxCheckerUtils._charInRange(c, 1443, 1465) || SyntaxCheckerUtils._charInRange(c, 1467, 1469) || c == '\u05bf' || SyntaxCheckerUtils._charInRange(c, 1473, 1474) || c == '\u05c4' || SyntaxCheckerUtils._charInRange(c, 1611, 1618) || c == '\u0670' || SyntaxCheckerUtils._charInRange(c, 1750, 1756) || SyntaxCheckerUtils._charInRange(c, 1757, 1759) || SyntaxCheckerUtils._charInRange(c, 1760, 1764) || SyntaxCheckerUtils._charInRange(c, 1767, 1768) || SyntaxCheckerUtils._charInRange(c, 1770, 1773) || SyntaxCheckerUtils._charInRange(c, 2305, 2307) || c == '\u093c' || SyntaxCheckerUtils._charInRange(c, 2366, 2380) || c == '\u094d' || SyntaxCheckerUtils._charInRange(c, 2385, 2388) || SyntaxCheckerUtils._charInRange(c, 2402, 2403) || SyntaxCheckerUtils._charInRange(c, 2433, 2435) || c == '\u09bc' || c == '\u09be' || c == '\u09bf' || SyntaxCheckerUtils._charInRange(c, 2496, 2500) || SyntaxCheckerUtils._charInRange(c, 2503, 2504) || SyntaxCheckerUtils._charInRange(c, 2507, 2509) || c == '\u09d7' || SyntaxCheckerUtils._charInRange(c, 2530, 2531) || c == '\u0a02' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || SyntaxCheckerUtils._charInRange(c, 2624, 2626) || SyntaxCheckerUtils._charInRange(c, 2631, 2632) || SyntaxCheckerUtils._charInRange(c, 2635, 2637) || SyntaxCheckerUtils._charInRange(c, 2672, 2673) || SyntaxCheckerUtils._charInRange(c, 2689, 2691) || c == '\u0abc' || SyntaxCheckerUtils._charInRange(c, 2750, 2757) || SyntaxCheckerUtils._charInRange(c, 2759, 2761) || SyntaxCheckerUtils._charInRange(c, 2763, 2765) || SyntaxCheckerUtils._charInRange(c, 2817, 2819) || c == '\u0b3c' || SyntaxCheckerUtils._charInRange(c, 2878, 2883) || SyntaxCheckerUtils._charInRange(c, 2887, 2888) || SyntaxCheckerUtils._charInRange(c, 2891, 2893) || SyntaxCheckerUtils._charInRange(c, 2902, 2903) || SyntaxCheckerUtils._charInRange(c, 2946, 2947) || SyntaxCheckerUtils._charInRange(c, 3006, 3010) || SyntaxCheckerUtils._charInRange(c, 3014, 3016) || SyntaxCheckerUtils._charInRange(c, 3018, 3021) || c == '\u0bd7' || SyntaxCheckerUtils._charInRange(c, 3073, 3075) || SyntaxCheckerUtils._charInRange(c, 3134, 3140) || SyntaxCheckerUtils._charInRange(c, 3142, 3144) || SyntaxCheckerUtils._charInRange(c, 3146, 3149) || SyntaxCheckerUtils._charInRange(c, 3157, 3158) || SyntaxCheckerUtils._charInRange(c, 3202, 3203) || SyntaxCheckerUtils._charInRange(c, 3262, 3268) || SyntaxCheckerUtils._charInRange(c, 3270, 3272) || SyntaxCheckerUtils._charInRange(c, 3274, 3277) || SyntaxCheckerUtils._charInRange(c, 3285, 3286) || SyntaxCheckerUtils._charInRange(c, 3330, 3331) || SyntaxCheckerUtils._charInRange(c, 3390, 3395) || SyntaxCheckerUtils._charInRange(c, 3398, 3400) || SyntaxCheckerUtils._charInRange(c, 3402, 3405) || c == '\u0d57' || c == '\u0e31' || SyntaxCheckerUtils._charInRange(c, 3636, 3642) || SyntaxCheckerUtils._charInRange(c, 3655, 3662) || c == '\u0eb1' || SyntaxCheckerUtils._charInRange(c, 3764, 3769) || SyntaxCheckerUtils._charInRange(c, 3771, 3772) || SyntaxCheckerUtils._charInRange(c, 3784, 3789) || SyntaxCheckerUtils._charInRange(c, 3864, 3865) || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c == '\u0f3e' || c == '\u0f3f' || SyntaxCheckerUtils._charInRange(c, 3953, 3972) || SyntaxCheckerUtils._charInRange(c, 3974, 3979) || SyntaxCheckerUtils._charInRange(c, 3984, 3989) || c == '\u0f97' || SyntaxCheckerUtils._charInRange(c, 3993, 4013) || SyntaxCheckerUtils._charInRange(c, 4017, 4023) || c == '\u0fb9' || SyntaxCheckerUtils._charInRange(c, 8400, 8412) || c == '\u20e1' || SyntaxCheckerUtils._charInRange(c, 12330, 12335) || c == '\u3099' || c == '\u309a';
    }

    public static final boolean isDigit(char c) {
        return SyntaxCheckerUtils._isAsciiDigit(c) || SyntaxCheckerUtils._isNonAsciiDigit(c);
    }

    private static final boolean _isAsciiDigit(char c) {
        return SyntaxCheckerUtils._charInRange(c, 48, 57);
    }

    private static final boolean _isNonAsciiDigit(char c) {
        return SyntaxCheckerUtils._charInRange(c, 1632, 1641) || SyntaxCheckerUtils._charInRange(c, 1776, 1785) || SyntaxCheckerUtils._charInRange(c, 2406, 2415) || SyntaxCheckerUtils._charInRange(c, 2534, 2543) || SyntaxCheckerUtils._charInRange(c, 2662, 2671) || SyntaxCheckerUtils._charInRange(c, 2790, 2799) || SyntaxCheckerUtils._charInRange(c, 2918, 2927) || SyntaxCheckerUtils._charInRange(c, 3047, 3055) || SyntaxCheckerUtils._charInRange(c, 3174, 3183) || SyntaxCheckerUtils._charInRange(c, 3302, 3311) || SyntaxCheckerUtils._charInRange(c, 3430, 3439) || SyntaxCheckerUtils._charInRange(c, 3664, 3673) || SyntaxCheckerUtils._charInRange(c, 3792, 3801) || SyntaxCheckerUtils._charInRange(c, 3872, 3881);
    }

    public static final boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || SyntaxCheckerUtils._charInRange(c, 12337, 12341) || SyntaxCheckerUtils._charInRange(c, 12445, 12446) || SyntaxCheckerUtils._charInRange(c, 12540, 12542);
    }

    private static final boolean _charInRange(char c, int start, int end) {
        return c >= start && c <= end;
    }
}

