/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.gradleware.tooling.toolingclient.BuildActionRequest;
import com.gradleware.tooling.toolingclient.BuildRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.ModelRequest;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.buildaction.BuildActionFactory;
import com.gradleware.tooling.toolingmodel.buildaction.RootModelsForCompositeProjectBuildAction;
import com.gradleware.tooling.toolingmodel.repository.BuildEnvironmentUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.EclipseProjectUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.GradleBuildUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.GradleProjectUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.Converter;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleProject;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;

public final class DefaultModelRepository
implements ModelRepository {
    private final ToolingClient toolingClient;
    private final EventBus eventBus;
    private final Cache<Object, Object> cache;
    private final FixedRequestAttributes fixedRequestAttributes;

    public DefaultModelRepository(FixedRequestAttributes fixedRequestAttributes, ToolingClient toolingClient, EventBus eventBus) {
        this.toolingClient = (ToolingClient)Preconditions.checkNotNull((Object)toolingClient);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.cache = CacheBuilder.newBuilder().build();
        this.fixedRequestAttributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)fixedRequestAttributes);
    }

    @Override
    public void register(Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.eventBus.register(listener);
    }

    @Override
    public void unregister(Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.eventBus.unregister(listener);
    }

    @Override
    public OmniBuildEnvironment fetchBuildEnvironment(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        ModelRequest<BuildEnvironment> request = this.createModelRequestForBuildModel(BuildEnvironment.class, transientRequestAttributes);
        Consumer<OmniBuildEnvironment> successHandler = new Consumer<OmniBuildEnvironment>(){

            public void accept(OmniBuildEnvironment result) {
                DefaultModelRepository.this.eventBus.post((Object)new BuildEnvironmentUpdateEvent(result));
            }
        };
        BaseConverter<BuildEnvironment, OmniBuildEnvironment> converter = new BaseConverter<BuildEnvironment, OmniBuildEnvironment>(){

            @Override
            public OmniBuildEnvironment apply(BuildEnvironment buildEnvironment) {
                return DefaultOmniBuildEnvironment.from(buildEnvironment);
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class<?>)OmniBuildEnvironment.class, (Converter)converter);
    }

    @Override
    public OmniGradleBuild fetchGradleBuild(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        ModelRequest<GradleBuild> request = this.createModelRequestForBuildModel(GradleBuild.class, transientRequestAttributes);
        Consumer<OmniGradleBuild> successHandler = new Consumer<OmniGradleBuild>(){

            public void accept(OmniGradleBuild result) {
                DefaultModelRepository.this.eventBus.post((Object)new GradleBuildUpdateEvent(result));
            }
        };
        BaseConverter<GradleBuild, OmniGradleBuild> converter = new BaseConverter<GradleBuild, OmniGradleBuild>(){

            @Override
            public OmniGradleBuild apply(GradleBuild gradleBuild) {
                return DefaultOmniGradleBuild.from(gradleBuild);
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class<?>)GradleBuild.class, (Converter)converter);
    }

    @Override
    public Set<OmniGradleProject> fetchGradleProjects(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        if (!this.supportsCompositeBuilds(transientRequestAttributes)) {
            ModelRequest<GradleProject> request = this.createModelRequestForBuildModel(GradleProject.class, transientRequestAttributes);
            Consumer<Set<OmniGradleProject>> successHandler = new Consumer<Set<OmniGradleProject>>(){

                public void accept(Set<OmniGradleProject> result) {
                    DefaultModelRepository.this.eventBus.post((Object)new GradleProjectUpdateEvent(result));
                }
            };
            BaseConverter<GradleProject, Set<OmniGradleProject>> converter = new BaseConverter<GradleProject, Set<OmniGradleProject>>(){

                @Override
                public Set<OmniGradleProject> apply(GradleProject gradleProject) {
                    return ImmutableSet.copyOf(DefaultOmniGradleProject.from(gradleProject).getAll());
                }
            };
            return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class<?>)OmniGradleProject.class, (Converter)converter);
        }
        BuildActionRequest<Collection<GradleProject>> request = this.createBuildActionRequestForCompositeModel(GradleProject.class, transientRequestAttributes);
        Consumer<Set<OmniGradleProject>> successHandler = new Consumer<Set<OmniGradleProject>>(){

            public void accept(Set<OmniGradleProject> result) {
                DefaultModelRepository.this.eventBus.post((Object)new GradleProjectUpdateEvent(result));
            }
        };
        BaseConverter<Collection<GradleProject>, Set<OmniGradleProject>> converter = new BaseConverter<Collection<GradleProject>, Set<OmniGradleProject>>(){

            @Override
            public Set<OmniGradleProject> apply(Collection<GradleProject> gradleProjects) {
                ImmutableSet.Builder projects = ImmutableSet.builder();
                for (GradleProject gradleProject : gradleProjects) {
                    projects.addAll(DefaultOmniGradleProject.from(gradleProject).getAll());
                }
                return projects.build();
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class<?>)OmniGradleProject.class, (Converter)converter);
    }

    @Override
    public Set<OmniEclipseProject> fetchEclipseGradleProjects(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        if (!this.supportsCompositeBuilds(transientRequestAttributes)) {
            ModelRequest<EclipseProject> request = this.createModelRequestForBuildModel(EclipseProject.class, transientRequestAttributes);
            Consumer<Set<OmniEclipseProject>> successHandler = new Consumer<Set<OmniEclipseProject>>(){

                public void accept(Set<OmniEclipseProject> result) {
                    DefaultModelRepository.this.eventBus.post((Object)new EclipseProjectUpdateEvent(result));
                }
            };
            BaseConverter<EclipseProject, Set<OmniEclipseProject>> converter = new BaseConverter<EclipseProject, Set<OmniEclipseProject>>(){

                @Override
                public Set<OmniEclipseProject> apply(EclipseProject eclipseProject) {
                    return ImmutableSet.copyOf(DefaultOmniEclipseProject.from(eclipseProject).getAll());
                }
            };
            return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class<?>)OmniEclipseProject.class, (Converter)converter);
        }
        BuildActionRequest<Collection<EclipseProject>> request = this.createBuildActionRequestForCompositeModel(EclipseProject.class, transientRequestAttributes);
        Consumer<Set<OmniEclipseProject>> successHandler = new Consumer<Set<OmniEclipseProject>>(){

            public void accept(Set<OmniEclipseProject> result) {
                DefaultModelRepository.this.eventBus.post((Object)new EclipseProjectUpdateEvent(result));
            }
        };
        BaseConverter<Collection<EclipseProject>, Set<OmniEclipseProject>> converter = new BaseConverter<Collection<EclipseProject>, Set<OmniEclipseProject>>(){

            @Override
            public Set<OmniEclipseProject> apply(Collection<EclipseProject> eclipseProjects) {
                ImmutableSet.Builder projects = ImmutableSet.builder();
                for (EclipseProject eclipseProject : eclipseProjects) {
                    projects.addAll(DefaultOmniEclipseProject.from(eclipseProject).getAll());
                }
                return projects.build();
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class<?>)OmniEclipseProject.class, (Converter)converter);
    }

    private boolean supportsCompositeBuilds(TransientRequestAttributes transientRequestAttributes) {
        return this.targetGradleVersionIsEqualOrHigherThan("3.3", transientRequestAttributes);
    }

    private boolean targetGradleVersionIsEqualOrHigherThan(String refVersion, TransientRequestAttributes transientRequestAttributes) {
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment(transientRequestAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)refVersion)) >= 0;
    }

    private <T> ModelRequest<T> createModelRequestForBuildModel(Class<T> model, TransientRequestAttributes transientRequestAttributes) {
        ModelRequest request = this.toolingClient.newModelRequest(model);
        this.fixedRequestAttributes.apply((BuildRequest<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    private <T> BuildActionRequest<Collection<T>> createBuildActionRequestForCompositeModel(Class<T> model, TransientRequestAttributes transientRequestAttributes) {
        RootModelsForCompositeProjectBuildAction<T> buildAction = BuildActionFactory.getModelForCompositeProjects(model);
        BuildActionRequest request = this.toolingClient.newBuildActionRequest(buildAction);
        this.fixedRequestAttributes.apply((BuildRequest<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    private <T> BuildActionRequest<T> createBuildActionRequestForBuildAction(BuildAction<T> buildAction, TransientRequestAttributes transientRequestAttributes) {
        BuildActionRequest request = this.toolingClient.newBuildActionRequest(buildAction);
        this.fixedRequestAttributes.apply((BuildRequest<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    protected <T, U> U executeRequest(final Request<T> request, Consumer<U> newCacheEntryHandler, FetchStrategy fetchStrategy, Class<?> cacheKey, Converter<T, U> resultConverter) {
        return this.executeRequest(new Supplier<T>(){

            public T get() {
                return request.executeAndWait();
            }
        }, newCacheEntryHandler, fetchStrategy, cacheKey, resultConverter);
    }

    protected <T, U> U executeRequest(final Supplier<T> operation, Consumer<U> newCacheEntryHandler, FetchStrategy fetchStrategy, Class<?> cacheKey, final Converter<T, U> resultConverter) {
        if (FetchStrategy.FROM_CACHE_ONLY == fetchStrategy) {
            Object result = this.cache.getIfPresent(cacheKey);
            return (U)result;
        }
        if (FetchStrategy.FORCE_RELOAD == fetchStrategy) {
            this.cache.invalidate(cacheKey);
        }
        final AtomicBoolean modelLoaded = new AtomicBoolean(false);
        U value = this.getFromCache(cacheKey, new Callable<U>(){

            @Override
            public U call() {
                Object model = DefaultModelRepository.this.executeAndWait(operation, resultConverter);
                modelLoaded.set(true);
                return model;
            }
        });
        if (modelLoaded.get()) {
            newCacheEntryHandler.accept(value);
        }
        return value;
    }

    private <U> U getFromCache(Class<?> cacheKey, Callable<U> cacheValueLoader) {
        try {
            Object result = this.cache.get(cacheKey, cacheValueLoader);
            return (U)result;
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private <T, U> U executeAndWait(Supplier<T> operation, Converter<T, U> resultConverter) {
        Object result = operation.get();
        return (U)resultConverter.apply(result);
    }
}

