/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.workspace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.util.collections.AdapterFunction;
import org.eclipse.buildship.core.workspace.GradleBuilds;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public final class ProjectSynchronizer {
    public static void execute(ExecutionEvent event) {
        Set<IProject> selectedProjects = ProjectSynchronizer.collectSelectedProjects(event);
        if (selectedProjects.isEmpty()) {
            return;
        }
        GradleBuilds gradleBuilds = CorePlugin.gradleWorkspaceManager().getGradleBuilds(selectedProjects);
        gradleBuilds.synchronize(NewProjectHandler.IMPORT_AND_MERGE);
    }

    private static Set<IProject> collectSelectedProjects(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            return ProjectSynchronizer.collectGradleProjects(selection.toList());
        }
        IEditorInput editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        if (editorInput instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)editorInput).getFile();
            return ProjectSynchronizer.collectGradleProjects(ImmutableList.of((Object)file));
        }
        return ImmutableSet.of();
    }

    private static Set<IProject> collectGradleProjects(List<?> candidates) {
        LinkedHashSet projects = Sets.newLinkedHashSet();
        AdapterFunction adapterFunction = AdapterFunction.forType(IResource.class);
        for (Object candidate : candidates) {
            IResource resource = (IResource)adapterFunction.apply(candidate);
            if (resource == null) continue;
            projects.add(resource.getProject());
        }
        return projects;
    }
}

