/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.gradle.GradleDistributionSerializer;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.view.task.TaskViewActionStateRules;
import org.eclipse.core.resources.IProject;

public final class TaskNodeSelectionUtils {
    private TaskNodeSelectionUtils() {
    }

    public static boolean isValidRunConfiguration(NodeSelection selection) {
        return TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean() || TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection);
    }

    public static Optional<GradleRunConfigurationAttributes> tryGetRunConfigurationAttributes(NodeSelection selection) {
        if (TaskNodeSelectionUtils.isValidRunConfiguration(selection)) {
            return Optional.of((Object)TaskNodeSelectionUtils.getRunConfigurationAttributes(selection));
        }
        return Optional.absent();
    }

    public static GradleRunConfigurationAttributes getRunConfigurationAttributes(NodeSelection selection) {
        Preconditions.checkNotNull((Object)selection);
        ImmutableList<String> tasks = TaskNodeSelectionUtils.getTaskPathStrings(selection);
        if (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean()) {
            return TaskNodeSelectionUtils.runConfigAttributesForTask(selection, tasks);
        }
        if (TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) {
            return TaskNodeSelectionUtils.runConfigAttributesForProject(selection, tasks);
        }
        throw new IllegalStateException("Unsupported selection: " + selection);
    }

    private static GradleRunConfigurationAttributes runConfigAttributesForTask(NodeSelection selection, List<String> tasks) {
        TaskNode taskNode = selection.getFirstElement(TaskNode.class);
        File rootDir = taskNode.getParentProjectNode().getEclipseProject().getRoot().getProjectDirectory();
        File workingDir = TaskNodeSelectionUtils.workingDirForTask(taskNode, rootDir);
        return TaskNodeSelectionUtils.createARunConfigAttributes(rootDir, workingDir, tasks);
    }

    private static File workingDirForTask(TaskNode taskNode, File rootDir) {
        if (taskNode instanceof ProjectTaskNode) {
            return rootDir;
        }
        if (taskNode instanceof TaskSelectorNode) {
            return taskNode.getParentProjectNode().getEclipseProject().getProjectDirectory();
        }
        throw new GradlePluginsRuntimeException("Unrecognized task type " + taskNode.getClass().getName());
    }

    private static GradleRunConfigurationAttributes runConfigAttributesForProject(NodeSelection selection, List<String> tasks) {
        ProjectNode projectNode = selection.getFirstElement(ProjectNode.class);
        File rootDir = projectNode.getEclipseProject().getRoot().getProjectDirectory();
        return TaskNodeSelectionUtils.createARunConfigAttributes(rootDir, rootDir, tasks);
    }

    private static GradleRunConfigurationAttributes createARunConfigAttributes(File rootDir, File workingDir, List<String> tasks) {
        BuildConfiguration buildConfig = CorePlugin.configurationManager().loadBuildConfiguration(rootDir);
        return new GradleRunConfigurationAttributes(tasks, TaskNodeSelectionUtils.projectDirectoryExpression(workingDir), GradleDistributionSerializer.INSTANCE.serializeToString(buildConfig.getGradleDistribution()), TaskNodeSelectionUtils.gradleUserHomeExpression(buildConfig.getGradleUserHome()), null, Collections.emptyList(), Collections.emptyList(), true, true, buildConfig.isOverrideWorkspaceSettings(), buildConfig.isOfflineMode(), buildConfig.isBuildScansEnabled());
    }

    private static String projectDirectoryExpression(File rootProjectDir) {
        Optional project = CorePlugin.workspaceOperations().findProjectByLocation(rootProjectDir);
        if (project.isPresent()) {
            return ExpressionUtils.encodeWorkspaceLocation((IProject)((IProject)project.get()));
        }
        return rootProjectDir.getAbsolutePath();
    }

    private static String gradleUserHomeExpression(File gradleUserHome) {
        return gradleUserHome == null ? "" : gradleUserHome.getAbsolutePath();
    }

    private static ImmutableList<String> getTaskPathStrings(NodeSelection selection) {
        if (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean()) {
            ImmutableList.Builder taskStrings = ImmutableList.builder();
            block4: for (TaskNode node : selection.toList(TaskNode.class)) {
                TaskNode.TaskNodeType type = node.getType();
                switch (type) {
                    case PROJECT_TASK_NODE: {
                        taskStrings.add((Object)((ProjectTaskNode)node).getProjectTask().getPath().getPath());
                        continue block4;
                    }
                    case TASK_SELECTOR_NODE: {
                        taskStrings.add((Object)((TaskSelectorNode)node).getTaskSelector().getName());
                        continue block4;
                    }
                }
                throw new IllegalStateException("Unsupported Task node type: " + (Object)((Object)type));
            }
            return taskStrings.build();
        }
        if (TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) {
            return ImmutableList.of();
        }
        throw new IllegalStateException("Unsupported selection: " + selection);
    }
}

