/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.adapters;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.emf.ecore.EObject;

public class Connection {
    private EObject origin;
    private List<EObject> targets;
    private EObject tlink;

    public Connection(EObject origin, List<EObject> targets, EObject tlink) {
        this.origin = origin;
        this.targets = targets;
        this.tlink = tlink;
    }

    public EObject getOrigin() {
        return this.origin;
    }

    public List<EObject> getTargets() {
        return this.targets;
    }

    public EObject getTlink() {
        return this.tlink;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Connection)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Connection connection = (Connection)object;
        ArrayList<EObject> allFirstElements = new ArrayList<EObject>(this.getTargets());
        allFirstElements.add(this.getOrigin());
        ArrayList<EObject> allSecondElements = new ArrayList<EObject>(connection.getTargets());
        allSecondElements.add(connection.getOrigin());
        String firstTraceType = EMFHelper.getIdentifier((EObject)this.getTlink().eClass());
        String secondTracetype = EMFHelper.getIdentifier((EObject)connection.getTlink().eClass());
        if (!firstTraceType.equals(secondTracetype)) {
            return false;
        }
        List firstElementsIds = allFirstElements.stream().map(e -> EMFHelper.getIdentifier(e)).collect(Collectors.toList());
        List secondElementsIds = allSecondElements.stream().map(e -> EMFHelper.getIdentifier(e)).collect(Collectors.toList());
        return firstElementsIds.containsAll(secondElementsIds);
    }
}

