/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.zest;

import com.google.inject.Module;
import java.util.List;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.helpers.TraceCreationHelper;
import org.eclipse.capra.ui.zest.TraceNodeContentProvider;
import org.eclipse.capra.ui.zest.TraceNodeLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef4.common.adapt.inject.AdapterInjectionSupport;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.zest.fx.jface.ZestContentViewer;
import org.eclipse.gef4.zest.fx.jface.ZestFxJFaceModule;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ZestView
extends ViewPart {
    static ZestContentViewer viewer = null;
    private ISelectionListener selectionListener;

    public void createPartControl(Composite parent) {
        final TracePersistenceAdapter tracePersistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        viewer = new ZestContentViewer((Module)new ZestViewModule());
        viewer.createControl(parent, 0);
        viewer.setLabelProvider((IBaseLabelProvider)new TraceNodeLabelProvider());
        TreeLayoutAlgorithm layout = new TreeLayoutAlgorithm();
        viewer.setLayoutAlgorithm((ILayoutAlgorithm)layout);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                List selectedModels = TraceCreationHelper.extractSelectedElements((ISelection)selection);
                if (selectedModels.size() >= 1 && selectedModels.get(0) instanceof EObject) {
                    EObject selectedEObject = (EObject)selectedModels.get(0);
                    ResourceSet resourceSet = selectedEObject.eResource().getResourceSet();
                    EObject traceModel = tracePersistenceAdapter.getTraceModel(resourceSet);
                    TraceMetaModelAdapter metaModelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
                    viewer.setContentProvider((IContentProvider)new TraceNodeContentProvider(traceModel, metaModelAdapter, selectedModels));
                    viewer.setInput(null);
                    viewer.refresh();
                }
            }
        };
        this.getViewSite().getPage().addSelectionListener(this.selectionListener);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
        super.dispose();
    }

    public void setFocus() {
    }

    public class ZestViewModule
    extends ZestFxJFaceModule {
        protected void enableAdapterMapInjection() {
            this.install((Module)new AdapterInjectionSupport(AdapterInjectionSupport.LoggingMode.PRODUCTION));
        }
    }
}

