/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class CloudServerUtil {
    private CloudServerUtil() {
    }

    public static List<CloudFoundryServer> getCloudServers() {
        IServer[] servers = ServerCore.getServers();
        HashSet<CloudFoundryServer> matchedServers = new HashSet<CloudFoundryServer>();
        if (servers != null) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                CloudFoundryServer cfServer = (CloudFoundryServer)((Object)server.loadAdapter(CloudFoundryServer.class, null));
                if (cfServer != null) {
                    matchedServers.add(cfServer);
                }
                ++n2;
            }
        }
        return new ArrayList<CloudFoundryServer>(matchedServers);
    }

    public static CloudFoundryServer getCloudServer(String serverID) {
        IServer[] servers = ServerCore.getServers();
        if (servers == null) {
            return null;
        }
        CloudFoundryServer cfServer = null;
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            cfServer = (CloudFoundryServer)((Object)server.loadAdapter(CloudFoundryServer.class, null));
            if (cfServer != null && cfServer.getServerId().equals(serverID)) break;
            ++n2;
        }
        return cfServer;
    }

    public static boolean isCloudFoundryServer(IServer server) {
        if (server != null) {
            return CloudServerUtil.isCloudFoundryServerType(server.getServerType());
        }
        return false;
    }

    public static boolean isCloudFoundryServerType(IServerType serverType) {
        if (serverType != null) {
            String serverId = serverType.getId();
            return CloudFoundryBrandingExtensionPoint.getServerTypeIds().contains(serverId);
        }
        return false;
    }
}

