/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.CloudServerSpacesDelegate;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.ServerDescriptor;
import org.eclipse.cft.server.ui.internal.ServerHandler;
import org.eclipse.cft.server.ui.internal.ServerHandlerCallback;
import org.eclipse.cft.server.ui.internal.wizards.CloneServerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class OrgsAndSpacesWizard
extends Wizard {
    private final CloudFoundryServer cloudServer;
    private CloneServerPage cloudSpacePage;

    public OrgsAndSpacesWizard(CloudFoundryServer server) {
        this.cloudServer = server;
        this.setWindowTitle(server.getServer().getName());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.cloudSpacePage = new CloneServerPage(this.cloudServer);
        this.cloudSpacePage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.cloudSpacePage);
    }

    public boolean performFinish() {
        final CloudSpace selectedSpace = this.cloudSpacePage.getSelectedCloudSpace();
        if (selectedSpace != null && !CloudServerSpacesDelegate.matchesSpace(selectedSpace, this.cloudServer.getCloudFoundrySpace())) {
            String serverName = this.cloudSpacePage.getServerName();
            final ServerDescriptor descriptor = ServerDescriptor.getServerDescriptor(this.cloudServer, serverName);
            if (descriptor == null) {
                CloudFoundryPlugin.logError((String)NLS.bind((String)Messages.ERROR_NO_CLOUD_SERVER_DESCRIPTOR, (Object)this.cloudServer.getServerId()));
                return false;
            }
            final String password = this.cloudServer.getPassword();
            final String userName = this.cloudServer.getUsername();
            final String url = this.cloudServer.getUrl();
            final boolean selfSignedCert = this.cloudServer.isSelfSigned();
            CFUiUtil.runForked(new ICoreRunnable(){

                @Override
                public void run(final IProgressMonitor monitor) throws CoreException {
                    ServerHandler serverHandler = new ServerHandler(descriptor);
                    serverHandler.createServer(monitor, ServerHandler.NEVER_OVERWRITE, new ServerHandlerCallback(){

                        @Override
                        public void configureServer(IServerWorkingCopy wc) throws CoreException {
                            CloudFoundryServer cloudServer = (CloudFoundryServer)wc.loadAdapter(CloudFoundryServer.class, null);
                            if (cloudServer != null) {
                                cloudServer.setPassword(password);
                                cloudServer.setUsername(userName);
                                cloudServer.setUrl(url);
                                cloudServer.setSpace(selectedSpace);
                                cloudServer.setSelfSigned(selfSignedCert);
                                cloudServer.saveConfiguration(monitor);
                            }
                        }
                    });
                }
            }, (IWizard)this);
        }
        return true;
    }
}

