/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.ModulesUpdatedEvent;
import org.eclipse.cft.server.core.internal.client.ServicesUpdatedEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;

public class ServerEventHandler {
    private static ServerEventHandler handler;
    private final List<CloudServerListener> applicationListeners = new CopyOnWriteArrayList<CloudServerListener>();

    public static ServerEventHandler getDefault() {
        if (handler == null) {
            handler = new ServerEventHandler();
        }
        return handler;
    }

    public synchronized void addServerListener(CloudServerListener listener) {
        if (listener != null && !this.applicationListeners.contains(listener)) {
            this.applicationListeners.add(listener);
        }
    }

    public synchronized void removeServerListener(CloudServerListener listener) {
        this.applicationListeners.remove(listener);
    }

    public void fireServicesUpdated(CloudFoundryServer server, List<CFServiceInstance> services) {
        this.fireServerEvent(new ServicesUpdatedEvent(server, 200, services));
    }

    public void firePasswordUpdated(CloudFoundryServer server, IStatus status) {
        this.fireServerEvent(new CloudServerEvent(server, 300, status));
    }

    public void fireUpdateCompleted(CloudFoundryServer server) {
        this.fireServerEvent(new CloudServerEvent(server, 401));
    }

    public void fireUpdateStarting(CloudFoundryServer server) {
        this.fireServerEvent(new CloudServerEvent(server, 400));
    }

    public void fireAppInstancesChanged(CloudFoundryServer server, IModule module) {
        this.fireServerEvent(new ModuleChangeEvent(server, 100, module, Status.OK_STATUS));
    }

    public void fireModuleUpdated(CloudFoundryServer server, IModule module) {
        this.fireServerEvent(new ModuleChangeEvent(server, 310, module, Status.OK_STATUS));
    }

    public void fireModulesUpdated(CloudFoundryServer server, IModule[] modules) {
        this.fireServerEvent(new ModulesUpdatedEvent(server, 320, modules));
    }

    public void fireAppDeploymentChanged(CloudFoundryServer server, IModule module) {
        this.fireServerEvent(new ModuleChangeEvent(server, 410, module, Status.OK_STATUS));
    }

    public void fireError(CloudFoundryServer server, IModule module, IStatus status) {
        this.fireServerEvent(new ModuleChangeEvent(server, 600, module, status));
    }

    public synchronized void fireServerEvent(CloudServerEvent event) {
        CloudServerListener[] listeners;
        CloudServerListener[] cloudServerListenerArray = listeners = this.applicationListeners.toArray(new CloudServerListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            CloudServerListener listener = cloudServerListenerArray[n2];
            listener.serverChanged(event);
            ++n2;
        }
    }
}

