/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import org.eclipse.cft.server.core.internal.log.HttpTracer;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CloudFoundryTracePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean isTracingEnabled;

    public CloudFoundryTracePreferencePage() {
        this.setPreferenceStore(CloudFoundryServerUiPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(topComposite);
        GridDataFactory.fillDefaults().grab(true, true);
        final Button enableTracing = new Button(topComposite, 32);
        GridDataFactory.fillDefaults().grab(false, false);
        enableTracing.setText(Messages.LABEL_ENABLE_TRACING);
        enableTracing.setToolTipText(Messages.TOOLTIP_ENABLE_TRACING);
        this.isTracingEnabled = HttpTracer.getCurrent().isEnabled();
        enableTracing.setSelection(this.isTracingEnabled);
        enableTracing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudFoundryTracePreferencePage.this.isTracingEnabled = enableTracing.getSelection();
            }
        });
        return topComposite;
    }

    protected void performApply() {
        HttpTracer.getCurrent().enableTracing(this.isTracingEnabled);
        super.performApply();
    }

    public boolean performOk() {
        HttpTracer.getCurrent().enableTracing(this.isTracingEnabled);
        return super.performOk();
    }
}

