/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryViewerSorter;
import org.eclipse.cft.server.ui.internal.editor.ServiceViewColumn;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableColumn;

public class ServiceViewerSorter
extends CloudFoundryViewerSorter {
    private final TableViewer tableViewer;

    public ServiceViewerSorter(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    @Override
    public int compare(Viewer viewer, Object e1, Object e2) {
        TableColumn sortColumn = this.tableViewer.getTable().getSortColumn();
        if (sortColumn != null) {
            ServiceViewColumn serviceColumn = (ServiceViewColumn)((Object)sortColumn.getData());
            int result = 0;
            int sortDirection = this.tableViewer.getTable().getSortDirection();
            if (serviceColumn != null && e1 instanceof CloudService && e2 instanceof CloudService) {
                CloudService service1 = (CloudService)e1;
                CloudService service2 = (CloudService)e2;
                switch (serviceColumn) {
                    case Name: {
                        result = super.compare((Viewer)this.tableViewer, e1, e2);
                        break;
                    }
                    default: {
                        result = this.compare(service1, service2, serviceColumn);
                    }
                }
            }
            return sortDirection == 128 ? result : -result;
        }
        return super.compare(viewer, e1, e2);
    }

    protected int compare(CloudService service1, CloudService service2, ServiceViewColumn sortColumn) {
        int result = 0;
        switch (sortColumn) {
            case Version: {
                result = service1.getVersion() != null ? service1.getVersion().compareTo(service2.getVersion()) : 0;
                break;
            }
            case Vendor: {
                result = service1.getLabel() != null ? service1.getLabel().compareTo(service2.getLabel()) : 0;
                break;
            }
            case Plan: {
                result = service1.getPlan() != null ? service1.getPlan().compareTo(service2.getPlan()) : 0;
                break;
            }
            case Provider: {
                result = service1.getProvider() != null ? service1.getProvider().compareTo(service2.getProvider()) : 0;
            }
        }
        return result;
    }
}

