/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental.html;

import elemental.events.*;
import elemental.util.*;
import elemental.dom.*;
import elemental.html.*;
import elemental.css.*;
import elemental.stylesheets.*;

import java.util.Date;

/**
  * <p>The <code>HTMLAudioElement</code> interface provides access to the properties of <code><a rel="custom" href="https://developer.mozilla.org/en/HTML/Element/audio">&lt;audio&gt;</a></code>
&nbsp;elements, as well as methods to manipulate them. It's derived from the <a title="en/DOM/HTMLMediaElement" rel="internal" href="https://developer.mozilla.org/en/DOM/HTMLMediaElement" class=" new"><code>HTMLMediaElement</code></a> interface; it's implemented by <code><a rel="custom" href="https://developer.mozilla.org/en/XPCOM_Interface_Reference/nsIDOMHTMLMediaElement">nsIDOMHTMLMediaElement</a></code>
.</p>
<p>For details on how to use the audio streaming features exposed by this interface, please see <a title="en/Introducing the Audio API Extension" rel="internal" href="https://developer.mozilla.org/en/Introducing_the_Audio_API_Extension">Introducing the Audio API Extension</a>.</p>
  */
public interface AudioElement extends MediaElement {
}
