/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValuesIterator;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class DocValuesFieldExistsQuery
extends Query {
    private final String field;

    public DocValuesFieldExistsQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getField() {
        return this.field;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((DocValuesFieldExistsQuery)other).field);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.field.hashCode();
    }

    @Override
    public String toString(String field) {
        return "DocValuesFieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocValuesIterator iterator;
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(DocValuesFieldExistsQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                DocValuesType dvType = fieldInfo.getDocValuesType();
                LeafReader reader = context.reader();
                switch (dvType) {
                    case NONE: {
                        return null;
                    }
                    case NUMERIC: {
                        iterator = reader.getNumericDocValues(DocValuesFieldExistsQuery.this.field);
                        break;
                    }
                    case BINARY: {
                        iterator = reader.getBinaryDocValues(DocValuesFieldExistsQuery.this.field);
                        break;
                    }
                    case SORTED: {
                        iterator = reader.getSortedDocValues(DocValuesFieldExistsQuery.this.field);
                        break;
                    }
                    case SORTED_NUMERIC: {
                        iterator = reader.getSortedNumericDocValues(DocValuesFieldExistsQuery.this.field);
                        break;
                    }
                    case SORTED_SET: {
                        iterator = reader.getSortedSetDocValues(DocValuesFieldExistsQuery.this.field);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }
}

