/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Feature;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class FeatureComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof Feature && e2 instanceof Feature) {
            Feature feature1 = (Feature)e1;
            IVariable variable1 = feature1.getVariable();
            Feature feature2 = (Feature)e2;
            IVariable variable2 = feature2.getVariable();
            int columnIndex = this.getPropertyIndex();
            switch (columnIndex) {
                case 0: {
                    try {
                        double value1 = Double.parseDouble(variable1.getValue());
                        double value2 = Double.parseDouble(variable2.getValue());
                        sortOrder = Double.compare(value2, value1);
                    }
                    catch (Exception e) {
                        sortOrder = variable2.getValue().compareTo(variable1.getValue());
                    }
                    break;
                }
                case 1: {
                    sortOrder = Boolean.compare(variable2.isSelected(), variable1.isSelected());
                    break;
                }
                case 2: {
                    sortOrder = variable2.getClassification().compareTo(variable1.getClassification());
                    break;
                }
                case 3: {
                    sortOrder = variable2.getDescription().compareTo(variable1.getDescription());
                    break;
                }
                default: {
                    int index = columnIndex - 4;
                    List sampleData1 = feature1.getSampleData();
                    List sampleData2 = feature2.getSampleData();
                    sortOrder = sampleData1.size() > index && sampleData2.size() > index ? Double.compare(((ISampleData)sampleData2.get(index)).getData(), ((ISampleData)sampleData1.get(index)).getData()) : 0;
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

