/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.support.ColorSupport;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesData;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.ScatterSeriesData;

public class SeriesConverter {
    public static List<IScatterSeriesData> basisVectorsToSeries(IResultsPCA<? extends IResultPCA, ? extends IVariable> pcaResults, int pcX, int pcY) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        ArrayList<IScatterSeriesData> scatterSeriesDataList = new ArrayList<IScatterSeriesData>();
        List variables = pcaResults.getExtractedVariables();
        int i = 0;
        while (i < variables.size()) {
            IVariable variable = (IVariable)variables.get(i);
            String name = ((IVariable)variables.get(i)).getValue();
            double x = 0.0;
            x = pcX != 0 ? ((double[])pcaResults.getLoadingVectors().get(pcX - 1))[i] : (double)i;
            double y = ((double[])pcaResults.getLoadingVectors().get(pcY - 1))[i];
            SeriesData seriesData = new SeriesData(new double[]{x}, new double[]{y}, name);
            ScatterSeriesData scatterSeriesData = new ScatterSeriesData((ISeriesData)seriesData);
            IScatterSeriesSettings scatterSeriesSettings = scatterSeriesData.getSettings();
            scatterSeriesSettings.setSymbolColor(variable.isSelected() ? Colors.RED : Colors.GRAY);
            scatterSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.valueOf((String)preferenceStore.getString("loadingPlot2dSymbolType")));
            scatterSeriesSettings.setSymbolSize(preferenceStore.getInt("loadingPlot2dSymbolSize"));
            IScatterSeriesSettings scatterSeriesSettingsHighlight = (IScatterSeriesSettings)scatterSeriesSettings.getSeriesSettingsHighlight();
            scatterSeriesSettingsHighlight.setSymbolColor(Colors.RED);
            scatterSeriesSettingsHighlight.setSymbolSize(preferenceStore.getInt("loadingPlot2dSymbolSize") + 2);
            scatterSeriesDataList.add((IScatterSeriesData)scatterSeriesData);
            ++i;
        }
        return scatterSeriesDataList;
    }

    public static List<IScatterSeriesData> basisVectorsToSeriesDescription(IResultsPCA<? extends IResultPCA, ? extends IVariable> pcaResults, int pcX, int pcY) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        ArrayList<IScatterSeriesData> scatterSeriesDataList = new ArrayList<IScatterSeriesData>();
        List variables = pcaResults.getExtractedVariables();
        int i = 0;
        while (i < variables.size()) {
            IVariable variable = (IVariable)variables.get(i);
            String description = variable.getDescription();
            String name = null;
            name = description == null || description.isEmpty() ? ((IVariable)variables.get(i)).getValue() : description;
            double x = 0.0;
            x = pcX != 0 ? ((double[])pcaResults.getLoadingVectors().get(pcX - 1))[i] : (double)i;
            double y = ((double[])pcaResults.getLoadingVectors().get(pcY - 1))[i];
            SeriesData seriesData = new SeriesData(new double[]{x}, new double[]{y}, name);
            ScatterSeriesData scatterSeriesData = new ScatterSeriesData((ISeriesData)seriesData);
            IScatterSeriesSettings scatterSeriesSettings = scatterSeriesData.getSettings();
            if (variable.isSelected()) {
                scatterSeriesSettings.setSymbolColor(Colors.RED);
            } else {
                scatterSeriesSettings.setSymbolColor(Colors.GRAY);
            }
            scatterSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.valueOf((String)preferenceStore.getString("loadingPlot2dSymbolType")));
            scatterSeriesSettings.setSymbolSize(preferenceStore.getInt("loadingPlot2dSymbolSize"));
            IScatterSeriesSettings scatterSeriesSettingsHighlight = (IScatterSeriesSettings)scatterSeriesSettings.getSeriesSettingsHighlight();
            scatterSeriesSettingsHighlight.setSymbolColor(Colors.RED);
            scatterSeriesSettingsHighlight.setSymbolSize(preferenceStore.getInt("loadingPlot2dSymbolSize") + 2);
            scatterSeriesDataList.add((IScatterSeriesData)scatterSeriesData);
            ++i;
        }
        return scatterSeriesDataList;
    }

    public static List<IScatterSeriesData> sampleToSeries(IResultsPCA resultsPCA, int pcX, int pcY, Map<String, IResultPCA> extractedPcaResults) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        ArrayList<IScatterSeriesData> scatterSeriesDataList = new ArrayList<IScatterSeriesData>();
        extractedPcaResults.clear();
        List resultList = resultsPCA.getPcaResultList();
        Map<String, Color> colorMap = ColorSupport.getGroupNameColorMap(resultList);
        int i = 0;
        while (i < resultsPCA.getPcaResultList().size()) {
            IResultPCA pcaResult = (IResultPCA)resultList.get(i);
            String name = pcaResult.getName();
            extractedPcaResults.put(name, pcaResult);
            if (pcaResult.isDisplayed()) {
                double[] eigenSpace = pcaResult.getScoreVector();
                double x = 0.0;
                x = pcX != 0 ? eigenSpace[pcX - 1] : (double)i;
                double y = eigenSpace[pcY - 1];
                SeriesData seriesData = new SeriesData(new double[]{x}, new double[]{y}, name);
                ScatterSeriesData scatterSeriesData = new ScatterSeriesData((ISeriesData)seriesData);
                IScatterSeriesSettings scatterSeriesSettings = scatterSeriesData.getSettings();
                scatterSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.valueOf((String)preferenceStore.getString("scorePlot2dSymbolType")));
                scatterSeriesSettings.setSymbolSize(preferenceStore.getInt("scorePlot2dSymbolSize"));
                Color color = colorMap.get(pcaResult.getGroupName());
                if (pcaResult.getSample().isSelected()) {
                    scatterSeriesSettings.setSymbolColor(color);
                } else {
                    scatterSeriesSettings.setSymbolColor(Colors.GRAY);
                }
                IScatterSeriesSettings scatterSeriesSettingsHighlight = (IScatterSeriesSettings)scatterSeriesSettings.getSeriesSettingsHighlight();
                scatterSeriesSettingsHighlight.setSymbolColor(Colors.RED);
                scatterSeriesDataList.add((IScatterSeriesData)scatterSeriesData);
            }
            ++i;
        }
        return scatterSeriesDataList;
    }
}

