/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.io.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.msd.converter.supplier.csv.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedWavelengthSignalExtractor;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramWriter {
    public static final String RT_MILLISECONDS_COLUMN = "RT(milliseconds)";
    public static final String RT_MINUTES_COLUMN = "RT(minutes) - NOT USED BY IMPORT";
    public static final String RI_COLUMN = "RI";
    public static final String TIC_COLUMN = "TIC";

    public void writeChromatogram(File file, IChromatogram<? extends IPeak> chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        if (chromatogram instanceof IChromatogramCSD) {
            IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
            this.writeChromatogram(file, chromatogramCSD, monitor);
        } else if (chromatogram instanceof IChromatogramMSD) {
            IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
            this.writeChromatogram(file, chromatogramMSD, monitor);
        } else if (chromatogram instanceof IChromatogramWSD) {
            IChromatogramWSD chromatogramWSD = (IChromatogramWSD)chromatogram;
            this.writeChromatogram(file, chromatogramWSD, monitor);
        }
    }

    private void writeChromatogram(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)new FileWriter(file), CSVFormat.EXCEL);){
                this.writeTIC(csvPrinter, (IChromatogram<? extends IPeak>)chromatogram);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ChromatogramIsNullException e) {
            throw new IOException("The chromatogram is null.");
        }
    }

    private void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)new FileWriter(file), CSVFormat.EXCEL);){
                if (PreferenceSupplier.isUseTic()) {
                    this.writeTIC(csvPrinter, (IChromatogram<? extends IPeak>)chromatogram);
                } else {
                    ExtractedIonSignalExtractor extractedSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
                    IExtractedIonSignals extractedSignals = extractedSignalExtractor.getExtractedIonSignals();
                    int startIon = extractedSignals.getStartIon();
                    int stopIon = extractedSignals.getStopIon();
                    this.writeHeaderXIC(csvPrinter, startIon, stopIon);
                    this.writeScansXIC(csvPrinter, extractedSignals, startIon, stopIon);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ChromatogramIsNullException e) {
            throw new IOException("The chromatogram is null.");
        }
    }

    private void writeChromatogram(File file, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)new FileWriter(file), CSVFormat.EXCEL);){
                if (PreferenceSupplier.isUseTic()) {
                    this.writeTIC(csvPrinter, (IChromatogram<? extends IPeak>)chromatogram);
                } else {
                    ExtractedWavelengthSignalExtractor extractedSignalExtractor = new ExtractedWavelengthSignalExtractor(chromatogram);
                    IExtractedWavelengthSignals extractedSignals = extractedSignalExtractor.getExtractedWavelengthSignals();
                    int startWavelength = extractedSignals.getStartWavelength();
                    int stopWavelength = extractedSignals.getStopWavelength();
                    this.writeHeaderXIC(csvPrinter, startWavelength, stopWavelength);
                    this.writeScansXIC(csvPrinter, extractedSignals, startWavelength, stopWavelength);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ChromatogramIsNullException e) {
            throw new IOException("The chromatogram is null.");
        }
    }

    private void writeTIC(CSVPrinter csvPrinter, IChromatogram<? extends IPeak> chromatogram) throws IOException {
        TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(chromatogram);
        ITotalScanSignals totalScanSignals = totalIonSignalExtractor.getTotalScanSignals();
        this.writeHeaderTIC(csvPrinter);
        this.writeScansTIC(csvPrinter, totalScanSignals);
    }

    private void writeHeaderTIC(CSVPrinter csvFilePrinter) throws IOException {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(RT_MILLISECONDS_COLUMN);
        headerList.add(RT_MINUTES_COLUMN);
        headerList.add(RI_COLUMN);
        headerList.add(TIC_COLUMN);
        csvFilePrinter.printRecord(headerList);
    }

    private void writeHeaderXIC(CSVPrinter csvFilePrinter, int startTrace, int stopTrace) throws IOException {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(RT_MILLISECONDS_COLUMN);
        headerList.add(RT_MINUTES_COLUMN);
        headerList.add(RI_COLUMN);
        Integer ion = startTrace;
        while (ion <= stopTrace) {
            headerList.add(ion.toString());
            ion = ion + 1;
        }
        csvFilePrinter.printRecord(headerList);
    }

    private void writeScansTIC(CSVPrinter csvPrinter, ITotalScanSignals totalScanSignals) throws IOException {
        for (ITotalScanSignal totalScanSignal : totalScanSignals.getTotalScanSignals()) {
            ArrayList<Number> scanValues = new ArrayList<Number>();
            int milliseconds = totalScanSignal.getRetentionTime();
            scanValues.add(milliseconds);
            scanValues.add((double)milliseconds / 60000.0);
            scanValues.add(Float.valueOf(totalScanSignal.getRetentionIndex()));
            scanValues.add(Float.valueOf(totalScanSignal.getTotalSignal()));
            csvPrinter.printRecord(scanValues);
        }
    }

    private void writeScansXIC(CSVPrinter csvPrinter, IExtractedIonSignals extractedSignals, int startIon, int stopIon) throws IOException {
        for (IExtractedIonSignal extractedIonSignal : extractedSignals.getExtractedIonSignals()) {
            ArrayList<Number> scanValues = new ArrayList<Number>();
            int milliseconds = extractedIonSignal.getRetentionTime();
            scanValues.add(milliseconds);
            scanValues.add((double)milliseconds / 60000.0);
            scanValues.add(Float.valueOf(extractedIonSignal.getRetentionIndex()));
            int ion = startIon;
            while (ion <= stopIon) {
                scanValues.add(Float.valueOf(extractedIonSignal.getAbundance(ion)));
                ++ion;
            }
            csvPrinter.printRecord(scanValues);
        }
    }

    private void writeScansXIC(CSVPrinter csvPrinter, IExtractedWavelengthSignals extractedSignals, int startWavelength, int stopWavelength) throws IOException {
        for (IExtractedWavelengthSignal extractedSignal : extractedSignals.getExtractedWavelengthSignals()) {
            ArrayList<Number> scanValues = new ArrayList<Number>();
            int milliseconds = extractedSignal.getRetentionTime();
            scanValues.add(milliseconds);
            scanValues.add((double)milliseconds / 60000.0);
            scanValues.add(Float.valueOf(extractedSignal.getRetentionIndex()));
            int ion = startWavelength;
            while (ion <= stopWavelength) {
                scanValues.add(Float.valueOf(extractedSignal.getAbundance(ion)));
                ++ion;
            }
            csvPrinter.printRecord(scanValues);
        }
    }
}

