/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.noise;

import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.model.support.SegmentValidator;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.FilterException;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.implementation.CombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.support.CombinedMassSpectrumCalculator;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public class CalculatorSupport {
    private static final Logger logger = Logger.getLogger(CalculatorSupport.class);
    private static final float NORMALIZATION_FACTOR = 1000.0f;
    private final SegmentValidator segmentValidator = new SegmentValidator();

    public boolean acceptSegment(double[] values, double mean) {
        return this.segmentValidator.acceptSegment(values, mean);
    }

    public CombinedMassSpectrumCalculator getCombinedMassSpectrumCalculator(IAnalysisSegment analysisSegment, IExtractedIonSignals extractedIonSignals) {
        CombinedMassSpectrumCalculator combinedMassSpectrumCalculator = new CombinedMassSpectrumCalculator();
        int scan = analysisSegment.getStartScan();
        while (scan <= analysisSegment.getStopScan()) {
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                int ion = extractedIonSignal.getStartIon();
                while (ion <= extractedIonSignal.getStopIon()) {
                    combinedMassSpectrumCalculator.addIon(ion, extractedIonSignal.getAbundance(ion));
                    ++ion;
                }
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
        return combinedMassSpectrumCalculator;
    }

    public static ICombinedMassSpectrum getCombinedMassSpectrum(IExtractedIonSignals extractedIonSignals, IScanRange range) {
        CombinedMassSpectrumCalculator combinedMassSpectrumCalculator = new CombinedMassSpectrumCalculator();
        int scan = range.getStartScan();
        while (scan <= range.getStopScan()) {
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                int ion = extractedIonSignal.getStartIon();
                while (ion <= extractedIonSignal.getStopIon()) {
                    combinedMassSpectrumCalculator.addIon(ion, extractedIonSignal.getAbundance(ion));
                    ++ion;
                }
            }
            catch (NoExtractedIonSignalStoredException extractedIonSignal) {
                // empty catch block
            }
            ++scan;
        }
        combinedMassSpectrumCalculator.normalize(1000.0f);
        CombinedMassSpectrum noiseMassSpectrum = new CombinedMassSpectrum();
        Map<Integer, Double> ions = combinedMassSpectrumCalculator.getValuesIntensities();
        for (Integer ion : ions.keySet()) {
            float abundance = ions.get(ion).floatValue();
            if (!(abundance > 0.0f)) continue;
            try {
                Ion noiseIon = new Ion(ion.intValue(), abundance);
                noiseMassSpectrum.addIon(noiseIon);
            }
            catch (AbundanceLimitExceededException abundanceLimitExceededException) {
            }
            catch (IonLimitExceededException ionLimitExceededException) {
                // empty catch block
            }
        }
        return noiseMassSpectrum;
    }

    public ICombinedMassSpectrum getNoiseMassSpectrum(CombinedMassSpectrumCalculator combinedMassSpectrumCalculator, IMarkedIons ionsToPreserve, IProgressMonitor monitor) {
        combinedMassSpectrumCalculator.removeIons(ionsToPreserve);
        combinedMassSpectrumCalculator.normalize(1000.0f);
        CombinedMassSpectrum noiseMassSpectrum = new CombinedMassSpectrum();
        Map<Integer, Double> ions = combinedMassSpectrumCalculator.getValuesIntensities();
        for (Integer ion : ions.keySet()) {
            float abundance = ions.get(ion).floatValue();
            if (!(abundance > 0.0f)) continue;
            try {
                Ion noiseIon = new Ion(ion.intValue(), abundance);
                noiseMassSpectrum.addIon(noiseIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return noiseMassSpectrum;
    }

    public void checkScanRange(ScanRange scanRange, int segmentWidth) throws FilterException {
        if (scanRange == null || scanRange.getWidth() <= segmentWidth) {
            throw new FilterException("The selected scan width is lower than the segment width.");
        }
    }
}

