/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class ILibraryInformations {
    public static final Comparator<? super IIdentificationTarget> DEFAULT_TARGET_COMPARATOR = new TargetExtendedComparator(SortOrder.DESC);

    public static ILibraryInformation selectLibraryInformation(Collection<? extends IIdentificationTarget> targets) {
        return ILibraryInformations.selectLibraryInformation(targets, DEFAULT_TARGET_COMPARATOR);
    }

    public static ILibraryInformation selectLibraryInformation(Collection<? extends IIdentificationTarget> targets, Comparator<? super IIdentificationTarget> comparator) {
        ILibraryInformation libraryInformation = null;
        if (targets != null) {
            ArrayList<? extends IIdentificationTarget> copy = new ArrayList<IIdentificationTarget>(targets);
            Collections.sort(copy, comparator);
            if (targets.size() >= 1) {
                libraryInformation = ((IIdentificationTarget)copy.get(0)).getLibraryInformation();
            }
        }
        return libraryInformation;
    }
}

